/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.controller.account;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.broadleafcommerce.common.exception.ServiceException;
import org.broadleafcommerce.common.web.controller.BroadleafAbstractController;
import org.broadleafcommerce.core.web.controller.account.UpdateAccountForm;
import org.broadleafcommerce.core.web.controller.account.validator.UpdateAccountValidator;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.core.service.CustomerService;
import org.broadleafcommerce.profile.web.core.CustomerState;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.authentication.AuthenticationCredentialsNotFoundException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

public class BroadleafUpdateAccountController
extends BroadleafAbstractController {
    @Value(value="${use.email.for.site.login:true}")
    protected boolean useEmailForLogin;
    @Resource(name="blUserDetailsService")
    private UserDetailsService userDetailsService;
    @Resource(name="blCustomerService")
    protected CustomerService customerService;
    @Resource(name="blUpdateAccountValidator")
    protected UpdateAccountValidator updateAccountValidator;
    protected String accountUpdatedMessage = "Account successfully updated";
    protected static String updateAccountView = "account/updateAccount";
    protected static String accountRedirectView = "redirect:/account";

    public String viewUpdateAccount(HttpServletRequest request, Model model, UpdateAccountForm form) {
        Customer customer = CustomerState.getCustomer();
        form.setEmailAddress(customer.getEmailAddress());
        form.setFirstName(customer.getFirstName());
        form.setLastName(customer.getLastName());
        return this.getUpdateAccountView();
    }

    public String processUpdateAccount(HttpServletRequest request, Model model, UpdateAccountForm form, BindingResult result, RedirectAttributes redirectAttributes) throws ServiceException {
        this.updateAccountValidator.validate(form, (Errors)result);
        if (result.hasErrors()) {
            return this.getUpdateAccountView();
        }
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth == null || !auth.isAuthenticated()) {
            throw new AuthenticationCredentialsNotFoundException("Authentication was null, not authenticated, or not logged in.");
        }
        Customer customer = CustomerState.getCustomer();
        customer.setEmailAddress(form.getEmailAddress());
        customer.setFirstName(form.getFirstName());
        customer.setLastName(form.getLastName());
        if (this.useEmailForLogin) {
            customer.setUsername(form.getEmailAddress());
        }
        customer = this.customerService.saveCustomer(customer);
        if (this.useEmailForLogin) {
            UserDetails principal = this.userDetailsService.loadUserByUsername(customer.getUsername());
            UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)principal, (Object)principal.getPassword(), auth.getAuthorities());
            SecurityContextHolder.getContext().setAuthentication((Authentication)token);
        }
        redirectAttributes.addFlashAttribute("successMessage", (Object)this.getAccountUpdatedMessage());
        return this.getAccountRedirectView();
    }

    public String getUpdateAccountView() {
        return updateAccountView;
    }

    public String getAccountRedirectView() {
        return accountRedirectView;
    }

    public String getAccountUpdatedMessage() {
        return this.accountUpdatedMessage;
    }
}

