/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.controller.account;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.service.type.OrderStatus;
import org.broadleafcommerce.core.web.controller.account.AbstractAccountController;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.web.core.CustomerState;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.ui.Model;

public class BroadleafOrderHistoryController
extends AbstractAccountController {
    @Value(value="${validate.customer.owned.data:true}")
    protected boolean validateCustomerOwnedData;
    protected static String orderHistoryView = "account/orderHistory";
    protected static String orderDetailsView = "account/partials/orderDetails";
    protected static String orderDetailsRedirectView = "account/partials/orderDetails";

    public String viewOrderHistory(HttpServletRequest request, Model model) {
        List orders = this.orderService.findOrdersForCustomer(CustomerState.getCustomer(), OrderStatus.SUBMITTED);
        model.addAttribute("orders", (Object)orders);
        return this.getOrderHistoryView();
    }

    public String viewOrderDetails(HttpServletRequest request, Model model, String orderNumber) {
        Order order = this.orderService.findOrderByOrderNumber(orderNumber);
        if (order == null) {
            throw new IllegalArgumentException("The orderNumber provided is not valid");
        }
        this.validateCustomerOwnedData(order);
        model.addAttribute("order", (Object)order);
        return this.isAjaxRequest(request) ? this.getOrderDetailsView() : this.getOrderDetailsRedirectView();
    }

    public String getOrderHistoryView() {
        return orderHistoryView;
    }

    public String getOrderDetailsView() {
        return orderDetailsView;
    }

    public String getOrderDetailsRedirectView() {
        return orderDetailsRedirectView;
    }

    protected void validateCustomerOwnedData(Order order) {
        if (this.validateCustomerOwnedData) {
            Customer activeCustomer = CustomerState.getCustomer();
            if (activeCustomer != null && !activeCustomer.equals(order.getCustomer())) {
                throw new SecurityException("The active customer does not own the object that they are trying to view, edit, or remove.");
            }
            if (activeCustomer == null && order.getCustomer() != null) {
                throw new SecurityException("The active customer does not own the object that they are trying to view, edit, or remove.");
            }
        }
    }
}

