/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.catalog;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.annotation.Resource;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.util.BLCSystemProperty;
import org.broadleafcommerce.common.web.BLCAbstractHandlerMapping;
import org.broadleafcommerce.common.web.BroadleafRequestContext;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.catalog.service.CatalogService;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.ServletRequestBindingException;
import org.springframework.web.bind.ServletRequestUtils;

public class ProductHandlerMapping
extends BLCAbstractHandlerMapping {
    private static final Log LOG = LogFactory.getLog(ProductHandlerMapping.class);
    private final String controllerName = "blProductController";
    @Value(value="${solr.index.use.sku}")
    protected boolean useSku;
    @Resource(name="blCatalogService")
    private CatalogService catalogService;
    protected String defaultTemplateName = "catalog/product";
    public static final String CURRENT_PRODUCT_ATTRIBUTE_NAME = "currentProduct";
    @Value(value="${request.uri.encoding}")
    public String charEncoding;

    protected Object getHandlerInternal(HttpServletRequest request) throws Exception {
        BroadleafRequestContext context = BroadleafRequestContext.getBroadleafRequestContext();
        if (context != null) {
            if (this.shouldSkipExecution(context)) {
                return null;
            }
            Product product = null;
            if (this.allowProductResolutionUsingIdParam()) {
                product = this.findProductUsingIdParam(context);
            }
            if (product == null) {
                product = this.findProductUsingUrl(context);
            }
            if (product != null) {
                context.getRequest().setAttribute(CURRENT_PRODUCT_ATTRIBUTE_NAME, (Object)product);
                return "blProductController";
            }
        }
        return null;
    }

    protected Product findProductUsingIdParam(BroadleafRequestContext context) throws ServletRequestBindingException {
        Long productId = ServletRequestUtils.getLongParameter((ServletRequest)context.getRequest(), (String)"productId");
        if (productId != null) {
            Product product = this.catalogService.findProductById(productId);
            if (product != null && LOG.isDebugEnabled()) {
                LOG.debug((Object)("Obtained the product using id=" + productId));
            }
            return product;
        }
        return null;
    }

    protected Product findProductUsingUrl(BroadleafRequestContext context) throws ServletRequestBindingException, UnsupportedEncodingException {
        String requestUri = URLDecoder.decode(context.getRequestURIWithoutContext(), this.charEncoding);
        Product product = this.catalogService.findProductByURI(requestUri);
        if (product != null && LOG.isDebugEnabled()) {
            LOG.debug((Object)("Obtained the product using URI=" + requestUri));
        }
        return product;
    }

    public String getDefaultTemplateName() {
        return this.defaultTemplateName;
    }

    public void setDefaultTemplateName(String defaultTemplateName) {
        this.defaultTemplateName = defaultTemplateName;
    }

    public boolean allowProductResolutionUsingIdParam() {
        return BLCSystemProperty.resolveBooleanSystemProperty((String)"allowProductResolutionUsingIdParam");
    }

    public boolean allowCategoryResolutionUsingIdParam() {
        return BLCSystemProperty.resolveBooleanSystemProperty((String)"allowCategoryResolutionUsingIdParam");
    }

    public boolean shouldSkipExecution(BroadleafRequestContext context) throws ServletRequestBindingException {
        if (this.useSku) {
            return true;
        }
        return this.allowCategoryResolutionUsingIdParam() && ServletRequestUtils.getLongParameter((ServletRequest)context.getRequest(), (String)"categoryId") != null;
    }
}

