/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.breadcrumbs;

import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.broadleafcommerce.common.breadcrumbs.dto.BreadcrumbDTO;
import org.broadleafcommerce.common.breadcrumbs.dto.BreadcrumbDTOType;
import org.broadleafcommerce.common.breadcrumbs.service.BreadcrumbServiceExtensionManager;
import org.broadleafcommerce.common.extension.ExtensionHandler;
import org.broadleafcommerce.common.extension.ExtensionResultHolder;
import org.broadleafcommerce.common.extension.ExtensionResultStatusType;
import org.broadleafcommerce.common.web.BroadleafRequestContext;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.web.breadcrumbs.AbstractBreadcrumbServiceExtensionHandler;
import org.springframework.stereotype.Service;

@Service(value="blProductBreadcrumbServiceExtensionHandler")
public class ProductBreadcrumbServiceExtensionHandler
extends AbstractBreadcrumbServiceExtensionHandler {
    @Resource(name="blBreadcrumbServiceExtensionManager")
    protected BreadcrumbServiceExtensionManager extensionManager;

    @PostConstruct
    public void init() {
        if (this.isEnabled()) {
            this.extensionManager.registerHandler((ExtensionHandler)this);
        }
    }

    @Override
    public ExtensionResultStatusType modifyBreadcrumbList(String url, Map<String, String[]> params, ExtensionResultHolder<List<BreadcrumbDTO>> holder) {
        Product product = this.determineProduct(url, params, holder);
        if (product != null) {
            BreadcrumbDTO productDto = new BreadcrumbDTO();
            productDto.setText(this.getNameForProductLink(product));
            productDto.setLink(this.buildLink(url, params));
            productDto.setType(BreadcrumbDTOType.PRODUCT);
            ((List)holder.getResult()).add(0, productDto);
        }
        this.updateContextMap(url, params, holder);
        return ExtensionResultStatusType.HANDLED_CONTINUE;
    }

    protected Product determineProduct(String url, Map<String, String[]> params, ExtensionResultHolder<List<BreadcrumbDTO>> holder) {
        BroadleafRequestContext brc = BroadleafRequestContext.getBroadleafRequestContext();
        if (brc != null) {
            return (Product)brc.getRequestAttribute("currentProduct");
        }
        return null;
    }

    protected String getNameForProductLink(Product product) {
        return product.getName();
    }

    protected void updateContextMap(String origUrl, Map<String, String[]> params, ExtensionResultHolder<List<BreadcrumbDTO>> holder) {
        int pos;
        Map contextMap = holder.getContextMap();
        if (params != null && params.containsKey(this.getProductIdParam())) {
            params.remove(this.getProductIdParam());
            contextMap.put(BreadcrumbServiceExtensionManager.CONTEXT_PARAM_STRIPPED_PARAMS, params);
        }
        if ((pos = origUrl.lastIndexOf("/")) > 0) {
            String newUrl = origUrl.substring(0, pos);
            contextMap.put(BreadcrumbServiceExtensionManager.CONTEXT_PARAM_STRIPPED_URL, newUrl);
        }
    }

    protected String getProductIdParam() {
        return "productId";
    }

    @Override
    public int getDefaultPriority() {
        return 4000;
    }
}

