/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.breadcrumbs;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.breadcrumbs.dto.BreadcrumbDTO;
import org.broadleafcommerce.common.breadcrumbs.dto.BreadcrumbDTOType;
import org.broadleafcommerce.common.breadcrumbs.service.BreadcrumbServiceExtensionManager;
import org.broadleafcommerce.common.extension.ExtensionHandler;
import org.broadleafcommerce.common.extension.ExtensionResultHolder;
import org.broadleafcommerce.common.extension.ExtensionResultStatusType;
import org.broadleafcommerce.common.web.BroadleafRequestContext;
import org.broadleafcommerce.core.catalog.domain.Category;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.catalog.service.CatalogService;
import org.broadleafcommerce.core.web.breadcrumbs.AbstractBreadcrumbServiceExtensionHandler;
import org.springframework.stereotype.Service;

@Service(value="blCategoryBreadcrumbServiceExtensionHandler")
public class CategoryBreadcrumbServiceExtensionHandler
extends AbstractBreadcrumbServiceExtensionHandler {
    private static final Log LOG = LogFactory.getLog(CategoryBreadcrumbServiceExtensionHandler.class);
    @Resource(name="blCatalogService")
    protected CatalogService catalogService;
    @Resource(name="blBreadcrumbServiceExtensionManager")
    protected BreadcrumbServiceExtensionManager extensionManager;

    @PostConstruct
    public void init() {
        if (this.isEnabled()) {
            this.extensionManager.registerHandler((ExtensionHandler)this);
        }
    }

    @Override
    public ExtensionResultStatusType modifyBreadcrumbList(String url, Map<String, String[]> params, ExtensionResultHolder<List<BreadcrumbDTO>> holder) {
        Category category;
        String testUrl = (String)holder.getContextMap().get(BreadcrumbServiceExtensionManager.CONTEXT_PARAM_STRIPPED_URL);
        if (StringUtils.isEmpty((CharSequence)testUrl)) {
            testUrl = url;
        }
        if ((category = this.determineFirstCategory(testUrl, params, holder)) != null) {
            BreadcrumbDTO categoryCrumb = this.buildCrumbForCategory(category, url, params);
            BreadcrumbDTO categorySearchCrumb = this.buildCategorySearchCrumb(category, url, params);
            ArrayList<BreadcrumbDTO> parentCrumbs = new ArrayList<BreadcrumbDTO>();
            this.addParentCrumbs(parentCrumbs, category, url, params);
            if (categorySearchCrumb != null) {
                ((List)holder.getResult()).add(0, categorySearchCrumb);
            }
            if (categoryCrumb != null) {
                ((List)holder.getResult()).add(0, categoryCrumb);
            }
            if (!parentCrumbs.isEmpty()) {
                ((List)holder.getResult()).addAll(0, parentCrumbs);
            }
        }
        return ExtensionResultStatusType.HANDLED_CONTINUE;
    }

    protected BreadcrumbDTO buildCrumbForCategory(Category category, String url, Map<String, String[]> params) {
        BreadcrumbDTO categoryDto = null;
        if (category != null) {
            categoryDto = new BreadcrumbDTO();
            categoryDto.setText(this.getNameForCategoryLink(category));
            categoryDto.setLink(category.getUrl());
            categoryDto.setType(BreadcrumbDTOType.CATEGORY);
        }
        return categoryDto;
    }

    protected void addParentCrumbs(List<BreadcrumbDTO> parentCrumbs, Category category, String url, Map<String, String[]> params) {
        Category parentCategory = category.getParentCategory();
        if (parentCategory != null && !parentCrumbs.contains(parentCategory)) {
            BreadcrumbDTO dto = this.buildCrumbForCategory(parentCategory, url, params);
            parentCrumbs.add(0, dto);
            this.addParentCrumbs(parentCrumbs, parentCategory, url, params);
        }
    }

    protected BreadcrumbDTO buildCategorySearchCrumb(Category category, String url, Map<String, String[]> params) {
        return null;
    }

    protected String getNameForCategoryLink(Category category) {
        return category.getName();
    }

    protected Category determineFirstCategory(String testUrl, Map<String, String[]> params, ExtensionResultHolder<List<BreadcrumbDTO>> holder) {
        BroadleafRequestContext brc = BroadleafRequestContext.getBroadleafRequestContext();
        Category returnCategory = null;
        if (brc != null && brc.getRequest() != null) {
            if (returnCategory == null) {
                returnCategory = this.getMatchingCategoryFromProduct(brc, testUrl, params);
            }
            if (returnCategory == null) {
                returnCategory = this.getCategoryFromCategoryAttribute(brc, testUrl, params);
            }
            if (returnCategory == null) {
                returnCategory = this.getCategoryFromUrl(brc, testUrl, params);
            }
        }
        return returnCategory;
    }

    protected Category getMatchingCategoryFromProduct(BroadleafRequestContext brc, String testUrl, Map<String, String[]> params) {
        Category testCategory;
        Product product;
        if (brc != null && (product = (Product)brc.getRequestAttribute("currentProduct")) != null && (testCategory = product.getCategory()) != null && testUrl != null && testUrl.equals(testCategory.getUrl())) {
            return testCategory;
        }
        return null;
    }

    protected Category getCategoryFromCategoryAttribute(BroadleafRequestContext brc, String testUrl, Map<String, String[]> params) {
        return (Category)brc.getRequestAttribute("category");
    }

    protected Category getCategoryFromUrl(BroadleafRequestContext brc, String requestUrl, Map<String, String[]> params) {
        return this.catalogService.findCategoryByURI(requestUrl);
    }

    @Override
    public int getDefaultPriority() {
        return 2000;
    }
}

