/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.api.wrapper;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.catalog.domain.Sku;
import org.broadleafcommerce.core.search.domain.SearchFacetDTO;
import org.broadleafcommerce.core.search.domain.SearchResult;
import org.broadleafcommerce.core.web.api.wrapper.APIWrapper;
import org.broadleafcommerce.core.web.api.wrapper.BaseWrapper;
import org.broadleafcommerce.core.web.api.wrapper.ProductWrapper;
import org.broadleafcommerce.core.web.api.wrapper.SearchFacetWrapper;
import org.broadleafcommerce.core.web.api.wrapper.SkuWrapper;

@XmlRootElement(name="searchResults")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class SearchResultsWrapper
extends BaseWrapper
implements APIWrapper<SearchResult> {
    @XmlElement
    protected Integer page;
    @XmlElement
    protected Integer pageSize;
    @XmlElement
    protected Integer totalResults;
    @XmlElement
    protected Integer totalPages;
    @XmlElementWrapper(name="products")
    @XmlElement(name="product")
    protected List<ProductWrapper> products;
    @XmlElementWrapper(name="skus")
    @XmlElement(name="sku")
    protected List<SkuWrapper> skus;
    @XmlElementWrapper(name="searchFacets")
    @XmlElement(name="searchFacet")
    protected List<SearchFacetWrapper> searchFacets;

    @Override
    public void wrapDetails(SearchResult model, HttpServletRequest request) {
        this.page = model.getPage();
        this.pageSize = model.getPageSize();
        this.totalResults = model.getTotalResults();
        this.totalPages = model.getTotalPages();
        if (model.getProducts() != null) {
            this.products = new ArrayList<ProductWrapper>();
            for (Product product : model.getProducts()) {
                ProductWrapper productSummary = (ProductWrapper)this.context.getBean(ProductWrapper.class.getName());
                productSummary.wrapSummary(product, request);
                this.products.add(productSummary);
            }
        }
        if (model.getSkus() != null) {
            this.skus = new ArrayList<SkuWrapper>();
            for (Sku sku : model.getSkus()) {
                SkuWrapper skuSummary = (SkuWrapper)this.context.getBean(SkuWrapper.class.getName());
                skuSummary.wrapSummary(sku, request);
                this.skus.add(skuSummary);
            }
        }
        if (model.getFacets() != null) {
            this.searchFacets = new ArrayList<SearchFacetWrapper>();
            for (SearchFacetDTO facet : model.getFacets()) {
                SearchFacetWrapper facetWrapper = (SearchFacetWrapper)this.context.getBean(SearchFacetWrapper.class.getName());
                facetWrapper.wrapSummary(facet, request);
                this.searchFacets.add(facetWrapper);
            }
        }
    }

    @Override
    public void wrapSummary(SearchResult model, HttpServletRequest request) {
        this.wrapDetails(model, request);
    }

    public Integer getPage() {
        return this.page;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Integer getTotalResults() {
        return this.totalResults;
    }

    public void setTotalResults(Integer totalResults) {
        this.totalResults = totalResults;
    }

    public Integer getTotalPages() {
        return this.totalPages;
    }

    public void setTotalPages(Integer totalPages) {
        this.totalPages = totalPages;
    }

    public List<ProductWrapper> getProducts() {
        return this.products;
    }

    public void setProducts(List<ProductWrapper> products) {
        this.products = products;
    }

    public List<SkuWrapper> getSkus() {
        return this.skus;
    }

    public void setSkus(List<SkuWrapper> skus) {
        this.skus = skus;
    }

    public List<SearchFacetWrapper> getSearchFacets() {
        return this.searchFacets;
    }

    public void setSearchFacets(List<SearchFacetWrapper> searchFacets) {
        this.searchFacets = searchFacets;
    }
}

