/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.api;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.type.TypeModifier;
import java.util.List;
import javax.annotation.Resource;
import org.broadleafcommerce.core.web.api.WrapperOverrideTypeModifier;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.http.converter.xml.MappingJackson2XmlHttpMessageConverter;
import org.springframework.web.servlet.config.annotation.ContentNegotiationConfigurer;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

public class BroadleafRestApiMvcConfiguration
extends WebMvcConfigurerAdapter {
    @Resource(name="blWrapperOverrideTypeModifier")
    protected WrapperOverrideTypeModifier typeModifier;

    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        converters.add(this.getJsonConverter());
        converters.add(this.getXmlConverter());
    }

    public void configureContentNegotiation(ContentNegotiationConfigurer configurer) {
        configurer.defaultContentType(MediaType.APPLICATION_JSON);
    }

    protected HttpMessageConverter<?> getJsonConverter() {
        return new MappingJackson2HttpMessageConverter(this.getObjectMapper(false));
    }

    protected HttpMessageConverter<?> getXmlConverter() {
        return new MappingJackson2XmlHttpMessageConverter(this.getObjectMapper(true));
    }

    protected ObjectMapper getObjectMapper(boolean useXml) {
        Jackson2ObjectMapperBuilder builder = this.getObjectMapperBuilder();
        TypeFactory factory = TypeFactory.defaultInstance().withModifier((TypeModifier)this.typeModifier);
        if (useXml) {
            return builder.createXmlMapper(true).build().setTypeFactory(factory);
        }
        return builder.build().setTypeFactory(factory);
    }

    protected Jackson2ObjectMapperBuilder getObjectMapperBuilder() {
        return new Jackson2ObjectMapperBuilder().findModulesViaServiceLoader(true).featuresToEnable(new Object[]{DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY}).featuresToDisable(new Object[]{SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED});
    }
}

