/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.controller.catalog;

import java.util.HashSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.broadleafcommerce.common.template.TemplateType;
import org.broadleafcommerce.common.web.BroadleafRequestContext;
import org.broadleafcommerce.common.web.TemplateTypeAware;
import org.broadleafcommerce.common.web.controller.BroadleafAbstractController;
import org.broadleafcommerce.common.web.deeplink.DeepLinkService;
import org.broadleafcommerce.core.catalog.domain.Sku;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.Controller;

public class BroadleafSkuController
extends BroadleafAbstractController
implements Controller,
TemplateTypeAware {
    protected String defaultSkuView = "catalog/sku";
    protected static String MODEL_ATTRIBUTE_NAME = "sku";
    protected static String ALL_SKUS_ATTRIBUTE_NAME = "blcAllDisplayedSkus";
    @Autowired(required=false)
    @Qualifier(value="blSkuDeepLinkService")
    protected DeepLinkService<Sku> deepLinkService;

    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView model = new ModelAndView();
        Sku sku = (Sku)request.getAttribute("currentSku");
        assert (sku != null);
        model.addObject(MODEL_ATTRIBUTE_NAME, (Object)sku);
        HashSet<Sku> allSkusSet = new HashSet<Sku>();
        allSkusSet.add(sku);
        model.addObject(ALL_SKUS_ATTRIBUTE_NAME, new HashSet(allSkusSet));
        this.addDeepLink(model, this.deepLinkService, sku);
        if (StringUtils.isNotEmpty((CharSequence)sku.getDisplayTemplate())) {
            model.setViewName(sku.getDisplayTemplate());
        } else {
            model.setViewName(this.getDefaultSkuView());
        }
        return model;
    }

    public String getDefaultSkuView() {
        return this.defaultSkuView;
    }

    public void setDefaultSkuView(String defaultSkuView) {
        this.defaultSkuView = defaultSkuView;
    }

    public String getExpectedTemplateName(HttpServletRequest request) {
        Sku sku;
        BroadleafRequestContext context = BroadleafRequestContext.getBroadleafRequestContext();
        if (context != null && (sku = (Sku)context.getRequest().getAttribute("currentSku")) != null && sku.getDisplayTemplate() != null) {
            return sku.getDisplayTemplate();
        }
        return this.getDefaultSkuView();
    }

    public TemplateType getTemplateType(HttpServletRequest request) {
        return TemplateType.SKU;
    }
}

