/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.catalog;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.broadleafcommerce.common.web.BLCAbstractHandlerMapping;
import org.broadleafcommerce.common.web.BroadleafRequestContext;
import org.broadleafcommerce.core.catalog.domain.Sku;
import org.broadleafcommerce.core.catalog.service.CatalogService;
import org.springframework.beans.factory.annotation.Value;

public class SkuHandlerMapping
extends BLCAbstractHandlerMapping {
    private String controllerName = "blSkuController";
    @Value(value="${solr.index.use.sku}")
    protected boolean useSku;
    @Resource(name="blCatalogService")
    private CatalogService catalogService;
    protected String defaultTemplateName = "catalog/sku";
    public static final String CURRENT_SKU_ATTRIBUTE_NAME = "currentSku";

    protected Object getHandlerInternal(HttpServletRequest request) throws Exception {
        Sku sku;
        if (!this.useSku) {
            return null;
        }
        BroadleafRequestContext context = BroadleafRequestContext.getBroadleafRequestContext();
        if (context != null && context.getRequestURIWithoutContext() != null && (sku = this.catalogService.findSkuByURI(context.getRequestURIWithoutContext())) != null) {
            context.getRequest().setAttribute(CURRENT_SKU_ATTRIBUTE_NAME, (Object)sku);
            return this.controllerName;
        }
        return null;
    }

    public String getDefaultTemplateName() {
        return this.defaultTemplateName;
    }

    public void setDefaultTemplateName(String defaultTemplateName) {
        this.defaultTemplateName = defaultTemplateName;
    }
}

