/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.catalog;

import java.net.URLDecoder;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.broadleafcommerce.common.web.BLCAbstractHandlerMapping;
import org.broadleafcommerce.common.web.BroadleafRequestContext;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.catalog.service.CatalogService;
import org.springframework.beans.factory.annotation.Value;

public class ProductHandlerMapping
extends BLCAbstractHandlerMapping {
    private final String controllerName = "blProductController";
    @Value(value="${solr.index.use.sku}")
    protected boolean useSku;
    @Resource(name="blCatalogService")
    private CatalogService catalogService;
    protected String defaultTemplateName = "catalog/product";
    public static final String CURRENT_PRODUCT_ATTRIBUTE_NAME = "currentProduct";
    @Value(value="${request.uri.encoding}")
    public String charEncoding;

    protected Object getHandlerInternal(HttpServletRequest request) throws Exception {
        String requestUri;
        Product product;
        if (this.useSku) {
            return null;
        }
        BroadleafRequestContext context = BroadleafRequestContext.getBroadleafRequestContext();
        if (context != null && context.getRequestURIWithoutContext() != null && (product = this.catalogService.findProductByURI(requestUri = URLDecoder.decode(context.getRequestURIWithoutContext(), this.charEncoding))) != null) {
            context.getRequest().setAttribute(CURRENT_PRODUCT_ATTRIBUTE_NAME, (Object)product);
            return "blProductController";
        }
        return null;
    }

    public String getDefaultTemplateName() {
        return this.defaultTemplateName;
    }

    public void setDefaultTemplateName(String defaultTemplateName) {
        this.defaultTemplateName = defaultTemplateName;
    }
}

