/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.api.wrapper;

import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.common.util.xml.ISO8601DateAdapter;
import org.broadleafcommerce.core.catalog.domain.Sku;
import org.broadleafcommerce.core.web.api.wrapper.APIWrapper;
import org.broadleafcommerce.core.web.api.wrapper.BaseWrapper;
import org.broadleafcommerce.core.web.api.wrapper.DimensionWrapper;
import org.broadleafcommerce.core.web.api.wrapper.WeightWrapper;

@XmlRootElement(name="sku")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class SkuWrapper
extends BaseWrapper
implements APIWrapper<Sku> {
    @XmlElement
    protected Long id;
    @XmlElement
    @XmlJavaTypeAdapter(value=ISO8601DateAdapter.class)
    protected Date activeStartDate;
    @XmlElement
    @XmlJavaTypeAdapter(value=ISO8601DateAdapter.class)
    protected Date activeEndDate;
    @XmlElement
    protected String name;
    @XmlElement
    protected Boolean active;
    @XmlElement
    protected String inventoryType;
    @XmlElement
    protected String description;
    @XmlElement
    protected Money retailPrice;
    @XmlElement
    protected Money salePrice;
    @XmlElement
    protected WeightWrapper weight;
    @XmlElement
    protected DimensionWrapper dimension;

    @Override
    public void wrapDetails(Sku model, HttpServletRequest request) {
        this.id = model.getId();
        this.activeStartDate = model.getActiveStartDate();
        this.activeEndDate = model.getActiveEndDate();
        this.name = model.getName();
        this.description = model.getDescription();
        this.retailPrice = model.getRetailPrice();
        this.salePrice = model.getSalePrice();
        this.active = model.isActive();
        if (model.getInventoryType() != null) {
            this.inventoryType = model.getInventoryType().getType();
        }
        if (model.getWeight() != null) {
            this.weight = (WeightWrapper)this.context.getBean(WeightWrapper.class.getName());
            this.weight.wrapDetails(model.getWeight(), request);
        }
        if (model.getDimension() != null) {
            this.dimension = (DimensionWrapper)this.context.getBean(DimensionWrapper.class.getName());
            this.dimension.wrapDetails(model.getDimension(), request);
        }
    }

    @Override
    public void wrapSummary(Sku model, HttpServletRequest request) {
        this.wrapDetails(model, request);
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Date getActiveStartDate() {
        return this.activeStartDate;
    }

    public void setActiveStartDate(Date activeStartDate) {
        this.activeStartDate = activeStartDate;
    }

    public Date getActiveEndDate() {
        return this.activeEndDate;
    }

    public void setActiveEndDate(Date activeEndDate) {
        this.activeEndDate = activeEndDate;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public String getInventoryType() {
        return this.inventoryType;
    }

    public void setInventoryType(String inventoryType) {
        this.inventoryType = inventoryType;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Money getRetailPrice() {
        return this.retailPrice;
    }

    public void setRetailPrice(Money retailPrice) {
        this.retailPrice = retailPrice;
    }

    public Money getSalePrice() {
        return this.salePrice;
    }

    public void setSalePrice(Money salePrice) {
        this.salePrice = salePrice;
    }

    public WeightWrapper getWeight() {
        return this.weight;
    }

    public void setWeight(WeightWrapper weight) {
        this.weight = weight;
    }

    public DimensionWrapper getDimension() {
        return this.dimension;
    }

    public void setDimension(DimensionWrapper dimension) {
        this.dimension = dimension;
    }
}

