/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.api.wrapper;

import javax.servlet.http.HttpServletRequest;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.core.catalog.domain.SkuBundleItem;
import org.broadleafcommerce.core.web.api.wrapper.APIWrapper;
import org.broadleafcommerce.core.web.api.wrapper.BaseWrapper;
import org.broadleafcommerce.core.web.api.wrapper.SkuWrapper;

@XmlRootElement(name="skuBundleItem")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class SkuBundleItemWrapper
extends BaseWrapper
implements APIWrapper<SkuBundleItem> {
    @XmlElement
    protected Long id;
    @XmlElement
    protected Integer quantity;
    @XmlElement
    protected Money salePrice;
    @XmlElement
    protected Money retailPrice;
    @XmlElement
    protected Long bundleId;
    @XmlElement
    protected SkuWrapper sku;
    @XmlElement
    protected String name;
    @XmlElement
    protected Boolean active;
    @XmlElement
    protected String description;
    @XmlElement
    protected String longDescription;
    @XmlElement
    private Long productId;

    @Override
    public void wrapDetails(SkuBundleItem model, HttpServletRequest request) {
        this.id = model.getId();
        this.quantity = model.getQuantity();
        this.salePrice = model.getSalePrice();
        this.retailPrice = model.getRetailPrice();
        this.bundleId = model.getBundle().getId();
        this.name = model.getSku().getName();
        this.description = model.getSku().getDescription();
        this.longDescription = model.getSku().getLongDescription();
        this.active = model.getSku().isActive();
        this.productId = model.getSku().getProduct().getId();
    }

    @Override
    public void wrapSummary(SkuBundleItem model, HttpServletRequest request) {
        this.wrapDetails(model, request);
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public Money getSalePrice() {
        return this.salePrice;
    }

    public void setSalePrice(Money salePrice) {
        this.salePrice = salePrice;
    }

    public Money getRetailPrice() {
        return this.retailPrice;
    }

    public void setRetailPrice(Money retailPrice) {
        this.retailPrice = retailPrice;
    }

    public Long getBundleId() {
        return this.bundleId;
    }

    public void setBundleId(Long bundleId) {
        this.bundleId = bundleId;
    }

    public SkuWrapper getSku() {
        return this.sku;
    }

    public void setSku(SkuWrapper sku) {
        this.sku = sku;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getLongDescription() {
        return this.longDescription;
    }

    public void setLongDescription(String longDescription) {
        this.longDescription = longDescription;
    }

    public Long getProductId() {
        return this.productId;
    }

    public void setProductId(Long productId) {
        this.productId = productId;
    }
}

