/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.api.wrapper;

import javax.servlet.http.HttpServletRequest;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.broadleafcommerce.common.payment.PaymentType;
import org.broadleafcommerce.core.payment.domain.secure.BankAccountPayment;
import org.broadleafcommerce.core.payment.domain.secure.CreditCardPayment;
import org.broadleafcommerce.core.payment.domain.secure.GiftCardPayment;
import org.broadleafcommerce.core.payment.domain.secure.Referenced;
import org.broadleafcommerce.core.payment.service.SecureOrderPaymentService;
import org.broadleafcommerce.core.web.api.wrapper.APIUnwrapper;
import org.broadleafcommerce.core.web.api.wrapper.APIWrapper;
import org.broadleafcommerce.core.web.api.wrapper.BaseWrapper;
import org.springframework.context.ApplicationContext;

@XmlRootElement(name="referenced")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ReferencedWrapper
extends BaseWrapper
implements APIWrapper<Referenced>,
APIUnwrapper<Referenced> {
    @XmlElement
    protected Long id;
    @XmlElement
    protected String referenceNumber;
    @XmlElement
    protected String type;
    @XmlElement
    protected String pan;
    @XmlElement
    protected String cvvCode;
    @XmlElement
    protected Integer expirationMonth;
    @XmlElement
    protected Integer expirationYear;
    @XmlElement
    protected String accountNumber;
    @XmlElement
    protected String routingNumber;
    @XmlElement
    protected String pin;

    @Override
    public void wrapDetails(Referenced model, HttpServletRequest request) {
        CreditCardPayment referenced;
        this.id = model.getId();
        this.referenceNumber = model.getReferenceNumber();
        if (model instanceof CreditCardPayment) {
            referenced = (CreditCardPayment)model;
            this.type = CreditCardPayment.class.getName();
            this.pan = referenced.getPan();
            this.cvvCode = referenced.getCvvCode();
            this.expirationMonth = referenced.getExpirationMonth();
            this.expirationYear = referenced.getExpirationYear();
        }
        if (model instanceof BankAccountPayment) {
            referenced = (BankAccountPayment)model;
            this.type = BankAccountPayment.class.getName();
            this.accountNumber = referenced.getAccountNumber();
            this.routingNumber = referenced.getRoutingNumber();
        }
        if (model instanceof GiftCardPayment) {
            referenced = (GiftCardPayment)model;
            this.type = GiftCardPayment.class.getName();
            this.pan = referenced.getPan();
            this.pin = referenced.getPin();
        }
    }

    @Override
    public Referenced unwrap(HttpServletRequest request, ApplicationContext context) {
        SecureOrderPaymentService securePaymentInfoService = (SecureOrderPaymentService)context.getBean("blSecureOrderPaymentService");
        if (CreditCardPayment.class.getName().equals(this.type)) {
            CreditCardPayment paymentInfo = (CreditCardPayment)securePaymentInfoService.create(PaymentType.CREDIT_CARD);
            paymentInfo.setId(this.id);
            paymentInfo.setReferenceNumber(this.referenceNumber);
            paymentInfo.setPan(this.pan);
            paymentInfo.setCvvCode(this.cvvCode);
            paymentInfo.setExpirationMonth(this.expirationMonth);
            paymentInfo.setExpirationYear(this.expirationYear);
            return paymentInfo;
        }
        if (BankAccountPayment.class.getName().equals(this.type)) {
            BankAccountPayment paymentInfo = (BankAccountPayment)securePaymentInfoService.create(PaymentType.BANK_ACCOUNT);
            paymentInfo.setId(this.id);
            paymentInfo.setReferenceNumber(this.referenceNumber);
            paymentInfo.setAccountNumber(this.accountNumber);
            paymentInfo.setRoutingNumber(this.routingNumber);
            return paymentInfo;
        }
        if (GiftCardPayment.class.getName().equals(this.type)) {
            GiftCardPayment paymentInfo = (GiftCardPayment)securePaymentInfoService.create(PaymentType.GIFT_CARD);
            paymentInfo.setId(this.id);
            paymentInfo.setReferenceNumber(this.referenceNumber);
            paymentInfo.setPan(this.pan);
            paymentInfo.setPin(this.pin);
            return paymentInfo;
        }
        return null;
    }

    @Override
    public void wrapSummary(Referenced model, HttpServletRequest request) {
        this.wrapDetails(model, request);
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getReferenceNumber() {
        return this.referenceNumber;
    }

    public void setReferenceNumber(String referenceNumber) {
        this.referenceNumber = referenceNumber;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getPan() {
        return this.pan;
    }

    public void setPan(String pan) {
        this.pan = pan;
    }

    public String getCvvCode() {
        return this.cvvCode;
    }

    public void setCvvCode(String cvvCode) {
        this.cvvCode = cvvCode;
    }

    public Integer getExpirationMonth() {
        return this.expirationMonth;
    }

    public void setExpirationMonth(Integer expirationMonth) {
        this.expirationMonth = expirationMonth;
    }

    public Integer getExpirationYear() {
        return this.expirationYear;
    }

    public void setExpirationYear(Integer expirationYear) {
        this.expirationYear = expirationYear;
    }

    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public String getRoutingNumber() {
        return this.routingNumber;
    }

    public void setRoutingNumber(String routingNumber) {
        this.routingNumber = routingNumber;
    }

    public String getPin() {
        return this.pin;
    }

    public void setPin(String pin) {
        this.pin = pin;
    }
}

