/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.api.wrapper;

import javax.servlet.http.HttpServletRequest;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.broadleafcommerce.common.i18n.domain.ISOCountry;
import org.broadleafcommerce.common.i18n.service.ISOService;
import org.broadleafcommerce.core.web.api.wrapper.APIUnwrapper;
import org.broadleafcommerce.core.web.api.wrapper.APIWrapper;
import org.broadleafcommerce.core.web.api.wrapper.BaseWrapper;
import org.springframework.context.ApplicationContext;

@XmlRootElement(name="isoCountry")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ISOCountryWrapper
extends BaseWrapper
implements APIWrapper<ISOCountry>,
APIUnwrapper<ISOCountry> {
    @XmlElement
    protected String name;
    @XmlElement
    protected String alpha2;

    @Override
    public void wrapDetails(ISOCountry model, HttpServletRequest request) {
        this.name = model.getName();
        this.alpha2 = model.getAlpha2();
    }

    @Override
    public void wrapSummary(ISOCountry model, HttpServletRequest request) {
        this.wrapDetails(model, request);
    }

    @Override
    public ISOCountry unwrap(HttpServletRequest request, ApplicationContext appContext) {
        ISOService isoService = (ISOService)appContext.getBean("blISOService");
        if (this.alpha2 != null) {
            return isoService.findISOCountryByAlpha2Code(this.alpha2);
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAlpha2() {
        return this.alpha2;
    }

    public void setAlpha2(String alpha2) {
        this.alpha2 = alpha2;
    }
}

