/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.api.endpoint.order;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.service.OrderService;
import org.broadleafcommerce.core.order.service.type.OrderStatus;
import org.broadleafcommerce.core.web.api.BroadleafWebServicesException;
import org.broadleafcommerce.core.web.api.endpoint.BaseEndpoint;
import org.broadleafcommerce.core.web.api.wrapper.OrderWrapper;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.web.core.CustomerState;
import org.springframework.http.HttpStatus;

public abstract class OrderHistoryEndpoint
extends BaseEndpoint {
    @Resource(name="blOrderService")
    protected OrderService orderService;

    public List<OrderWrapper> findOrdersForCustomer(HttpServletRequest request, String orderStatus) {
        Customer customer = CustomerState.getCustomer((HttpServletRequest)request);
        OrderStatus status = OrderStatus.getInstance((String)orderStatus);
        if (customer != null && status != null) {
            List orders = this.orderService.findOrdersForCustomer(customer, status);
            if (orders != null && !orders.isEmpty()) {
                ArrayList<OrderWrapper> wrappers = new ArrayList<OrderWrapper>();
                for (Order order : orders) {
                    OrderWrapper wrapper = (OrderWrapper)this.context.getBean(OrderWrapper.class.getName());
                    wrapper.wrapSummary(order, request);
                    wrappers.add(wrapper);
                }
                return wrappers;
            }
            throw BroadleafWebServicesException.build(HttpStatus.NOT_FOUND.value()).addMessage("org.broadleafcommerce.core.web.api.BroadleafWebServicesException.cartNotFound");
        }
        throw BroadleafWebServicesException.build(HttpStatus.BAD_REQUEST.value()).addMessage("org.broadleafcommerce.core.web.api.BroadleafWebServicesException.customerNotFound");
    }
}

