/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.api.endpoint.checkout;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.core.checkout.service.CheckoutService;
import org.broadleafcommerce.core.checkout.service.exception.CheckoutException;
import org.broadleafcommerce.core.checkout.service.workflow.CheckoutResponse;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.service.OrderService;
import org.broadleafcommerce.core.payment.domain.OrderPayment;
import org.broadleafcommerce.core.payment.service.OrderPaymentService;
import org.broadleafcommerce.core.web.api.BroadleafWebServicesException;
import org.broadleafcommerce.core.web.api.endpoint.BaseEndpoint;
import org.broadleafcommerce.core.web.api.wrapper.OrderPaymentWrapper;
import org.broadleafcommerce.core.web.api.wrapper.OrderWrapper;
import org.broadleafcommerce.core.web.order.CartState;
import org.springframework.http.HttpStatus;

public abstract class CheckoutEndpoint
extends BaseEndpoint {
    private static final Log LOG = LogFactory.getLog(CheckoutEndpoint.class);
    @Resource(name="blCheckoutService")
    protected CheckoutService checkoutService;
    @Resource(name="blOrderService")
    protected OrderService orderService;
    @Resource(name="blOrderPaymentService")
    protected OrderPaymentService orderPaymentService;

    public List<OrderPaymentWrapper> findPaymentsForOrder(HttpServletRequest request) {
        Order cart = CartState.getCart();
        if (cart != null && cart.getPayments() != null && !cart.getPayments().isEmpty()) {
            List payments = cart.getPayments();
            ArrayList<OrderPaymentWrapper> paymentWrappers = new ArrayList<OrderPaymentWrapper>();
            for (OrderPayment payment : payments) {
                OrderPaymentWrapper orderPaymentWrapper = (OrderPaymentWrapper)this.context.getBean(OrderPaymentWrapper.class.getName());
                orderPaymentWrapper.wrapSummary(payment, request);
                paymentWrappers.add(orderPaymentWrapper);
            }
            return paymentWrappers;
        }
        throw BroadleafWebServicesException.build(HttpStatus.NOT_FOUND.value()).addMessage("org.broadleafcommerce.core.web.api.BroadleafWebServicesException.cartNotFound");
    }

    public OrderPaymentWrapper addPaymentToOrder(HttpServletRequest request, OrderPaymentWrapper wrapper) {
        OrderPayment orderPayment;
        Order cart = CartState.getCart();
        if (cart != null && (orderPayment = wrapper.unwrap(request, this.context)).getOrder() != null && orderPayment.getOrder().getId().equals(cart.getId())) {
            orderPayment = this.orderPaymentService.save(orderPayment);
            OrderPayment savedPayment = this.orderService.addPaymentToOrder(cart, orderPayment, null);
            OrderPaymentWrapper orderPaymentWrapper = (OrderPaymentWrapper)this.context.getBean(OrderPaymentWrapper.class.getName());
            orderPaymentWrapper.wrapSummary(savedPayment, request);
            return orderPaymentWrapper;
        }
        throw BroadleafWebServicesException.build(HttpStatus.NOT_FOUND.value()).addMessage("org.broadleafcommerce.core.web.api.BroadleafWebServicesException.cartNotFound");
    }

    public OrderWrapper removePaymentFromOrder(HttpServletRequest request, OrderPaymentWrapper wrapper) {
        OrderPayment orderPayment;
        Order cart = CartState.getCart();
        if (cart != null && (orderPayment = wrapper.unwrap(request, this.context)).getOrder() != null && orderPayment.getOrder().getId().equals(cart.getId())) {
            OrderPayment paymentToRemove = null;
            for (OrderPayment payment : cart.getPayments()) {
                if (!payment.getId().equals(orderPayment.getId())) continue;
                paymentToRemove = payment;
            }
            this.orderService.removePaymentFromOrder(cart, paymentToRemove);
            OrderWrapper orderWrapper = (OrderWrapper)this.context.getBean(OrderWrapper.class.getName());
            orderWrapper.wrapDetails(cart, request);
            return orderWrapper;
        }
        throw BroadleafWebServicesException.build(HttpStatus.NOT_FOUND.value()).addMessage("org.broadleafcommerce.core.web.api.BroadleafWebServicesException.cartNotFound");
    }

    public OrderWrapper performCheckout(HttpServletRequest request) {
        Order cart = CartState.getCart();
        if (cart != null) {
            try {
                CheckoutResponse response = this.checkoutService.performCheckout(cart);
                Order order = response.getOrder();
                OrderWrapper wrapper = (OrderWrapper)this.context.getBean(OrderWrapper.class.getName());
                wrapper.wrapDetails(order, request);
                return wrapper;
            }
            catch (CheckoutException e) {
                throw BroadleafWebServicesException.build(HttpStatus.INTERNAL_SERVER_ERROR.value()).addMessage("org.broadleafcommerce.core.web.api.BroadleafWebServicesException.checkoutProcessingError");
            }
        }
        throw BroadleafWebServicesException.build(HttpStatus.NOT_FOUND.value()).addMessage("org.broadleafcommerce.core.web.api.BroadleafWebServicesException.cartNotFound");
    }
}

