/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.api;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.SimpleType;
import com.fasterxml.jackson.databind.type.TypeBindings;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.type.TypeModifier;
import java.lang.reflect.Type;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component(value="blWrapperOverrideTypeModifier")
public class WrapperOverrideTypeModifier
extends TypeModifier
implements ApplicationContextAware {
    private static final Log LOG = LogFactory.getLog(WrapperOverrideTypeModifier.class);
    protected ApplicationContext applicationContext;

    public JavaType modifyType(JavaType type, Type jdkType, TypeBindings context, TypeFactory typeFactory) {
        try {
            if (type.getClass().isAssignableFrom(SimpleType.class)) {
                Object overriddenBean = this.applicationContext.getBean(type.getRawClass().getName());
                return SimpleType.construct(overriddenBean.getClass());
            }
        }
        catch (NoSuchBeanDefinitionException e) {
            LOG.debug((Object)("No configured bean for " + type.getClass().getName() + " returning original type"));
        }
        return type;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

