/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.broadleafcommerce.common.util.BLCSystemProperty;
import org.broadleafcommerce.core.search.domain.SearchCriteria;
import org.broadleafcommerce.core.search.domain.SearchFacetDTO;
import org.broadleafcommerce.core.search.domain.SearchFacetResultDTO;
import org.broadleafcommerce.core.web.service.SearchFacetDTOService;
import org.springframework.stereotype.Service;

@Service(value="blSearchFacetDTOService")
public class SearchFacetDTOServiceImpl
implements SearchFacetDTOService {
    protected int getDefaultPageSize() {
        return BLCSystemProperty.resolveIntSystemProperty((String)"web.defaultPageSize");
    }

    protected int getMaxPageSize() {
        return BLCSystemProperty.resolveIntSystemProperty((String)"web.maxPageSize");
    }

    @Override
    public SearchCriteria buildSearchCriteria(HttpServletRequest request, List<SearchFacetDTO> availableFacets) {
        SearchCriteria searchCriteria = new SearchCriteria();
        searchCriteria.setPageSize(Integer.valueOf(this.getDefaultPageSize()));
        HashMap facets = new HashMap();
        for (Map.Entry entry : request.getParameterMap().entrySet()) {
            String key = (String)entry.getKey();
            if (key.equals(SearchCriteria.SORT_STRING)) {
                searchCriteria.setSortQuery(StringUtils.join((Object[])((Object[])entry.getValue()), (String)","));
                continue;
            }
            if (key.equals(SearchCriteria.PAGE_NUMBER)) {
                searchCriteria.setPage(Integer.valueOf(Integer.parseInt(((String[])entry.getValue())[0])));
                continue;
            }
            if (key.equals(SearchCriteria.PAGE_SIZE_STRING)) {
                int requestedPageSize = Integer.parseInt(((String[])entry.getValue())[0]);
                int maxPageSize = this.getMaxPageSize();
                searchCriteria.setPageSize(Integer.valueOf(Math.min(requestedPageSize, maxPageSize)));
                continue;
            }
            if (key.equals(SearchCriteria.QUERY_STRING)) continue;
            facets.put(key, entry.getValue());
        }
        searchCriteria.setFilterCriteria(facets);
        return searchCriteria;
    }

    @Override
    public void setActiveFacetResults(List<SearchFacetDTO> facets, HttpServletRequest request) {
        if (facets != null) {
            for (SearchFacetDTO facet : facets) {
                for (SearchFacetResultDTO facetResult : facet.getFacetValues()) {
                    facetResult.setActive(this.isActive(facetResult, request));
                }
            }
        }
    }

    @Override
    public boolean isActive(SearchFacetResultDTO result, HttpServletRequest request) {
        Map params = request.getParameterMap();
        for (Map.Entry entry : params.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.equals(this.getUrlKey(result))) continue;
            for (String val : (String[])entry.getValue()) {
                if (!val.equals(this.getValue(result))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String getUrlKey(SearchFacetResultDTO result) {
        return result.getFacet().getField().getAbbreviation();
    }

    @Override
    public String getValue(SearchFacetResultDTO result) {
        return result.getValueKey();
    }
}

