/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.api.wrapper;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.broadleafcommerce.common.file.service.StaticAssetPathService;
import org.broadleafcommerce.common.media.domain.Media;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.common.util.xml.ISO8601DateAdapter;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.catalog.domain.ProductAttribute;
import org.broadleafcommerce.core.catalog.domain.ProductBundle;
import org.broadleafcommerce.core.catalog.domain.ProductOption;
import org.broadleafcommerce.core.catalog.domain.RelatedProduct;
import org.broadleafcommerce.core.catalog.domain.SkuBundleItem;
import org.broadleafcommerce.core.web.api.wrapper.APIWrapper;
import org.broadleafcommerce.core.web.api.wrapper.BaseWrapper;
import org.broadleafcommerce.core.web.api.wrapper.MediaWrapper;
import org.broadleafcommerce.core.web.api.wrapper.ProductAttributeWrapper;
import org.broadleafcommerce.core.web.api.wrapper.ProductOptionWrapper;
import org.broadleafcommerce.core.web.api.wrapper.RelatedProductWrapper;
import org.broadleafcommerce.core.web.api.wrapper.SkuBundleItemWrapper;

@XmlRootElement(name="product")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ProductWrapper
extends BaseWrapper
implements APIWrapper<Product> {
    @XmlElement
    protected Long id;
    @XmlElement
    protected String name;
    @XmlElement
    protected String description;
    @XmlElement
    protected String longDescription;
    @XmlElement
    protected Money retailPrice;
    @XmlElement
    protected Money salePrice;
    @XmlElement
    protected MediaWrapper primaryMedia;
    @XmlElement
    protected Boolean active;
    @XmlElement(name="productOption")
    @XmlElementWrapper(name="productOptions")
    protected List<ProductOptionWrapper> productOptions;
    @XmlElement
    protected Integer priority;
    @XmlElement
    protected Money bundleItemsRetailPrice;
    @XmlElement
    protected Money bundleItemsSalePrice;
    @XmlElement
    @XmlJavaTypeAdapter(value=ISO8601DateAdapter.class)
    protected Date activeStartDate;
    @XmlElement
    @XmlJavaTypeAdapter(value=ISO8601DateAdapter.class)
    protected Date activeEndDate;
    @XmlElement
    protected String manufacturer;
    @XmlElement
    protected String model;
    @XmlElement
    protected String promoMessage;
    @XmlElement
    protected Long defaultCategoryId;
    @XmlElement(name="upsaleProduct")
    @XmlElementWrapper(name="upsaleProducts")
    protected List<RelatedProductWrapper> upsaleProducts;
    @XmlElement(name="crossSaleProduct")
    @XmlElementWrapper(name="crossSaleProducts")
    protected List<RelatedProductWrapper> crossSaleProducts;
    @XmlElement(name="productAttribute")
    @XmlElementWrapper(name="productAttributes")
    protected List<ProductAttributeWrapper> productAttributes;
    @XmlElement(name="media")
    @XmlElementWrapper(name="mediaItems")
    protected List<MediaWrapper> media;
    @XmlElement(name="skuBundleItem")
    @XmlElementWrapper(name="skuBundleItems")
    protected List<SkuBundleItemWrapper> skuBundleItems;

    @Override
    public void wrapDetails(Product model, HttpServletRequest request) {
        Media media;
        this.id = model.getId();
        this.name = model.getName();
        this.description = model.getDescription();
        this.longDescription = model.getLongDescription();
        this.activeStartDate = model.getActiveStartDate();
        this.activeEndDate = model.getActiveEndDate();
        this.manufacturer = model.getManufacturer();
        this.model = model.getModel();
        this.promoMessage = model.getPromoMessage();
        this.active = model.isActive();
        if (model instanceof ProductBundle) {
            ProductBundle bundle = (ProductBundle)model;
            this.priority = bundle.getPriority();
            this.bundleItemsRetailPrice = bundle.getBundleItemsRetailPrice();
            this.bundleItemsSalePrice = bundle.getBundleItemsSalePrice();
            if (bundle.getSkuBundleItems() != null) {
                this.skuBundleItems = new ArrayList<SkuBundleItemWrapper>();
                List list = bundle.getSkuBundleItems();
                for (SkuBundleItem item : list) {
                    SkuBundleItemWrapper skuBundleItemsWrapper = (SkuBundleItemWrapper)this.context.getBean(SkuBundleItemWrapper.class.getName());
                    skuBundleItemsWrapper.wrapSummary(item, request);
                    this.skuBundleItems.add(skuBundleItemsWrapper);
                }
            }
        } else {
            this.retailPrice = model.getDefaultSku().getRetailPrice();
            this.salePrice = model.getDefaultSku().getSalePrice();
        }
        if (model.getProductOptions() != null && !model.getProductOptions().isEmpty()) {
            this.productOptions = new ArrayList<ProductOptionWrapper>();
            List options = model.getProductOptions();
            for (ProductOption option : options) {
                ProductOptionWrapper optionWrapper = (ProductOptionWrapper)this.context.getBean(ProductOptionWrapper.class.getName());
                optionWrapper.wrapSummary(option, request);
                this.productOptions.add(optionWrapper);
            }
        }
        if (model.getMedia() != null && !model.getMedia().isEmpty() && (media = (Media)model.getMedia().get("primary")) != null) {
            StaticAssetPathService staticAssetPathService = (StaticAssetPathService)this.context.getBean("blStaticAssetPathService");
            this.primaryMedia = (MediaWrapper)this.context.getBean(MediaWrapper.class.getName());
            this.primaryMedia.wrapDetails(media, request);
            if (this.primaryMedia.isAllowOverrideUrl()) {
                this.primaryMedia.setUrl(staticAssetPathService.convertAssetPath(media.getUrl(), request.getContextPath(), request.isSecure()));
            }
        }
        if (model.getDefaultCategory() != null) {
            this.defaultCategoryId = model.getDefaultCategory().getId();
        }
        if (model.getUpSaleProducts() != null && !model.getUpSaleProducts().isEmpty()) {
            this.upsaleProducts = new ArrayList<RelatedProductWrapper>();
            for (RelatedProduct relatedProduct : model.getUpSaleProducts()) {
                RelatedProductWrapper upsaleProductWrapper = (RelatedProductWrapper)this.context.getBean(RelatedProductWrapper.class.getName());
                upsaleProductWrapper.wrapSummary(relatedProduct, request);
                this.upsaleProducts.add(upsaleProductWrapper);
            }
        }
        if (model.getCrossSaleProducts() != null && !model.getCrossSaleProducts().isEmpty()) {
            this.crossSaleProducts = new ArrayList<RelatedProductWrapper>();
            for (RelatedProduct relatedProduct : model.getCrossSaleProducts()) {
                RelatedProductWrapper crossSaleProductWrapper = (RelatedProductWrapper)this.context.getBean(RelatedProductWrapper.class.getName());
                crossSaleProductWrapper.wrapSummary(relatedProduct, request);
                this.crossSaleProducts.add(crossSaleProductWrapper);
            }
        }
        if (model.getProductAttributes() != null && !model.getProductAttributes().isEmpty()) {
            this.productAttributes = new ArrayList<ProductAttributeWrapper>();
            if (model.getProductAttributes() != null) {
                for (Map.Entry entry : model.getProductAttributes().entrySet()) {
                    ProductAttributeWrapper wrapper = (ProductAttributeWrapper)this.context.getBean(ProductAttributeWrapper.class.getName());
                    wrapper.wrapSummary((ProductAttribute)entry.getValue(), request);
                    this.productAttributes.add(wrapper);
                }
            }
        }
        if (model.getMedia() != null && !model.getMedia().isEmpty()) {
            Map mediaMap = model.getMedia();
            this.media = new ArrayList<MediaWrapper>();
            StaticAssetPathService staticAssetPathService = (StaticAssetPathService)this.context.getBean("blStaticAssetPathService");
            for (Media med : mediaMap.values()) {
                MediaWrapper wrapper = (MediaWrapper)this.context.getBean(MediaWrapper.class.getName());
                wrapper.wrapSummary(med, request);
                if (wrapper.isAllowOverrideUrl()) {
                    wrapper.setUrl(staticAssetPathService.convertAssetPath(med.getUrl(), request.getContextPath(), request.isSecure()));
                }
                this.media.add(wrapper);
            }
        }
    }

    @Override
    public void wrapSummary(Product model, HttpServletRequest request) {
        Media media;
        this.id = model.getId();
        this.name = model.getName();
        this.description = model.getDescription();
        this.longDescription = model.getLongDescription();
        this.active = model.isActive();
        if (model instanceof ProductBundle) {
            ProductBundle bundle = (ProductBundle)model;
            this.priority = bundle.getPriority();
            this.bundleItemsRetailPrice = bundle.getBundleItemsRetailPrice();
            this.bundleItemsSalePrice = bundle.getBundleItemsSalePrice();
        } else {
            this.retailPrice = model.getDefaultSku().getRetailPrice();
            this.salePrice = model.getDefaultSku().getSalePrice();
        }
        if (model.getProductOptions() != null && !model.getProductOptions().isEmpty()) {
            this.productOptions = new ArrayList<ProductOptionWrapper>();
            List options = model.getProductOptions();
            for (ProductOption option : options) {
                ProductOptionWrapper optionWrapper = (ProductOptionWrapper)this.context.getBean(ProductOptionWrapper.class.getName());
                optionWrapper.wrapSummary(option, request);
                this.productOptions.add(optionWrapper);
            }
        }
        if (model.getMedia() != null && !model.getMedia().isEmpty() && (media = (Media)model.getMedia().get("primary")) != null) {
            StaticAssetPathService staticAssetPathService = (StaticAssetPathService)this.context.getBean("blStaticAssetPathService");
            this.primaryMedia = (MediaWrapper)this.context.getBean(MediaWrapper.class.getName());
            this.primaryMedia.wrapDetails(media, request);
            if (this.primaryMedia.isAllowOverrideUrl()) {
                this.primaryMedia.setUrl(staticAssetPathService.convertAssetPath(media.getUrl(), request.getContextPath(), request.isSecure()));
            }
        }
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getLongDescription() {
        return this.longDescription;
    }

    public void setLongDescription(String longDescription) {
        this.longDescription = longDescription;
    }

    public Money getRetailPrice() {
        return this.retailPrice;
    }

    public void setRetailPrice(Money retailPrice) {
        this.retailPrice = retailPrice;
    }

    public Money getSalePrice() {
        return this.salePrice;
    }

    public void setSalePrice(Money salePrice) {
        this.salePrice = salePrice;
    }

    public MediaWrapper getPrimaryMedia() {
        return this.primaryMedia;
    }

    public void setPrimaryMedia(MediaWrapper primaryMedia) {
        this.primaryMedia = primaryMedia;
    }

    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public List<ProductOptionWrapper> getProductOptions() {
        return this.productOptions;
    }

    public void setProductOptions(List<ProductOptionWrapper> productOptions) {
        this.productOptions = productOptions;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public Money getBundleItemsRetailPrice() {
        return this.bundleItemsRetailPrice;
    }

    public void setBundleItemsRetailPrice(Money bundleItemsRetailPrice) {
        this.bundleItemsRetailPrice = bundleItemsRetailPrice;
    }

    public Money getBundleItemsSalePrice() {
        return this.bundleItemsSalePrice;
    }

    public void setBundleItemsSalePrice(Money bundleItemsSalePrice) {
        this.bundleItemsSalePrice = bundleItemsSalePrice;
    }

    public Date getActiveStartDate() {
        return this.activeStartDate;
    }

    public void setActiveStartDate(Date activeStartDate) {
        this.activeStartDate = activeStartDate;
    }

    public Date getActiveEndDate() {
        return this.activeEndDate;
    }

    public void setActiveEndDate(Date activeEndDate) {
        this.activeEndDate = activeEndDate;
    }

    public String getManufacturer() {
        return this.manufacturer;
    }

    public void setManufacturer(String manufacturer) {
        this.manufacturer = manufacturer;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getPromoMessage() {
        return this.promoMessage;
    }

    public void setPromoMessage(String promoMessage) {
        this.promoMessage = promoMessage;
    }

    public Long getDefaultCategoryId() {
        return this.defaultCategoryId;
    }

    public void setDefaultCategoryId(Long defaultCategoryId) {
        this.defaultCategoryId = defaultCategoryId;
    }

    public List<RelatedProductWrapper> getUpsaleProducts() {
        return this.upsaleProducts;
    }

    public void setUpsaleProducts(List<RelatedProductWrapper> upsaleProducts) {
        this.upsaleProducts = upsaleProducts;
    }

    public List<RelatedProductWrapper> getCrossSaleProducts() {
        return this.crossSaleProducts;
    }

    public void setCrossSaleProducts(List<RelatedProductWrapper> crossSaleProducts) {
        this.crossSaleProducts = crossSaleProducts;
    }

    public List<ProductAttributeWrapper> getProductAttributes() {
        return this.productAttributes;
    }

    public void setProductAttributes(List<ProductAttributeWrapper> productAttributes) {
        this.productAttributes = productAttributes;
    }

    public List<MediaWrapper> getMedia() {
        return this.media;
    }

    public void setMedia(List<MediaWrapper> media) {
        this.media = media;
    }

    public List<SkuBundleItemWrapper> getSkuBundleItems() {
        return this.skuBundleItems;
    }

    public void setSkuBundleItems(List<SkuBundleItemWrapper> skuBundleItems) {
        this.skuBundleItems = skuBundleItems;
    }
}

