/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.service;

import java.util.ArrayList;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.currency.domain.BroadleafCurrency;
import org.broadleafcommerce.common.extension.ExtensionResultHolder;
import org.broadleafcommerce.common.web.BroadleafRequestContext;
import org.broadleafcommerce.core.catalog.domain.Sku;
import org.broadleafcommerce.core.order.domain.BundleOrderItem;
import org.broadleafcommerce.core.order.domain.DiscreteOrderItem;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.service.OrderService;
import org.broadleafcommerce.core.order.service.call.AddToCartItem;
import org.broadleafcommerce.core.order.service.call.OrderItemRequestDTO;
import org.broadleafcommerce.core.order.service.call.UpdateCartResponse;
import org.broadleafcommerce.core.order.service.exception.AddToCartException;
import org.broadleafcommerce.core.order.service.exception.RemoveFromCartException;
import org.broadleafcommerce.core.pricing.service.exception.PricingException;
import org.broadleafcommerce.core.web.service.UpdateCartService;
import org.broadleafcommerce.core.web.service.UpdateCartServiceExtensionHandler;
import org.broadleafcommerce.core.web.service.UpdateCartServiceExtensionManager;
import org.springframework.stereotype.Service;

@Service(value="blUpdateCartService")
public class UpdateCartServiceImpl
implements UpdateCartService {
    protected static final Log LOG = LogFactory.getLog(UpdateCartServiceImpl.class);
    protected static BroadleafCurrency savedCurrency;
    @Resource(name="blOrderService")
    protected OrderService orderService;
    @Resource(name="blUpdateCartServiceExtensionManager")
    protected UpdateCartServiceExtensionManager extensionManager;

    @Override
    public boolean currencyHasChanged() {
        BroadleafCurrency currency = this.findActiveCurrency();
        if (this.getSavedCurrency() == null) {
            this.setSavedCurrency(currency);
        } else if (this.getSavedCurrency() != currency) {
            return true;
        }
        return false;
    }

    @Override
    public UpdateCartResponse copyCartToCurrentContext(Order currentCart) {
        if (currentCart.getOrderItems() == null) {
            return null;
        }
        BroadleafCurrency currency = this.findActiveCurrency();
        if (currency == null) {
            return null;
        }
        ArrayList<AddToCartItem> itemsToReprice = new ArrayList<AddToCartItem>();
        ArrayList<OrderItem> itemsToRemove = new ArrayList<OrderItem>();
        ArrayList<OrderItem> itemsToReset = new ArrayList<OrderItem>();
        boolean repriceOrder = true;
        for (OrderItem orderItem : currentCart.getOrderItems()) {
            if (orderItem instanceof DiscreteOrderItem) {
                DiscreteOrderItem doi = (DiscreteOrderItem)orderItem;
                if (this.checkAvailabilityInLocale(doi, currency)) {
                    AddToCartItem itemRequest = new AddToCartItem();
                    itemRequest.setProductId(doi.getProduct().getId());
                    itemRequest.setQuantity(Integer.valueOf(doi.getQuantity()));
                    itemsToReprice.add(itemRequest);
                    itemsToReset.add(orderItem);
                    continue;
                }
                itemsToRemove.add(orderItem);
                continue;
            }
            if (!(orderItem instanceof BundleOrderItem)) continue;
            BundleOrderItem boi = (BundleOrderItem)orderItem;
            for (DiscreteOrderItem doi : boi.getDiscreteOrderItems()) {
                if (this.checkAvailabilityInLocale(doi, currency)) {
                    AddToCartItem itemRequest = new AddToCartItem();
                    itemRequest.setProductId(doi.getProduct().getId());
                    itemRequest.setQuantity(Integer.valueOf(doi.getQuantity()));
                    itemsToReprice.add(itemRequest);
                    itemsToReset.add(orderItem);
                    continue;
                }
                itemsToRemove.add(orderItem);
            }
        }
        for (OrderItem orderItem : itemsToReset) {
            try {
                currentCart = this.orderService.removeItem(currentCart.getId(), orderItem.getId(), false);
            }
            catch (RemoveFromCartException e) {
                e.printStackTrace();
            }
        }
        for (AddToCartItem itemRequest : itemsToReprice) {
            try {
                currentCart = this.orderService.addItem(currentCart.getId(), (OrderItemRequestDTO)itemRequest, false);
            }
            catch (AddToCartException e) {
                e.printStackTrace();
            }
        }
        try {
            currentCart = this.orderService.save(currentCart, Boolean.valueOf(repriceOrder));
        }
        catch (PricingException e) {
            e.printStackTrace();
        }
        this.setSavedCurrency(currency);
        UpdateCartResponse updateCartResponse = new UpdateCartResponse();
        updateCartResponse.setRemovedItems(itemsToRemove);
        updateCartResponse.setOrder(currentCart);
        return updateCartResponse;
    }

    @Override
    public void validateCart(Order cart) {
    }

    @Override
    public void updateAndValidateCart(Order cart) {
        if (this.extensionManager != null) {
            ExtensionResultHolder erh = new ExtensionResultHolder();
            ((UpdateCartServiceExtensionHandler)this.extensionManager.getProxy()).updateAndValidateCart(cart, erh);
            Boolean clearCart = (Boolean)erh.getContextMap().get("clearCart");
            Boolean repriceCart = (Boolean)erh.getContextMap().get("repriceCart");
            Boolean saveCart = (Boolean)erh.getContextMap().get("saveCart");
            if (clearCart != null && clearCart.booleanValue()) {
                this.orderService.cancelOrder(cart);
                cart = this.orderService.createNewCartForCustomer(cart.getCustomer());
            } else {
                try {
                    if (repriceCart != null && repriceCart.booleanValue()) {
                        this.orderService.save(cart, true, true);
                    } else if (saveCart != null && saveCart.booleanValue()) {
                        this.orderService.save(cart, Boolean.valueOf(false));
                    }
                }
                catch (PricingException pe) {
                    LOG.error((Object)"Pricing Exception while validating cart.   Clearing cart.", (Throwable)pe);
                    this.orderService.cancelOrder(cart);
                    cart = this.orderService.createNewCartForCustomer(cart.getCustomer());
                }
            }
        }
    }

    protected BroadleafCurrency findActiveCurrency() {
        if (BroadleafRequestContext.hasLocale()) {
            return BroadleafRequestContext.getBroadleafRequestContext().getBroadleafCurrency();
        }
        return null;
    }

    protected boolean checkAvailabilityInLocale(DiscreteOrderItem doi, BroadleafCurrency currency) {
        if (doi.getSku() != null && this.extensionManager != null) {
            Sku sku = doi.getSku();
            return sku.isAvailable();
        }
        return false;
    }

    @Override
    public void setSavedCurrency(BroadleafCurrency savedCurrency) {
        UpdateCartServiceImpl.savedCurrency = savedCurrency;
    }

    @Override
    public BroadleafCurrency getSavedCurrency() {
        return savedCurrency;
    }
}

