/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.processor;

import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.broadleafcommerce.common.web.dialect.AbstractModelVariableModifierProcessor;
import org.broadleafcommerce.core.rating.domain.RatingSummary;
import org.broadleafcommerce.core.rating.domain.ReviewDetail;
import org.broadleafcommerce.core.rating.service.RatingService;
import org.broadleafcommerce.core.rating.service.type.RatingType;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.web.core.CustomerState;
import org.thymeleaf.Arguments;
import org.thymeleaf.Configuration;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.dom.Element;
import org.thymeleaf.standard.expression.Expression;
import org.thymeleaf.standard.expression.StandardExpressions;

public class RatingsProcessor
extends AbstractModelVariableModifierProcessor {
    @Resource(name="blRatingService")
    protected RatingService ratingService;

    public RatingsProcessor() {
        super("ratings");
    }

    public int getPrecedence() {
        return 10000;
    }

    protected void modifyModelAttributes(Arguments arguments, Element element) {
        Expression expression = (Expression)StandardExpressions.getExpressionParser((Configuration)arguments.getConfiguration()).parseExpression(arguments.getConfiguration(), (IProcessingContext)arguments, element.getAttributeValue("itemId"));
        String itemId = String.valueOf(expression.execute(arguments.getConfiguration(), (IProcessingContext)arguments));
        RatingSummary ratingSummary = this.ratingService.readRatingSummary(itemId, RatingType.PRODUCT);
        if (ratingSummary != null) {
            this.addToModel(arguments, this.getRatingsVar(element), ratingSummary);
        }
        Customer customer = CustomerState.getCustomer();
        ReviewDetail reviewDetail = null;
        if (!customer.isAnonymous()) {
            reviewDetail = this.ratingService.readReviewByCustomerAndItem(customer, itemId);
        }
        if (reviewDetail != null) {
            this.addToModel(arguments, "currentCustomerReview", reviewDetail);
        }
    }

    private String getRatingsVar(Element element) {
        String ratingsVar = element.getAttributeValue("ratingsVar");
        if (StringUtils.isNotEmpty((String)ratingsVar)) {
            return ratingsVar;
        }
        return "ratingSummary";
    }
}

