/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.controller.catalog;

import java.util.HashSet;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.broadleafcommerce.common.extension.ExtensionResultHolder;
import org.broadleafcommerce.common.extension.ExtensionResultStatusType;
import org.broadleafcommerce.common.template.TemplateOverrideExtensionHandler;
import org.broadleafcommerce.common.template.TemplateOverrideExtensionManager;
import org.broadleafcommerce.common.template.TemplateType;
import org.broadleafcommerce.common.web.BroadleafRequestContext;
import org.broadleafcommerce.common.web.TemplateTypeAware;
import org.broadleafcommerce.common.web.controller.BroadleafAbstractController;
import org.broadleafcommerce.common.web.deeplink.DeepLinkService;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.Controller;

public class BroadleafProductController
extends BroadleafAbstractController
implements Controller,
TemplateTypeAware {
    protected String defaultProductView = "catalog/product";
    protected static String MODEL_ATTRIBUTE_NAME = "product";
    protected static String ALL_PRODUCTS_ATTRIBUTE_NAME = "blcAllDisplayedProducts";
    @Autowired(required=false)
    @Qualifier(value="blProductDeepLinkService")
    protected DeepLinkService<Product> deepLinkService;
    @Resource(name="blTemplateOverrideExtensionManager")
    protected TemplateOverrideExtensionManager templateOverrideManager;

    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView model = new ModelAndView();
        Product product = (Product)request.getAttribute("currentProduct");
        assert (product != null);
        model.addObject(MODEL_ATTRIBUTE_NAME, (Object)product);
        HashSet<Product> allProductsSet = new HashSet<Product>();
        allProductsSet.add(product);
        model.addObject(ALL_PRODUCTS_ATTRIBUTE_NAME, new HashSet(allProductsSet));
        model.addObject("BLC_PAGE_TYPE", (Object)"product");
        this.addDeepLink(model, this.deepLinkService, product);
        String templatePath = null;
        templatePath = StringUtils.isNotBlank((CharSequence)product.getDisplayTemplate()) ? product.getDisplayTemplate() : this.getDefaultProductView();
        ExtensionResultHolder erh = new ExtensionResultHolder();
        ExtensionResultStatusType extResult = ((TemplateOverrideExtensionHandler)this.templateOverrideManager.getProxy()).getOverrideTemplate(erh, (Object)product);
        if (extResult != ExtensionResultStatusType.NOT_HANDLED) {
            templatePath = (String)erh.getResult();
        }
        model.setViewName(templatePath);
        return model;
    }

    public String getDefaultProductView() {
        return this.defaultProductView;
    }

    public void setDefaultProductView(String defaultProductView) {
        this.defaultProductView = defaultProductView;
    }

    public String getExpectedTemplateName(HttpServletRequest request) {
        Product product;
        BroadleafRequestContext context = BroadleafRequestContext.getBroadleafRequestContext();
        if (context != null && (product = (Product)context.getRequest().getAttribute("currentProduct")) != null && product.getDisplayTemplate() != null) {
            return product.getDisplayTemplate();
        }
        return this.getDefaultProductView();
    }

    public TemplateType getTemplateType(HttpServletRequest request) {
        return TemplateType.PRODUCT;
    }
}

