/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.api.wrapper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Currency;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.common.money.util.CurrencyAdapter;
import org.broadleafcommerce.common.payment.PaymentGatewayType;
import org.broadleafcommerce.common.payment.PaymentType;
import org.broadleafcommerce.common.util.xml.BigDecimalRoundingAdapter;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.service.OrderService;
import org.broadleafcommerce.core.payment.domain.OrderPayment;
import org.broadleafcommerce.core.payment.domain.PaymentTransaction;
import org.broadleafcommerce.core.payment.service.OrderPaymentService;
import org.broadleafcommerce.core.web.api.wrapper.APIUnwrapper;
import org.broadleafcommerce.core.web.api.wrapper.APIWrapper;
import org.broadleafcommerce.core.web.api.wrapper.AddressWrapper;
import org.broadleafcommerce.core.web.api.wrapper.BaseWrapper;
import org.broadleafcommerce.core.web.api.wrapper.PaymentTransactionWrapper;
import org.springframework.context.ApplicationContext;

@XmlRootElement(name="payment")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class OrderPaymentWrapper
extends BaseWrapper
implements APIWrapper<OrderPayment>,
APIUnwrapper<OrderPayment> {
    @XmlElement
    protected Long id;
    @XmlElement
    protected Long orderId;
    @XmlElement
    protected String type;
    @XmlElement
    protected AddressWrapper billingAddress;
    @XmlElement
    @XmlJavaTypeAdapter(value=BigDecimalRoundingAdapter.class)
    protected BigDecimal amount;
    @XmlElement
    @XmlJavaTypeAdapter(value=CurrencyAdapter.class)
    protected Currency currency;
    @XmlElement
    protected String referenceNumber;
    @XmlElement
    protected String gatewayType;
    @XmlElement(name="transaction")
    @XmlElementWrapper(name="transactions")
    protected List<PaymentTransactionWrapper> transactions;

    @Override
    public void wrapDetails(OrderPayment model, HttpServletRequest request) {
        this.id = model.getId();
        if (model.getOrder() != null) {
            this.orderId = model.getOrder().getId();
        }
        if (model.getType() != null) {
            this.type = model.getType().getType();
        }
        if (model.getGatewayType() != null) {
            this.gatewayType = model.getGatewayType().getType();
        }
        if (model.getBillingAddress() != null) {
            AddressWrapper addressWrapper = (AddressWrapper)this.context.getBean(AddressWrapper.class.getName());
            addressWrapper.wrapDetails(model.getBillingAddress(), request);
            this.billingAddress = addressWrapper;
        }
        if (model.getAmount() != null) {
            this.amount = model.getAmount().getAmount();
            this.currency = model.getAmount().getCurrency();
        }
        if (model.getTransactions() != null && !model.getTransactions().isEmpty()) {
            this.transactions = new ArrayList<PaymentTransactionWrapper>();
            for (PaymentTransaction transaction : model.getTransactions()) {
                PaymentTransactionWrapper transactionWrapper = (PaymentTransactionWrapper)this.context.getBean(PaymentTransactionWrapper.class.getName());
                transactionWrapper.wrapSummary(transaction, request);
                this.transactions.add(transactionWrapper);
            }
        }
        this.referenceNumber = model.getReferenceNumber();
    }

    @Override
    public void wrapSummary(OrderPayment model, HttpServletRequest request) {
        this.wrapDetails(model, request);
    }

    @Override
    public OrderPayment unwrap(HttpServletRequest request, ApplicationContext context) {
        OrderPaymentService orderPaymentService = (OrderPaymentService)context.getBean("blOrderPaymentService");
        OrderPayment payment = orderPaymentService.create();
        OrderService orderService = (OrderService)context.getBean("blOrderService");
        Order order = orderService.findOrderById(this.orderId);
        if (order != null) {
            payment.setOrder(order);
        }
        payment.setId(this.id);
        payment.setType(PaymentType.getInstance((String)this.type));
        payment.setPaymentGatewayType(PaymentGatewayType.getInstance((String)this.gatewayType));
        payment.setReferenceNumber(this.referenceNumber);
        if (this.billingAddress != null) {
            payment.setBillingAddress(this.billingAddress.unwrap(request, context));
        }
        if (this.amount != null) {
            if (this.currency != null) {
                payment.setAmount(new Money(this.amount, this.currency));
            } else {
                payment.setAmount(new Money(this.amount));
            }
        }
        if (this.transactions != null && !this.transactions.isEmpty()) {
            for (PaymentTransactionWrapper transactionWrapper : this.transactions) {
                PaymentTransaction transaction = transactionWrapper.unwrap(request, context);
                transaction.setOrderPayment(payment);
                payment.addTransaction(transaction);
            }
        }
        return payment;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getOrderId() {
        return this.orderId;
    }

    public void setOrderId(Long orderId) {
        this.orderId = orderId;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public AddressWrapper getBillingAddress() {
        return this.billingAddress;
    }

    public void setBillingAddress(AddressWrapper billingAddress) {
        this.billingAddress = billingAddress;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    public String getReferenceNumber() {
        return this.referenceNumber;
    }

    public void setReferenceNumber(String referenceNumber) {
        this.referenceNumber = referenceNumber;
    }

    public String getGatewayType() {
        return this.gatewayType;
    }

    public void setGatewayType(String gatewayType) {
        this.gatewayType = gatewayType;
    }

    public List<PaymentTransactionWrapper> getTransactions() {
        return this.transactions;
    }

    public void setTransactions(List<PaymentTransactionWrapper> transactions) {
        this.transactions = transactions;
    }
}

