/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.controller.cart;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.broadleafcommerce.common.util.BLCMessageUtils;
import org.broadleafcommerce.core.offer.domain.OfferCode;
import org.broadleafcommerce.core.offer.service.exception.OfferMaxUseExceededException;
import org.broadleafcommerce.core.order.domain.NullOrderImpl;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.service.call.AddToCartItem;
import org.broadleafcommerce.core.order.service.call.OrderItemRequestDTO;
import org.broadleafcommerce.core.order.service.exception.AddToCartException;
import org.broadleafcommerce.core.order.service.exception.IllegalCartOperationException;
import org.broadleafcommerce.core.order.service.exception.RemoveFromCartException;
import org.broadleafcommerce.core.order.service.exception.UpdateCartException;
import org.broadleafcommerce.core.pricing.service.exception.PricingException;
import org.broadleafcommerce.core.web.controller.cart.AbstractCartController;
import org.broadleafcommerce.core.web.order.CartState;
import org.broadleafcommerce.profile.web.core.CustomerState;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.ui.Model;

public class BroadleafCartController
extends AbstractCartController {
    protected static String cartView = "cart/cart";
    protected static String cartPageRedirect = "redirect:/cart";
    @Value(value="${solr.index.use.sku}")
    protected boolean useSku;

    public String cart(HttpServletRequest request, HttpServletResponse response, Model model) throws PricingException {
        Order cart = CartState.getCart();
        if (cart != null && !(cart instanceof NullOrderImpl)) {
            model.addAttribute("paymentRequestDTO", (Object)this.dtoTranslationService.translateOrder(CartState.getCart()));
        }
        return this.getCartView();
    }

    public String add(HttpServletRequest request, HttpServletResponse response, Model model, AddToCartItem itemRequest) throws IOException, AddToCartException, PricingException {
        Order cart = CartState.getCart();
        if (cart == null || cart instanceof NullOrderImpl) {
            cart = this.orderService.createNewCartForCustomer(CustomerState.getCustomer((HttpServletRequest)request));
        }
        this.updateCartService.validateCart(cart);
        cart = this.orderService.addItem(cart.getId(), (OrderItemRequestDTO)itemRequest, false);
        cart = this.orderService.save(cart, Boolean.valueOf(true));
        return this.isAjaxRequest(request) ? this.getCartView() : this.getCartPageRedirect();
    }

    public String addWithPriceOverride(HttpServletRequest request, HttpServletResponse response, Model model, AddToCartItem itemRequest) throws IOException, AddToCartException, PricingException {
        Order cart = CartState.getCart();
        if (cart == null || cart instanceof NullOrderImpl) {
            cart = this.orderService.createNewCartForCustomer(CustomerState.getCustomer((HttpServletRequest)request));
        }
        this.updateCartService.validateCart(cart);
        cart = this.orderService.addItemWithPriceOverrides(cart.getId(), (OrderItemRequestDTO)itemRequest, false);
        cart = this.orderService.save(cart, Boolean.valueOf(true));
        return this.isAjaxRequest(request) ? this.getCartView() : this.getCartPageRedirect();
    }

    public String updateQuantity(HttpServletRequest request, HttpServletResponse response, Model model, AddToCartItem itemRequest) throws IOException, UpdateCartException, PricingException, RemoveFromCartException {
        Order cart = CartState.getCart();
        cart = this.orderService.updateItemQuantity(cart.getId(), (OrderItemRequestDTO)itemRequest, true);
        cart = this.orderService.save(cart, Boolean.valueOf(false));
        if (this.isAjaxRequest(request)) {
            HashMap<String, Number> extraData = new HashMap<String, Number>();
            if (this.useSku) {
                extraData.put("skuId", itemRequest.getSkuId());
            } else {
                extraData.put("productId", itemRequest.getProductId());
            }
            extraData.put("cartItemCount", cart.getItemCount());
            model.addAttribute("blcextradata", (Object)new ObjectMapper().writeValueAsString(extraData));
            return this.getCartView();
        }
        return this.getCartPageRedirect();
    }

    public String remove(HttpServletRequest request, HttpServletResponse response, Model model, AddToCartItem itemRequest) throws IOException, PricingException, RemoveFromCartException {
        Order cart = CartState.getCart();
        cart = this.orderService.removeItem(cart.getId(), itemRequest.getOrderItemId(), false);
        cart = this.orderService.save(cart, Boolean.valueOf(true));
        if (this.isAjaxRequest(request)) {
            HashMap<String, Number> extraData = new HashMap<String, Number>();
            extraData.put("cartItemCount", cart.getItemCount());
            if (this.useSku) {
                extraData.put("skuId", itemRequest.getSkuId());
            } else {
                extraData.put("productId", itemRequest.getProductId());
            }
            model.addAttribute("blcextradata", (Object)new ObjectMapper().writeValueAsString(extraData));
            return this.getCartView();
        }
        return this.getCartPageRedirect();
    }

    public String empty(HttpServletRequest request, HttpServletResponse response, Model model) throws PricingException {
        Order cart = CartState.getCart();
        this.orderService.cancelOrder(cart);
        CartState.setCart(null);
        return "redirect:/";
    }

    public String addPromo(HttpServletRequest request, HttpServletResponse response, Model model, String customerOffer) throws IOException, PricingException {
        Order cart = CartState.getCart();
        Boolean promoAdded = false;
        String exception = "";
        if (cart != null && !(cart instanceof NullOrderImpl)) {
            OfferCode offerCode = this.offerService.lookupOfferCodeByCode(customerOffer);
            if (offerCode != null) {
                try {
                    this.orderService.addOfferCode(cart, offerCode, false);
                    promoAdded = true;
                    cart = this.orderService.save(cart, Boolean.valueOf(true));
                }
                catch (OfferMaxUseExceededException e) {
                    exception = "Use Limit Exceeded";
                }
            } else {
                exception = "Invalid Code";
            }
        } else {
            exception = "Invalid cart";
        }
        if (this.isAjaxRequest(request)) {
            HashMap<String, Object> extraData = new HashMap<String, Object>();
            extraData.put("promoAdded", promoAdded);
            extraData.put("exception", exception);
            model.addAttribute("blcextradata", (Object)new ObjectMapper().writeValueAsString(extraData));
            return this.getCartView();
        }
        model.addAttribute("exception", (Object)exception);
        return this.getCartView();
    }

    public String removePromo(HttpServletRequest request, HttpServletResponse response, Model model, Long offerCodeId) throws IOException, PricingException {
        Order cart = CartState.getCart();
        OfferCode offerCode = this.offerService.findOfferCodeById(offerCodeId);
        this.orderService.removeOfferCode(cart, offerCode, false);
        cart = this.orderService.save(cart, Boolean.valueOf(true));
        return this.isAjaxRequest(request) ? this.getCartView() : this.getCartPageRedirect();
    }

    public String getCartView() {
        return cartView;
    }

    public String getCartPageRedirect() {
        return cartPageRedirect;
    }

    public Map<String, String> handleIllegalCartOpException(IllegalCartOperationException ex) {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        returnMap.put("error", "illegalCartOperation");
        returnMap.put("exception", BLCMessageUtils.getMessage((String)ex.getType()));
        return returnMap;
    }
}

