/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.api.wrapper;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.core.offer.domain.Adjustment;
import org.broadleafcommerce.core.offer.domain.OrderItemPriceDetailAdjustment;
import org.broadleafcommerce.core.order.domain.OrderItemPriceDetail;
import org.broadleafcommerce.core.web.api.wrapper.APIWrapper;
import org.broadleafcommerce.core.web.api.wrapper.AdjustmentWrapper;
import org.broadleafcommerce.core.web.api.wrapper.BaseWrapper;

@XmlRootElement(name="orderItemAttribute")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class OrderItemPriceDetailWrapper
extends BaseWrapper
implements APIWrapper<OrderItemPriceDetail> {
    @XmlElement
    protected Long id;
    @XmlElement
    protected Money totalAdjustmentValue;
    @XmlElement
    protected Money totalAdjustedPrice;
    @XmlElement
    protected Integer quantity;
    @XmlElement(name="adjustment")
    @XmlElementWrapper(name="adjustments")
    protected List<AdjustmentWrapper> orderItemPriceDetailAdjustments = new LinkedList<AdjustmentWrapper>();

    @Override
    public void wrapDetails(OrderItemPriceDetail model, HttpServletRequest request) {
        this.id = model.getId();
        this.quantity = model.getQuantity();
        this.totalAdjustmentValue = model.getTotalAdjustmentValue();
        this.totalAdjustedPrice = model.getTotalAdjustedPrice();
        if (!model.getOrderItemPriceDetailAdjustments().isEmpty()) {
            this.orderItemPriceDetailAdjustments = new ArrayList<AdjustmentWrapper>();
            for (OrderItemPriceDetailAdjustment orderItemPriceDetail : model.getOrderItemPriceDetailAdjustments()) {
                AdjustmentWrapper orderItemPriceDetailAdjustmentWrapper = (AdjustmentWrapper)this.context.getBean(AdjustmentWrapper.class.getName());
                orderItemPriceDetailAdjustmentWrapper.wrapSummary((Adjustment)orderItemPriceDetail, request);
                this.orderItemPriceDetailAdjustments.add(orderItemPriceDetailAdjustmentWrapper);
            }
        }
    }

    @Override
    public void wrapSummary(OrderItemPriceDetail model, HttpServletRequest request) {
        this.wrapDetails(model, request);
    }
}

