/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.api.wrapper;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupItem;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.domain.TaxDetail;
import org.broadleafcommerce.core.order.service.OrderItemService;
import org.broadleafcommerce.core.order.service.call.FulfillmentGroupItemRequest;
import org.broadleafcommerce.core.web.api.wrapper.APIUnwrapper;
import org.broadleafcommerce.core.web.api.wrapper.APIWrapper;
import org.broadleafcommerce.core.web.api.wrapper.BaseWrapper;
import org.broadleafcommerce.core.web.api.wrapper.TaxDetailWrapper;
import org.springframework.context.ApplicationContext;

@XmlRootElement(name="fulfillmentGroupItem")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class FulfillmentGroupItemWrapper
extends BaseWrapper
implements APIWrapper<FulfillmentGroupItem>,
APIUnwrapper<FulfillmentGroupItemRequest> {
    @XmlElement
    protected Long id;
    @XmlElement
    protected Long fulfillmentGroupId;
    @XmlElement
    protected Long orderItemId;
    @XmlElement
    protected Money totalTax;
    @XmlElement
    protected Integer quantity;
    @XmlElement
    protected Money totalItemAmount;
    @XmlElement(name="taxDetail")
    @XmlElementWrapper(name="taxDetails")
    protected List<TaxDetailWrapper> taxDetails;

    @Override
    public void wrapDetails(FulfillmentGroupItem model, HttpServletRequest request) {
        this.id = model.getId();
        if (model.getFulfillmentGroup() != null) {
            this.fulfillmentGroupId = model.getFulfillmentGroup().getId();
        }
        if (model.getOrderItem() != null) {
            this.orderItemId = model.getOrderItem().getId();
        }
        this.totalTax = model.getTotalTax();
        this.quantity = model.getQuantity();
        this.totalItemAmount = model.getTotalItemAmount();
        List taxes = model.getTaxes();
        if (taxes != null && !taxes.isEmpty()) {
            this.taxDetails = new ArrayList<TaxDetailWrapper>();
            for (TaxDetail detail : taxes) {
                TaxDetailWrapper taxDetailWrapper = (TaxDetailWrapper)this.context.getBean(TaxDetailWrapper.class.getName());
                taxDetailWrapper.wrapSummary(detail, request);
                this.taxDetails.add(taxDetailWrapper);
            }
        }
    }

    @Override
    public void wrapSummary(FulfillmentGroupItem model, HttpServletRequest request) {
        this.wrapDetails(model, request);
    }

    @Override
    public FulfillmentGroupItemRequest unwrap(HttpServletRequest request, ApplicationContext appContext) {
        OrderItemService orderItemService = (OrderItemService)appContext.getBean("blOrderItemService");
        OrderItem orderItem = orderItemService.readOrderItemById(this.orderItemId);
        if (orderItem != null) {
            FulfillmentGroupItemRequest fulfillmentGroupItemRequest = new FulfillmentGroupItemRequest();
            fulfillmentGroupItemRequest.setOrderItem(orderItem);
            fulfillmentGroupItemRequest.setQuantity(this.quantity.intValue());
            return fulfillmentGroupItemRequest;
        }
        return null;
    }
}

