/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.api;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.type.TypeModifier;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationModule;
import javax.annotation.Resource;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.core.web.api.WrapperOverrideTypeModifier;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Provider
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Component(value="blObjectMapperProvider")
@Scope(value="singleton")
public class ObjectMapperProvider
implements ContextResolver<ObjectMapper>,
InitializingBean {
    private static final Log LOG = LogFactory.getLog(ObjectMapperProvider.class);
    @Resource(name="blWrapperOverrideTypeModifier")
    protected WrapperOverrideTypeModifier typeModifier;
    protected ObjectMapper mapper;

    public void afterPropertiesSet() throws Exception {
        this.mapper = new ObjectMapper();
        this.mapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
        this.mapper.configure(SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED, false);
        JaxbAnnotationModule jaxbModule = new JaxbAnnotationModule();
        jaxbModule.setPriority(JaxbAnnotationModule.Priority.PRIMARY);
        this.mapper.registerModule((Module)new JaxbAnnotationModule());
        this.mapper.setTypeFactory(TypeFactory.defaultInstance().withModifier((TypeModifier)this.typeModifier));
    }

    public ObjectMapper getContext(Class<?> type) {
        return this.mapper;
    }
}

