/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.processor;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.core.catalog.domain.ProductOptionValue;
import org.thymeleaf.Arguments;
import org.thymeleaf.Configuration;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.dom.Element;
import org.thymeleaf.processor.ProcessorResult;
import org.thymeleaf.processor.attr.AbstractAttrProcessor;
import org.thymeleaf.standard.expression.Expression;
import org.thymeleaf.standard.expression.StandardExpressions;

public class ProductOptionValueProcessor
extends AbstractAttrProcessor {
    private static final Log LOG = LogFactory.getLog(ProductOptionValueProcessor.class);

    public ProductOptionValueProcessor() {
        super("product_option_value");
    }

    protected ProcessorResult processAttribute(Arguments arguments, Element element, String attributeName) {
        Expression expression = (Expression)StandardExpressions.getExpressionParser((Configuration)arguments.getConfiguration()).parseExpression(arguments.getConfiguration(), (IProcessingContext)arguments, element.getAttributeValue(attributeName));
        ProductOptionValue productOptionValue = (ProductOptionValue)expression.execute(arguments.getConfiguration(), (IProcessingContext)arguments);
        ProductOptionValueDTO dto = new ProductOptionValueDTO();
        dto.setOptionId(productOptionValue.getProductOption().getId());
        dto.setValueId(productOptionValue.getId());
        dto.setValueName(productOptionValue.getAttributeValue());
        if (productOptionValue.getPriceAdjustment() != null) {
            dto.setPriceAdjustment(productOptionValue.getPriceAdjustment().getAmount());
        }
        try {
            ObjectMapper mapper = new ObjectMapper();
            StringWriter strWriter = new StringWriter();
            mapper.writeValue((Writer)strWriter, (Object)dto);
            element.setAttribute("data-product-option-value", ((Object)strWriter).toString());
            element.removeAttribute(attributeName);
            return ProcessorResult.OK;
        }
        catch (Exception ex) {
            LOG.error((Object)"There was a problem writing the product option value to JSON", (Throwable)ex);
            return null;
        }
    }

    public int getPrecedence() {
        return 10000;
    }

    private class ProductOptionValueDTO {
        private Long optionId;
        private Long valueId;
        private String valueName;
        private BigDecimal priceAdjustment;

        private ProductOptionValueDTO() {
        }

        public Long getOptionId() {
            return this.optionId;
        }

        public void setOptionId(Long optionId) {
            this.optionId = optionId;
        }

        public Long getValueId() {
            return this.valueId;
        }

        public void setValueId(Long valueId) {
            this.valueId = valueId;
        }

        public String getValueName() {
            return this.valueName;
        }

        public void setValueName(String valueName) {
            this.valueName = valueName;
        }

        public BigDecimal getPriceAdjustment() {
            return this.priceAdjustment;
        }

        public void setPriceAdjustment(BigDecimal priceAdjustment) {
            this.priceAdjustment = priceAdjustment;
        }
    }
}

