/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.processor;

import javax.annotation.Resource;
import org.broadleafcommerce.common.exception.ServiceException;
import org.broadleafcommerce.common.security.service.ExploitProtectionService;
import org.springframework.stereotype.Component;
import org.thymeleaf.Arguments;
import org.thymeleaf.Configuration;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.dom.Element;
import org.thymeleaf.dom.Node;
import org.thymeleaf.processor.ProcessorResult;
import org.thymeleaf.processor.element.AbstractElementProcessor;
import org.thymeleaf.standard.expression.Expression;
import org.thymeleaf.standard.expression.StandardExpressions;

@Component(value="blFormProcessor")
public class FormProcessor
extends AbstractElementProcessor {
    @Resource(name="blExploitProtectionService")
    protected ExploitProtectionService eps;

    public FormProcessor() {
        super("form");
    }

    public int getPrecedence() {
        return 1;
    }

    protected ProcessorResult processElement(Arguments arguments, Element element) {
        if (!"GET".equalsIgnoreCase(element.getAttributeValueFromNormalizedName("method"))) {
            try {
                String csrfToken = this.eps.getCSRFToken();
                if ("multipart/form-data".equalsIgnoreCase(element.getAttributeValueFromNormalizedName("enctype"))) {
                    Expression expression = (Expression)StandardExpressions.getExpressionParser((Configuration)arguments.getConfiguration()).parseExpression(arguments.getConfiguration(), (IProcessingContext)arguments, element.getAttributeValueFromNormalizedName("th:action"));
                    String action = (String)expression.execute(arguments.getConfiguration(), (IProcessingContext)arguments);
                    String csrfQueryParameter = "?" + this.eps.getCsrfTokenParameter() + "=" + csrfToken;
                    element.removeAttribute("th:action");
                    element.setAttribute("action", action + csrfQueryParameter);
                } else {
                    Element csrfNode = new Element("input");
                    csrfNode.setAttribute("type", "hidden");
                    csrfNode.setAttribute("name", this.eps.getCsrfTokenParameter());
                    csrfNode.setAttribute("value", csrfToken);
                    element.addChild((Node)csrfNode);
                }
            }
            catch (ServiceException e) {
                throw new RuntimeException("Could not get a CSRF token for this session", e);
            }
        }
        Element newElement = element.cloneElementNodeWithNewName(element.getParent(), "form", false);
        newElement.setRecomputeProcessorsImmediately(true);
        element.getParent().insertAfter((Node)element, (Node)newElement);
        element.getParent().removeChild((Node)element);
        return ProcessorResult.OK;
    }
}

