/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.controller.account;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.broadleafcommerce.common.exception.ServiceException;
import org.broadleafcommerce.core.web.controller.account.AbstractCustomerAddressController;
import org.broadleafcommerce.core.web.controller.account.CustomerAddressForm;
import org.broadleafcommerce.profile.core.domain.Address;
import org.broadleafcommerce.profile.core.domain.CustomerAddress;
import org.broadleafcommerce.profile.web.core.CustomerState;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

public class BroadleafManageCustomerAddressesController
extends AbstractCustomerAddressController {
    protected String addressUpdatedMessage = "Address successfully updated";
    protected String addressAddedMessage = "Address successfully added";
    protected String addressRemovedMessage = "Address successfully removed";
    protected String addressRemovedErrorMessage = "Address could not be removed as it is in use";

    public String viewCustomerAddresses(HttpServletRequest request, Model model) {
        model.addAttribute("customerAddressForm", (Object)new CustomerAddressForm());
        return this.getCustomerAddressesView();
    }

    public String viewCustomerAddress(HttpServletRequest request, Model model, Long customerAddressId) {
        CustomerAddress customerAddress = this.customerAddressService.readCustomerAddressById(customerAddressId);
        if (customerAddress == null) {
            throw new IllegalArgumentException("Customer Address not found with the specified customerAddressId");
        }
        CustomerAddressForm form = new CustomerAddressForm();
        form.setAddress(customerAddress.getAddress());
        form.setAddressName(customerAddress.getAddressName());
        form.setCustomerAddressId(customerAddress.getId());
        model.addAttribute("customerAddressForm", (Object)form);
        return this.getCustomerAddressesView();
    }

    public String addCustomerAddress(HttpServletRequest request, Model model, CustomerAddressForm form, BindingResult result, RedirectAttributes redirectAttributes) throws ServiceException {
        this.customerAddressValidator.validate(form, (Errors)result);
        if (result.hasErrors()) {
            return this.getCustomerAddressesView();
        }
        Address address = this.addressService.saveAddress(form.getAddress());
        CustomerAddress customerAddress = this.customerAddressService.create();
        customerAddress.setAddress(address);
        customerAddress.setAddressName(form.getAddressName());
        customerAddress.setCustomer(CustomerState.getCustomer());
        customerAddress = this.customerAddressService.saveCustomerAddress(customerAddress);
        if (form.getAddress().isDefault()) {
            this.customerAddressService.makeCustomerAddressDefault(customerAddress.getId(), customerAddress.getCustomer().getId());
        }
        if (!this.isAjaxRequest(request)) {
            List addresses = this.customerAddressService.readActiveCustomerAddressesByCustomerId(CustomerState.getCustomer().getId());
            model.addAttribute("addresses", (Object)addresses);
        }
        redirectAttributes.addFlashAttribute("successMessage", (Object)this.getAddressAddedMessage());
        return this.getCustomerAddressesRedirect();
    }

    public String updateCustomerAddress(HttpServletRequest request, Model model, Long customerAddressId, CustomerAddressForm form, BindingResult result, RedirectAttributes redirectAttributes) throws ServiceException {
        this.customerAddressValidator.validate(form, (Errors)result);
        if (result.hasErrors()) {
            return this.getCustomerAddressesView();
        }
        CustomerAddress customerAddress = this.customerAddressService.readCustomerAddressById(customerAddressId);
        if (customerAddress == null) {
            throw new IllegalArgumentException("Customer Address not found with the specified customerAddressId");
        }
        customerAddress.setAddress(form.getAddress());
        customerAddress.setAddressName(form.getAddressName());
        customerAddress = this.customerAddressService.saveCustomerAddress(customerAddress);
        if (form.getAddress().isDefault()) {
            this.customerAddressService.makeCustomerAddressDefault(customerAddress.getId(), customerAddress.getCustomer().getId());
        }
        redirectAttributes.addFlashAttribute("successMessage", (Object)this.getAddressUpdatedMessage());
        return this.getCustomerAddressesRedirect();
    }

    public String removeCustomerAddress(HttpServletRequest request, Model model, Long customerAddressId, RedirectAttributes redirectAttributes) {
        try {
            this.customerAddressService.deleteCustomerAddressById(customerAddressId);
            redirectAttributes.addFlashAttribute("successMessage", (Object)this.getAddressRemovedMessage());
        }
        catch (DataIntegrityViolationException e) {
            redirectAttributes.addFlashAttribute("errorMessage", (Object)this.getAddressRemovedErrorMessage());
        }
        return this.getCustomerAddressesRedirect();
    }

    public String getAddressUpdatedMessage() {
        return this.addressUpdatedMessage;
    }

    public String getAddressAddedMessage() {
        return this.addressAddedMessage;
    }

    public String getAddressRemovedMessage() {
        return this.addressRemovedMessage;
    }

    public String getAddressRemovedErrorMessage() {
        return this.addressRemovedErrorMessage;
    }
}

