/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.controller.account;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.i18n.domain.ISOCountry;
import org.broadleafcommerce.common.i18n.service.ISOService;
import org.broadleafcommerce.common.web.controller.BroadleafAbstractController;
import org.broadleafcommerce.core.web.controller.account.validator.CustomerAddressValidator;
import org.broadleafcommerce.profile.core.domain.Country;
import org.broadleafcommerce.profile.core.domain.CustomerAddress;
import org.broadleafcommerce.profile.core.domain.Phone;
import org.broadleafcommerce.profile.core.domain.PhoneImpl;
import org.broadleafcommerce.profile.core.domain.State;
import org.broadleafcommerce.profile.core.service.AddressService;
import org.broadleafcommerce.profile.core.service.CountryService;
import org.broadleafcommerce.profile.core.service.CustomerAddressService;
import org.broadleafcommerce.profile.core.service.StateService;
import org.broadleafcommerce.profile.web.core.CustomerState;
import org.springframework.web.bind.ServletRequestDataBinder;

public class AbstractCustomerAddressController
extends BroadleafAbstractController {
    private static final Log LOG = LogFactory.getLog(AbstractCustomerAddressController.class);
    protected static String customerAddressesView = "account/manageCustomerAddresses";
    protected static String customerAddressesRedirect = "redirect:/account/addresses";
    @Resource(name="blCustomerAddressService")
    protected CustomerAddressService customerAddressService;
    @Resource(name="blAddressService")
    protected AddressService addressService;
    @Resource(name="blCountryService")
    protected CountryService countryService;
    @Resource(name="blCustomerAddressValidator")
    protected CustomerAddressValidator customerAddressValidator;
    @Resource(name="blStateService")
    protected StateService stateService;
    @Resource(name="blISOService")
    protected ISOService isoService;

    protected void initBinder(HttpServletRequest request, ServletRequestDataBinder binder) throws Exception {
        binder.registerCustomEditor(State.class, "address.state", (PropertyEditor)new PropertyEditorSupport(){

            @Override
            public void setAsText(String text) {
                if (StringUtils.isNotEmpty((String)text)) {
                    State state = AbstractCustomerAddressController.this.stateService.findStateByAbbreviation(text);
                    this.setValue(state);
                } else {
                    this.setValue(null);
                }
            }
        });
        binder.registerCustomEditor(Country.class, "address.country", (PropertyEditor)new PropertyEditorSupport(){

            @Override
            public void setAsText(String text) {
                if (StringUtils.isNotEmpty((String)text)) {
                    Country country = AbstractCustomerAddressController.this.countryService.findCountryByAbbreviation(text);
                    this.setValue(country);
                } else {
                    this.setValue(null);
                }
            }
        });
        binder.registerCustomEditor(ISOCountry.class, "address.isoCountryAlpha2", (PropertyEditor)new PropertyEditorSupport(){

            @Override
            public void setAsText(String text) {
                if (StringUtils.isNotEmpty((String)text)) {
                    ISOCountry isoCountry = AbstractCustomerAddressController.this.isoService.findISOCountryByAlpha2Code(text);
                    this.setValue(isoCountry);
                } else {
                    this.setValue(null);
                }
            }
        });
        binder.registerCustomEditor(Phone.class, "address.phonePrimary", (PropertyEditor)new PropertyEditorSupport(){

            @Override
            public void setAsText(String text) {
                if (!StringUtils.isBlank((String)text)) {
                    PhoneImpl phone = new PhoneImpl();
                    phone.setPhoneNumber(text);
                    this.setValue(phone);
                } else {
                    this.setValue(null);
                }
            }
        });
    }

    protected List<State> populateStates() {
        return this.stateService.findStates();
    }

    protected List<Country> populateCountries() {
        return this.countryService.findCountries();
    }

    protected List<CustomerAddress> populateCustomerAddresses() {
        return this.customerAddressService.readActiveCustomerAddressesByCustomerId(CustomerState.getCustomer().getId());
    }

    public String getCustomerAddressesView() {
        return customerAddressesView;
    }

    public String getCustomerAddressesRedirect() {
        return customerAddressesRedirect;
    }
}

