/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.api.wrapper;

import javax.servlet.http.HttpServletRequest;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.broadleafcommerce.core.web.api.wrapper.APIUnwrapper;
import org.broadleafcommerce.core.web.api.wrapper.APIWrapper;
import org.broadleafcommerce.core.web.api.wrapper.BaseWrapper;
import org.broadleafcommerce.profile.core.domain.Country;
import org.broadleafcommerce.profile.core.service.CountryService;
import org.springframework.context.ApplicationContext;

@XmlRootElement(name="country")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class CountryWrapper
extends BaseWrapper
implements APIWrapper<Country>,
APIUnwrapper<Country> {
    @XmlElement
    protected String name;
    @XmlElement
    protected String abbreviation;

    @Override
    public void wrapDetails(Country model, HttpServletRequest request) {
        this.name = model.getName();
        this.abbreviation = model.getAbbreviation();
    }

    @Override
    public void wrapSummary(Country model, HttpServletRequest request) {
        this.wrapDetails(model, request);
    }

    @Override
    public Country unwrap(HttpServletRequest request, ApplicationContext appContext) {
        CountryService countryService = (CountryService)appContext.getBean("blCountryService");
        if (this.abbreviation != null) {
            Country country = countryService.findCountryByAbbreviation(this.abbreviation);
            return country;
        }
        return null;
    }
}

