/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.order.security;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.broadleafcommerce.common.security.MergeCartProcessor;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.service.MergeCartService;
import org.broadleafcommerce.core.order.service.OrderService;
import org.broadleafcommerce.core.order.service.call.MergeCartResponse;
import org.broadleafcommerce.core.order.service.exception.RemoveFromCartException;
import org.broadleafcommerce.core.pricing.service.exception.PricingException;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.core.service.CustomerService;
import org.broadleafcommerce.profile.web.core.security.CustomerStateRequestProcessor;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.context.request.WebRequest;

@Deprecated
@Component(value="blMergeCartProcessor")
public class MergeCartProcessorImpl
implements MergeCartProcessor {
    protected String mergeCartResponseKey = "bl_merge_cart_response";
    @Resource(name="blCustomerService")
    protected CustomerService customerService;
    @Resource(name="blOrderService")
    protected OrderService orderService;
    @Resource(name="blMergeCartService")
    protected MergeCartService mergeCartService;
    @Resource(name="blCustomerStateRequestProcessor")
    protected CustomerStateRequestProcessor customerStateRequestProcessor;

    public void execute(HttpServletRequest request, HttpServletResponse response, Authentication authResult) {
        this.execute((WebRequest)new ServletWebRequest(request, response), authResult);
    }

    public void execute(WebRequest request, Authentication authResult) {
        MergeCartResponse mergeCartResponse;
        Customer loggedInCustomer = this.customerService.readCustomerByUsername(authResult.getName());
        Customer anonymousCustomer = this.customerStateRequestProcessor.getAnonymousCustomer(request);
        Order cart = null;
        if (anonymousCustomer != null) {
            cart = this.orderService.findCartForCustomer(anonymousCustomer);
        }
        try {
            mergeCartResponse = this.mergeCartService.mergeCart(loggedInCustomer, cart);
        }
        catch (PricingException e) {
            throw new RuntimeException(e);
        }
        catch (RemoveFromCartException e) {
            throw new RuntimeException(e);
        }
        request.setAttribute(this.mergeCartResponseKey, (Object)mergeCartResponse, 2);
    }

    public String getMergeCartResponseKey() {
        return this.mergeCartResponseKey;
    }

    public void setMergeCartResponseKey(String mergeCartResponseKey) {
        this.mergeCartResponseKey = mergeCartResponseKey;
    }
}

