/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.controller.catalog;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.broadleafcommerce.common.exception.ServiceException;
import org.broadleafcommerce.common.security.service.ExploitProtectionService;
import org.broadleafcommerce.common.util.UrlUtil;
import org.broadleafcommerce.core.search.domain.ProductSearchCriteria;
import org.broadleafcommerce.core.search.domain.ProductSearchResult;
import org.broadleafcommerce.core.search.redirect.domain.SearchRedirect;
import org.broadleafcommerce.core.search.redirect.service.SearchRedirectService;
import org.broadleafcommerce.core.search.service.SearchService;
import org.broadleafcommerce.core.web.controller.catalog.AbstractCatalogController;
import org.broadleafcommerce.core.web.service.SearchFacetDTOService;
import org.broadleafcommerce.core.web.util.ProcessorUtils;
import org.springframework.ui.Model;

public class BroadleafSearchController
extends AbstractCatalogController {
    @Resource(name="blSearchService")
    protected SearchService searchService;
    @Resource(name="blExploitProtectionService")
    protected ExploitProtectionService exploitProtectionService;
    @Resource(name="blSearchFacetDTOService")
    protected SearchFacetDTOService facetService;
    @Resource(name="blSearchRedirectService")
    protected SearchRedirectService searchRedirectService;
    protected static String searchView = "catalog/search";
    protected static String PRODUCTS_ATTRIBUTE_NAME = "products";
    protected static String FACETS_ATTRIBUTE_NAME = "facets";
    protected static String PRODUCT_SEARCH_RESULT_ATTRIBUTE_NAME = "result";
    protected static String ACTIVE_FACETS_ATTRIBUTE_NAME = "activeFacets";
    protected static String ORIGINAL_QUERY_ATTRIBUTE_NAME = "originalQuery";

    public String search(Model model, HttpServletRequest request, HttpServletResponse response, String query) throws ServletException, IOException, ServiceException {
        try {
            if (StringUtils.isNotEmpty((String)query)) {
                query = StringUtils.trim((String)query);
                query = this.exploitProtectionService.cleanString(query);
            }
        }
        catch (ServiceException e) {
            query = null;
        }
        if (query == null || query.length() == 0) {
            return "redirect:/";
        }
        if (request.getParameterMap().containsKey("facetField")) {
            String fieldName = request.getParameter("facetField");
            ArrayList<String> activeFieldFilters = new ArrayList<String>();
            HashMap<String, String[]> parameters = new HashMap<String, String[]>(request.getParameterMap());
            Iterator iter = parameters.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String key = (String)entry.getKey();
                if (!key.startsWith(fieldName + "-")) continue;
                activeFieldFilters.add(key.substring(key.indexOf(45) + 1));
                iter.remove();
            }
            parameters.remove(ProductSearchCriteria.PAGE_NUMBER);
            parameters.put(fieldName, activeFieldFilters.toArray(new String[activeFieldFilters.size()]));
            parameters.remove("facetField");
            String newUrl = ProcessorUtils.getUrl(request.getRequestURL().toString(), parameters);
            return "redirect:" + newUrl;
        }
        SearchRedirect handler = this.searchRedirectService.findSearchRedirectBySearchTerm(query);
        if (handler != null) {
            String contextPath = request.getContextPath();
            String url = UrlUtil.fixRedirectUrl((String)contextPath, (String)handler.getUrl());
            response.sendRedirect(url);
            return null;
        }
        if (StringUtils.isNotEmpty((String)query)) {
            List availableFacets = this.getSearchService().getSearchFacets();
            ProductSearchCriteria searchCriteria = this.facetService.buildSearchCriteria(request, availableFacets);
            ProductSearchResult result = this.getSearchService().findProductsByQuery(query, searchCriteria);
            this.facetService.setActiveFacetResults(result.getFacets(), request);
            model.addAttribute(PRODUCTS_ATTRIBUTE_NAME, (Object)result.getProducts());
            model.addAttribute(FACETS_ATTRIBUTE_NAME, (Object)result.getFacets());
            model.addAttribute(PRODUCT_SEARCH_RESULT_ATTRIBUTE_NAME, (Object)result);
            model.addAttribute(ORIGINAL_QUERY_ATTRIBUTE_NAME, (Object)query);
        }
        return this.getSearchView();
    }

    public String getSearchView() {
        return searchView;
    }

    protected SearchService getSearchService() {
        return this.searchService;
    }
}

