/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.processor;

import java.text.NumberFormat;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.common.web.BroadleafRequestContext;
import org.thymeleaf.Arguments;
import org.thymeleaf.dom.Element;
import org.thymeleaf.processor.attr.AbstractTextChildModifierAttrProcessor;
import org.thymeleaf.standard.expression.StandardExpressionProcessor;

public class PriceTextDisplayProcessor
extends AbstractTextChildModifierAttrProcessor {
    public PriceTextDisplayProcessor() {
        super("price");
    }

    public int getPrecedence() {
        return 1500;
    }

    protected String getText(Arguments arguments, Element element, String attributeName) {
        Money price;
        try {
            price = (Money)StandardExpressionProcessor.processExpression((Arguments)arguments, (String)element.getAttributeValue(attributeName));
        }
        catch (ClassCastException e) {
            Number value = (Number)StandardExpressionProcessor.processExpression((Arguments)arguments, (String)element.getAttributeValue(attributeName));
            price = new Money(value.doubleValue());
        }
        if (price == null) {
            return "Not Available";
        }
        BroadleafRequestContext brc = BroadleafRequestContext.getBroadleafRequestContext();
        if (brc.getJavaLocale() != null) {
            NumberFormat format = NumberFormat.getCurrencyInstance(brc.getJavaLocale());
            format.setCurrency(price.getCurrency());
            return format.format(price.getAmount());
        }
        return "$ " + price.getAmount().toString();
    }
}

