/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.order.security;

import java.util.HashMap;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.web.AbstractBroadleafWebRequestProcessor;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.service.OrderService;
import org.broadleafcommerce.core.order.service.call.UpdateCartResponse;
import org.broadleafcommerce.core.web.service.UpdateCartService;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.web.core.security.CustomerStateRequestProcessor;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.WebRequest;

@Component(value="blCartStateRequestProcessor")
public class CartStateRequestProcessor
extends AbstractBroadleafWebRequestProcessor {
    protected final Log LOG = LogFactory.getLog(((Object)((Object)this)).getClass());
    public static final String BLC_RULE_MAP_PARAM = "blRuleMap";
    protected boolean copyCartWhenSpecifiedStateChanges = false;
    @Resource(name="blOrderService")
    protected OrderService orderService;
    @Resource(name="blUpdateCartService")
    protected UpdateCartService updateCartService;
    protected static String cartRequestAttributeName = "cart";

    public void process(WebRequest request) {
        Customer customer = (Customer)request.getAttribute(CustomerStateRequestProcessor.getCustomerRequestAttributeName(), 0);
        if (customer != null) {
            Order cart;
            if (this.LOG.isTraceEnabled()) {
                this.LOG.trace((Object)("Looking up cart for customer " + customer.getId()));
            }
            if ((cart = this.orderService.findCartForCustomer(customer)) == null) {
                cart = this.orderService.getNullOrder();
            } else {
                try {
                    this.updateCartService.validateCart(cart);
                }
                catch (IllegalArgumentException e) {
                    if (this.copyCartWhenSpecifiedStateChanges) {
                        UpdateCartResponse updateCartResponse = this.updateCartService.copyCartToCurrentContext(cart);
                        request.setAttribute("updateCartResponse", (Object)updateCartResponse, 0);
                    }
                    this.orderService.cancelOrder(cart);
                    cart = this.orderService.createNewCartForCustomer(customer);
                }
            }
            request.setAttribute(cartRequestAttributeName, (Object)cart, 0);
            HashMap<String, Order> ruleMap = (HashMap<String, Order>)request.getAttribute(BLC_RULE_MAP_PARAM, 0);
            if (ruleMap == null) {
                ruleMap = new HashMap<String, Order>();
            }
            ruleMap.put("order", cart);
            ruleMap.put("cart", cart);
            request.setAttribute(BLC_RULE_MAP_PARAM, ruleMap, 0);
        }
    }

    public static String getCartRequestAttributeName() {
        return cartRequestAttributeName;
    }

    public static void setCartRequestAttributeName(String cartRequestAttributeName) {
        CartStateRequestProcessor.cartRequestAttributeName = cartRequestAttributeName;
    }

    public boolean isCopyCartWhenSpecifiedStateChanges() {
        return this.copyCartWhenSpecifiedStateChanges;
    }

    public void setCopyCartWhenSpecifiedStateChanges(boolean copyCartWhenSpecifiedStateChanges) {
        this.copyCartWhenSpecifiedStateChanges = copyCartWhenSpecifiedStateChanges;
    }
}

