/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.order.security;

import java.io.IOException;
import javax.annotation.Resource;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.broadleafcommerce.common.security.MergeCartProcessor;
import org.broadleafcommerce.core.web.order.security.extension.AuthSuccessHandlerExtensionHandler;
import org.broadleafcommerce.core.web.order.security.extension.AuthSuccessHandlerExtensionManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.SavedRequestAwareAuthenticationSuccessHandler;
import org.springframework.stereotype.Component;

@Component(value="blAuthenticationSuccessHandler")
public class BroadleafAuthenticationSuccessHandler
extends SavedRequestAwareAuthenticationSuccessHandler {
    @Resource(name="blMergeCartProcessor")
    private MergeCartProcessor mergeCartProcessor;
    @Resource(name="blAuthSuccessHandlerExtensionManager")
    protected AuthSuccessHandlerExtensionManager extensionManager;

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws ServletException, IOException {
        if (this.extensionManager != null) {
            ((AuthSuccessHandlerExtensionHandler)this.extensionManager.getProxy()).preMergeCartExecution(request, response, authentication);
        }
        this.mergeCartProcessor.execute(request, response, authentication);
        String targetUrl = request.getParameter(this.getTargetUrlParameter());
        if (StringUtils.isNotBlank((String)targetUrl) && targetUrl.contains(":")) {
            this.getRedirectStrategy().sendRedirect(request, response, this.getDefaultTargetUrl());
        } else {
            super.onAuthenticationSuccess(request, response, authentication);
        }
    }
}

