/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.controller.checkout;

import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.broadleafcommerce.common.extension.AbstractExtensionHandler;
import org.broadleafcommerce.common.extension.ExtensionResultStatusType;
import org.broadleafcommerce.core.order.domain.FulfillmentGroup;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.service.FulfillmentGroupService;
import org.broadleafcommerce.core.payment.domain.CreditCardPaymentInfo;
import org.broadleafcommerce.core.payment.domain.PaymentInfo;
import org.broadleafcommerce.core.payment.domain.Referenced;
import org.broadleafcommerce.core.payment.service.PaymentInfoFactory;
import org.broadleafcommerce.core.payment.service.SecurePaymentInfoService;
import org.broadleafcommerce.core.payment.service.type.PaymentInfoType;
import org.broadleafcommerce.core.web.checkout.model.BillingInfoForm;
import org.broadleafcommerce.core.web.checkout.validator.BillingInfoFormValidator;
import org.broadleafcommerce.core.web.controller.checkout.PaymentInfoServiceExtensionHandler;
import org.broadleafcommerce.core.web.controller.checkout.PaymentInfoServiceExtensionManager;
import org.broadleafcommerce.core.web.order.CartState;
import org.broadleafcommerce.profile.core.domain.Address;
import org.broadleafcommerce.profile.core.domain.AddressImpl;
import org.springframework.stereotype.Service;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;

@Service(value="blDefaultCreditCardExtensionHandler")
public class DefaultCreditCardExtensionHandler
extends AbstractExtensionHandler
implements PaymentInfoServiceExtensionHandler {
    @Resource(name="blPaymentInfoServiceExtensionManager")
    protected PaymentInfoServiceExtensionManager extensionManager;
    @Resource(name="blCreditCardPaymentInfoFactory")
    protected PaymentInfoFactory paymentInfoFactory;
    @Resource(name="blSecurePaymentInfoService")
    protected SecurePaymentInfoService securePaymentInfoService;
    @Resource(name="blBillingInfoFormValidator")
    protected BillingInfoFormValidator billingInfoFormValidator;
    @Resource(name="blFulfillmentGroupService")
    protected FulfillmentGroupService fulfillmentGroupService;

    @PostConstruct
    public void init() {
        if (this.isEnabled()) {
            this.extensionManager.registerHandler(this);
        }
    }

    @Override
    public ExtensionResultStatusType addAdditionalPaymentInfos(Map<PaymentInfo, Referenced> payments, List<PaymentInfoType> paymentInfoTypeList, HttpServletRequest request, HttpServletResponse response, Model model, BillingInfoForm billingForm, BindingResult result) {
        for (PaymentInfoType paymentInfoType : paymentInfoTypeList) {
            if (!PaymentInfoType.CREDIT_CARD.equals((Object)paymentInfoType)) continue;
            return this.addToPaymentsMap(payments, billingForm, result);
        }
        return ExtensionResultStatusType.HANDLED_CONTINUE;
    }

    protected ExtensionResultStatusType addToPaymentsMap(Map<PaymentInfo, Referenced> payments, BillingInfoForm billingForm, BindingResult result) {
        Order cart = CartState.getCart();
        if (billingForm.isUseShippingAddress()) {
            this.copyShippingAddressToBillingAddress(cart, billingForm);
        }
        this.billingInfoFormValidator.validate(billingForm, (Errors)result);
        if (result.hasErrors()) {
            return ExtensionResultStatusType.HANDLED_STOP;
        }
        PaymentInfo ccInfo = this.paymentInfoFactory.constructPaymentInfo(cart);
        ccInfo.setAddress(billingForm.getAddress());
        cart.getPaymentInfos().add(ccInfo);
        CreditCardPaymentInfo ccReference = (CreditCardPaymentInfo)this.securePaymentInfoService.create(PaymentInfoType.CREDIT_CARD);
        ccReference.setNameOnCard(billingForm.getCreditCardName());
        ccReference.setReferenceNumber(ccInfo.getReferenceNumber());
        ccReference.setPan(billingForm.getCreditCardNumber());
        ccReference.setCvvCode(billingForm.getCreditCardCvvCode());
        ccReference.setExpirationMonth(Integer.valueOf(Integer.parseInt(billingForm.getCreditCardExpMonth())));
        ccReference.setExpirationYear(Integer.valueOf(Integer.parseInt(billingForm.getCreditCardExpYear())));
        payments.put(ccInfo, (Referenced)ccReference);
        return ExtensionResultStatusType.HANDLED_CONTINUE;
    }

    protected void copyShippingAddressToBillingAddress(Order order, BillingInfoForm billingInfoForm) {
        Address shipping;
        FulfillmentGroup fulfillmentGroup = this.fulfillmentGroupService.getFirstShippableFulfillmentGroup(order);
        if (fulfillmentGroup != null && (shipping = fulfillmentGroup.getAddress()) != null) {
            AddressImpl billing = new AddressImpl();
            billing.setFirstName(shipping.getFirstName());
            billing.setLastName(shipping.getLastName());
            billing.setAddressLine1(shipping.getAddressLine1());
            billing.setAddressLine2(shipping.getAddressLine2());
            billing.setCity(shipping.getCity());
            billing.setState(shipping.getState());
            billing.setPostalCode(shipping.getPostalCode());
            billing.setCountry(shipping.getCountry());
            billing.setPhonePrimary(shipping.getPhonePrimary());
            billing.setEmailAddress(shipping.getEmailAddress());
            billingInfoForm.setAddress((Address)billing);
        }
    }
}

