/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.controller.checkout;

import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.broadleafcommerce.common.extension.AbstractExtensionHandler;
import org.broadleafcommerce.common.extension.ExtensionResultStatusType;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.payment.domain.PaymentInfo;
import org.broadleafcommerce.core.payment.domain.Referenced;
import org.broadleafcommerce.core.payment.service.CODPaymentInfoFactoryImpl;
import org.broadleafcommerce.core.payment.service.type.PaymentInfoType;
import org.broadleafcommerce.core.web.checkout.model.BillingInfoForm;
import org.broadleafcommerce.core.web.controller.checkout.PaymentInfoServiceExtensionHandler;
import org.broadleafcommerce.core.web.controller.checkout.PaymentInfoServiceExtensionManager;
import org.broadleafcommerce.core.web.order.CartState;
import org.springframework.stereotype.Service;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;

@Service(value="blDefaultCODExtensionHandler")
public class DefaultCODExtensionHandler
extends AbstractExtensionHandler
implements PaymentInfoServiceExtensionHandler {
    @Resource(name="blPaymentInfoServiceExtensionManager")
    protected PaymentInfoServiceExtensionManager extensionManager;
    @Resource(name="blCODPaymentInfoFactory")
    protected CODPaymentInfoFactoryImpl codPaymentInfoFactory;

    @PostConstruct
    public void init() {
        if (this.isEnabled()) {
            this.extensionManager.registerHandler(this);
        }
    }

    @Override
    public ExtensionResultStatusType addAdditionalPaymentInfos(Map<PaymentInfo, Referenced> payments, List<PaymentInfoType> paymentInfoTypeList, HttpServletRequest request, HttpServletResponse response, Model model, BillingInfoForm billingForm, BindingResult result) {
        for (PaymentInfoType paymentInfoType : paymentInfoTypeList) {
            if (!PaymentInfoType.COD.equals((Object)paymentInfoType)) continue;
            return this.addToPaymentsMap(payments);
        }
        return ExtensionResultStatusType.HANDLED_CONTINUE;
    }

    protected ExtensionResultStatusType addToPaymentsMap(Map<PaymentInfo, Referenced> payments) {
        Order cart = CartState.getCart();
        PaymentInfo codPaymentInfo = this.codPaymentInfoFactory.constructPaymentInfo(cart);
        cart.getPaymentInfos().add(codPaymentInfo);
        payments.put(codPaymentInfo, codPaymentInfo.createEmptyReferenced());
        return ExtensionResultStatusType.HANDLED_CONTINUE;
    }
}

