/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.controller.catalog;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.broadleafcommerce.common.web.controller.BroadleafAbstractController;
import org.broadleafcommerce.core.catalog.domain.Category;
import org.broadleafcommerce.core.search.domain.ProductSearchCriteria;
import org.broadleafcommerce.core.search.domain.ProductSearchResult;
import org.broadleafcommerce.core.search.service.SearchService;
import org.broadleafcommerce.core.web.service.SearchFacetDTOService;
import org.broadleafcommerce.core.web.util.ProcessorUtils;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.Controller;

public class BroadleafCategoryController
extends BroadleafAbstractController
implements Controller {
    protected static String defaultCategoryView = "catalog/category";
    protected static String CATEGORY_ATTRIBUTE_NAME = "category";
    protected static String PRODUCTS_ATTRIBUTE_NAME = "products";
    protected static String FACETS_ATTRIBUTE_NAME = "facets";
    protected static String PRODUCT_SEARCH_RESULT_ATTRIBUTE_NAME = "result";
    protected static String ACTIVE_FACETS_ATTRIBUTE_NAME = "activeFacets";
    @Resource(name="blSearchService")
    protected SearchService searchService;
    @Resource(name="blSearchFacetDTOService")
    protected SearchFacetDTOService facetService;

    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView model = new ModelAndView();
        if (request.getParameterMap().containsKey("facetField")) {
            String fieldName = request.getParameter("facetField");
            ArrayList<String> activeFieldFilters = new ArrayList<String>();
            HashMap<String, String[]> parameters = new HashMap<String, String[]>(request.getParameterMap());
            Iterator iter = parameters.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String key = (String)entry.getKey();
                if (!key.startsWith(fieldName + "-")) continue;
                activeFieldFilters.add(key.substring(key.indexOf(45) + 1));
                iter.remove();
            }
            parameters.remove(ProductSearchCriteria.PAGE_NUMBER);
            parameters.put(fieldName, activeFieldFilters.toArray(new String[activeFieldFilters.size()]));
            parameters.remove("facetField");
            String newUrl = ProcessorUtils.getUrl(request.getRequestURL().toString(), parameters);
            model.setViewName("redirect:" + newUrl);
        } else {
            Category category = (Category)request.getAttribute("category");
            assert (category != null);
            List availableFacets = this.getSearchService().getCategoryFacets(category);
            ProductSearchCriteria searchCriteria = this.facetService.buildSearchCriteria(request, availableFacets);
            String searchTerm = request.getParameter(ProductSearchCriteria.QUERY_STRING);
            ProductSearchResult result = StringUtils.isNotBlank((String)searchTerm) ? this.getSearchService().findProductsByCategoryAndQuery(category, searchTerm, searchCriteria) : this.getSearchService().findProductsByCategory(category, searchCriteria);
            this.facetService.setActiveFacetResults(result.getFacets(), request);
            model.addObject(CATEGORY_ATTRIBUTE_NAME, (Object)category);
            model.addObject(PRODUCTS_ATTRIBUTE_NAME, (Object)result.getProducts());
            model.addObject(FACETS_ATTRIBUTE_NAME, (Object)result.getFacets());
            model.addObject(PRODUCT_SEARCH_RESULT_ATTRIBUTE_NAME, (Object)result);
            if (StringUtils.isNotEmpty((String)category.getDisplayTemplate())) {
                model.setViewName(category.getDisplayTemplate());
            } else {
                model.setViewName(this.getDefaultCategoryView());
            }
        }
        return model;
    }

    public String getDefaultCategoryView() {
        return defaultCategoryView;
    }

    protected SearchService getSearchService() {
        return this.searchService;
    }
}

