/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.api.endpoint.checkout;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.core.checkout.service.CheckoutService;
import org.broadleafcommerce.core.checkout.service.exception.CheckoutException;
import org.broadleafcommerce.core.checkout.service.workflow.CheckoutResponse;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.service.OrderService;
import org.broadleafcommerce.core.order.service.type.OrderStatus;
import org.broadleafcommerce.core.payment.domain.PaymentInfo;
import org.broadleafcommerce.core.payment.domain.PaymentResponseItem;
import org.broadleafcommerce.core.payment.domain.Referenced;
import org.broadleafcommerce.core.payment.service.CompositePaymentService;
import org.broadleafcommerce.core.payment.service.exception.PaymentException;
import org.broadleafcommerce.core.payment.service.type.PaymentInfoType;
import org.broadleafcommerce.core.payment.service.workflow.CompositePaymentResponse;
import org.broadleafcommerce.core.pricing.service.exception.PricingException;
import org.broadleafcommerce.core.web.api.BroadleafWebServicesException;
import org.broadleafcommerce.core.web.api.endpoint.BaseEndpoint;
import org.broadleafcommerce.core.web.api.wrapper.OrderWrapper;
import org.broadleafcommerce.core.web.api.wrapper.PaymentReferenceMapWrapper;
import org.broadleafcommerce.core.web.api.wrapper.PaymentResponseItemWrapper;
import org.broadleafcommerce.core.web.order.CartState;

public abstract class CheckoutEndpoint
extends BaseEndpoint {
    private static final Log LOG = LogFactory.getLog(CheckoutEndpoint.class);
    @Resource(name="blCheckoutService")
    protected CheckoutService checkoutService;
    @Resource(name="blCompositePaymentService")
    protected CompositePaymentService compositePaymentService;
    @Resource(name="blOrderService")
    protected OrderService orderService;

    public PaymentResponseItemWrapper executePayment(HttpServletRequest request, PaymentReferenceMapWrapper mapWrapper) {
        Order cart = CartState.getCart();
        if (cart != null) {
            try {
                HashMap<PaymentInfo, Referenced> payments = new HashMap<PaymentInfo, Referenced>();
                PaymentInfo paymentInfo = mapWrapper.getPaymentInfoWrapper().unwrap(request, this.context);
                Referenced referenced = mapWrapper.getReferencedWrapper().unwrap(request, this.context);
                payments.put(paymentInfo, referenced);
                CompositePaymentResponse compositePaymentResponse = this.compositePaymentService.executePayment(cart, payments);
                PaymentResponseItem responseItem = (PaymentResponseItem)compositePaymentResponse.getPaymentResponse().getResponseItems().get(paymentInfo);
                PaymentResponseItemWrapper paymentResponseItemWrapper = (PaymentResponseItemWrapper)this.context.getBean(PaymentResponseItemWrapper.class);
                paymentResponseItemWrapper.wrapDetails(responseItem, request);
                return paymentResponseItemWrapper;
            }
            catch (PaymentException e) {
                throw BroadleafWebServicesException.build(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), null, null, e);
            }
        }
        throw BroadleafWebServicesException.build(Response.Status.NOT_FOUND.getStatusCode()).addMessage("org.broadleafcommerce.core.web.api.BroadleafWebServicesException.cartNotFound");
    }

    public OrderWrapper performCheckout(HttpServletRequest request, List<PaymentReferenceMapWrapper> mapWrappers) {
        Order cart = CartState.getCart();
        if (cart != null) {
            try {
                if (mapWrappers != null && !mapWrappers.isEmpty()) {
                    HashMap<PaymentInfo, Referenced> payments = new HashMap<PaymentInfo, Referenced>();
                    this.orderService.removePaymentsFromOrder(cart, PaymentInfoType.CREDIT_CARD);
                    for (PaymentReferenceMapWrapper mapWrapper : mapWrappers) {
                        PaymentInfo paymentInfo = mapWrapper.getPaymentInfoWrapper().unwrap(request, this.context);
                        paymentInfo.setOrder(cart);
                        Referenced referenced = mapWrapper.getReferencedWrapper().unwrap(request, this.context);
                        if (cart.getPaymentInfos() == null) {
                            cart.setPaymentInfos(new ArrayList());
                        }
                        cart.getPaymentInfos().add(paymentInfo);
                        payments.put(paymentInfo, referenced);
                    }
                    CheckoutResponse response = this.checkoutService.performCheckout(cart, payments);
                    Order order = response.getOrder();
                    OrderWrapper wrapper = (OrderWrapper)this.context.getBean(OrderWrapper.class.getName());
                    wrapper.wrapDetails(order, request);
                    return wrapper;
                }
            }
            catch (CheckoutException e) {
                cart.setStatus(OrderStatus.IN_PROCESS);
                try {
                    this.orderService.save(cart, Boolean.valueOf(false));
                }
                catch (PricingException e1) {
                    LOG.error((Object)"An unexpected error occured saving / pricing the cart.", (Throwable)e1);
                }
                throw BroadleafWebServicesException.build(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), null, null, e);
            }
        }
        throw BroadleafWebServicesException.build(Response.Status.NOT_FOUND.getStatusCode()).addMessage("org.broadleafcommerce.core.web.api.BroadleafWebServicesException.cartNotFound");
    }
}

