/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.broadleafcommerce.cms.file.service.StaticAssetService;
import org.broadleafcommerce.common.security.service.ExploitProtectionService;
import org.broadleafcommerce.core.catalog.service.CatalogService;
import org.broadleafcommerce.core.catalog.service.RelatedProductsService;
import org.broadleafcommerce.core.order.service.OrderService;
import org.broadleafcommerce.core.rating.service.RatingService;
import org.broadleafcommerce.core.web.service.SearchFacetDTOService;
import org.springframework.context.ApplicationContext;
import org.thymeleaf.Arguments;
import org.thymeleaf.spring3.context.SpringWebContext;

public class ProcessorUtils {
    protected static Map<String, Object> cachedBeans = new HashMap<String, Object>();

    public static RelatedProductsService getRelatedProductsService(Arguments arguments) {
        String key = "blRelatedProductsService";
        RelatedProductsService relatedProductsService = (RelatedProductsService)cachedBeans.get(key);
        if (relatedProductsService == null) {
            ApplicationContext appCtx = ((SpringWebContext)arguments.getContext()).getApplicationContext();
            relatedProductsService = (RelatedProductsService)appCtx.getBean(key);
            cachedBeans.put(key, relatedProductsService);
        }
        return relatedProductsService;
    }

    public static CatalogService getCatalogService(Arguments arguments) {
        String key = "blCatalogService";
        CatalogService catalogService = (CatalogService)cachedBeans.get(key);
        if (catalogService == null) {
            ApplicationContext appCtx = ((SpringWebContext)arguments.getContext()).getApplicationContext();
            catalogService = (CatalogService)appCtx.getBean(key);
            cachedBeans.put(key, catalogService);
        }
        return catalogService;
    }

    public static StaticAssetService getStaticAssetService(Arguments arguments) {
        String key = "blStaticAssetService";
        StaticAssetService staticAssetService = (StaticAssetService)cachedBeans.get(key);
        if (staticAssetService == null) {
            ApplicationContext appCtx = ((SpringWebContext)arguments.getContext()).getApplicationContext();
            staticAssetService = (StaticAssetService)appCtx.getBean(key);
            cachedBeans.put(key, staticAssetService);
        }
        return staticAssetService;
    }

    public static OrderService getOrderService(Arguments arguments) {
        String key = "blOrderService";
        OrderService orderService = (OrderService)cachedBeans.get(key);
        if (orderService == null) {
            ApplicationContext appCtx = ((SpringWebContext)arguments.getContext()).getApplicationContext();
            orderService = (OrderService)appCtx.getBean(key);
            cachedBeans.put(key, orderService);
        }
        return orderService;
    }

    public static SearchFacetDTOService getSearchFacetDTOService(Arguments arguments) {
        String key = "blSearchFacetDTOService";
        SearchFacetDTOService facetService = (SearchFacetDTOService)cachedBeans.get(key);
        if (facetService == null) {
            ApplicationContext appCtx = ((SpringWebContext)arguments.getContext()).getApplicationContext();
            facetService = (SearchFacetDTOService)appCtx.getBean(key);
            cachedBeans.put(key, facetService);
        }
        return facetService;
    }

    public static RatingService getRatingService(Arguments arguments) {
        String key = "blRatingService";
        RatingService ratingService = (RatingService)cachedBeans.get(key);
        if (ratingService == null) {
            ApplicationContext appCtx = ((SpringWebContext)arguments.getContext()).getApplicationContext();
            ratingService = (RatingService)appCtx.getBean(key);
            cachedBeans.put(key, ratingService);
        }
        return ratingService;
    }

    public static ExploitProtectionService getExploitProtectionService(Arguments arguments) {
        String key = "blExploitProtectionService";
        ExploitProtectionService exploitProtectionService = (ExploitProtectionService)cachedBeans.get(key);
        if (exploitProtectionService == null) {
            ApplicationContext appCtx = ((SpringWebContext)arguments.getContext()).getApplicationContext();
            exploitProtectionService = (ExploitProtectionService)appCtx.getBean(key);
            cachedBeans.put(key, exploitProtectionService);
        }
        return exploitProtectionService;
    }

    public static String getUrl(String baseUrl, Map<String, String[]> parameters) {
        if (baseUrl.contains("?")) {
            throw new IllegalArgumentException("baseUrl contained a ? indicating it is not a base url");
        }
        StringBuilder sb = new StringBuilder();
        sb.append(baseUrl);
        boolean atLeastOneParam = false;
        if (parameters != null && parameters.size() > 0) {
            for (Map.Entry<String, String[]> entry : parameters.entrySet()) {
                if (entry.getValue().length <= 0) continue;
                atLeastOneParam = true;
            }
        }
        if (!atLeastOneParam) {
            return sb.toString();
        }
        sb.append("?");
        for (Map.Entry<String, String[]> entry : parameters.entrySet()) {
            String key = entry.getKey();
            for (String value : entry.getValue()) {
                StringBuilder parameter = new StringBuilder();
                try {
                    parameter.append(URLEncoder.encode(key, "UTF-8"));
                    parameter.append("=");
                    parameter.append(URLEncoder.encode(value, "UTF-8"));
                    parameter.append("&");
                }
                catch (UnsupportedEncodingException e) {
                    parameter = null;
                }
                sb.append((CharSequence)parameter);
            }
        }
        String url = sb.toString();
        if (url.charAt(url.length() - 1) == '&') {
            url = url.substring(0, url.length() - 1);
        }
        return url;
    }
}

