/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.controller.order;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.beanutils.BeanPropertyValueEqualsPredicate;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.core.catalog.service.CatalogService;
import org.broadleafcommerce.core.offer.domain.OfferCode;
import org.broadleafcommerce.core.offer.service.OfferService;
import org.broadleafcommerce.core.offer.service.exception.OfferMaxUseExceededException;
import org.broadleafcommerce.core.order.domain.FulfillmentGroup;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupImpl;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.service.CartService;
import org.broadleafcommerce.core.order.service.FulfillmentGroupService;
import org.broadleafcommerce.core.order.service.exception.ItemNotFoundException;
import org.broadleafcommerce.core.pricing.service.exception.PricingException;
import org.broadleafcommerce.core.web.controller.order.CartController;
import org.broadleafcommerce.core.web.order.model.AddToCartItem;
import org.broadleafcommerce.core.web.order.model.CartOrderItem;
import org.broadleafcommerce.core.web.order.model.CartSummary;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.web.core.CustomerState;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.ui.ModelMap;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

public abstract class AbstractCartController {
    private static final Log LOG = LogFactory.getLog(CartController.class);
    @Resource(name="blCartService")
    protected final CartService cartService = null;
    @Resource(name="blCustomerState")
    protected final CustomerState customerState = null;
    @Resource(name="blCatalogService")
    protected final CatalogService catalogService = null;
    @Resource(name="blFulfillmentGroupService")
    protected final FulfillmentGroupService fulfillmentGroupService = null;
    @Resource(name="blOfferService")
    protected OfferService offerService;
    protected String cartView;
    protected boolean cartViewRedirect;
    protected String addItemView;
    protected boolean addItemViewRedirect;
    protected String removeItemView;
    protected boolean removeItemViewRedirect;

    @ModelAttribute(value="fulfillmentGroups")
    public List<FulfillmentGroup> initFulfillmentGroups() {
        ArrayList<FulfillmentGroup> fulfillmentGroups = new ArrayList<FulfillmentGroup>();
        FulfillmentGroupImpl standardGroup = new FulfillmentGroupImpl();
        FulfillmentGroupImpl expeditedGroup = new FulfillmentGroupImpl();
        standardGroup.setMethod("standard");
        expeditedGroup.setMethod("expedited");
        fulfillmentGroups.add((FulfillmentGroup)standardGroup);
        fulfillmentGroups.add((FulfillmentGroup)expeditedGroup);
        return fulfillmentGroups;
    }

    @RequestMapping(value={"/viewCart.htm"}, method={RequestMethod.GET})
    public String viewCart(ModelMap model, HttpServletRequest request) throws PricingException {
        CartOrderItem cartOrderItem;
        Order cart = this.retrieveCartOrder(request, model);
        CartSummary cartSummary = new CartSummary();
        if (cart.getOrderItems() != null) {
            for (OrderItem orderItem : cart.getOrderItems()) {
                cartOrderItem = new CartOrderItem();
                cartOrderItem.setOrderItem(orderItem);
                cartOrderItem.setQuantity(orderItem.getQuantity());
                cartSummary.getRows().add(cartOrderItem);
            }
        }
        if (cart.getFulfillmentGroups() != null && !cart.getFulfillmentGroups().isEmpty()) {
            String cartShippingMethod = ((FulfillmentGroup)cart.getFulfillmentGroups().get(0)).getMethod();
            String cartShippingService = ((FulfillmentGroup)cart.getFulfillmentGroups().get(0)).getService();
            if (cartShippingMethod != null) {
                if (cartShippingMethod.equals("standard")) {
                    cartSummary = this.createFulfillmentGroup(cartSummary, "standard", cartShippingService, cart);
                } else if (cartShippingMethod.equals("expedited")) {
                    cartSummary = this.createFulfillmentGroup(cartSummary, "expedited", cartShippingService, cart);
                }
            }
        }
        this.updateFulfillmentGroups(cartSummary, cart);
        cartSummary.setOrderDiscounts(cart.getTotalAdjustmentsValue().getAmount());
        if (cart.getOrderItems() != null) {
            cartSummary.getRows().clear();
            for (OrderItem orderItem : cart.getOrderItems()) {
                cartOrderItem = new CartOrderItem();
                cartOrderItem.setOrderItem(orderItem);
                cartOrderItem.setQuantity(orderItem.getQuantity());
                cartSummary.getRows().add(cartOrderItem);
            }
        }
        model.addAttribute("cartSummary", (Object)cartSummary);
        return this.cartViewRedirect ? "redirect:" + this.cartView : this.cartView;
    }

    @RequestMapping(value={"/addItem.htm"}, method={RequestMethod.GET, RequestMethod.POST})
    public String addItem(@RequestParam(required=false) Boolean ajax, @ModelAttribute(value="addToCartItem") AddToCartItem addToCartItem, BindingResult errors, ModelMap model, HttpServletRequest request) {
        if (ajax == null) {
            ajax = false;
        }
        Order currentCartOrder = this.retrieveCartOrder(request, model);
        ArrayList<OrderItem> orderItemsAdded = new ArrayList<OrderItem>();
        if (addToCartItem.getQuantity() > 0) {
            try {
                OrderItem orderItem = addToCartItem.getOrderId() != null ? this.cartService.addSkuToOrder(addToCartItem.getOrderId(), Long.valueOf(addToCartItem.getSkuId()), Long.valueOf(addToCartItem.getProductId()), Long.valueOf(addToCartItem.getCategoryId()), Integer.valueOf(addToCartItem.getQuantity()), addToCartItem.getAdditionalAttributes()) : this.cartService.addSkuToOrder(currentCartOrder.getId(), Long.valueOf(addToCartItem.getSkuId()), Long.valueOf(addToCartItem.getProductId()), Long.valueOf(addToCartItem.getCategoryId()), Integer.valueOf(addToCartItem.getQuantity()), addToCartItem.getAdditionalAttributes());
                orderItemsAdded.add(orderItem);
            }
            catch (PricingException e) {
                LOG.error((Object)("Unable to price the order: (" + currentCartOrder.getId() + ")"), (Throwable)e);
            }
        }
        model.addAttribute("orderItemsAdded", orderItemsAdded);
        if (!ajax.booleanValue()) {
            return this.addItemViewRedirect ? "redirect:" + this.addItemView : this.addItemView;
        }
        return "catalog/fragments/addToCartModal";
    }

    @RequestMapping(value={"/viewCart.htm"}, params={"removeItemFromCart"}, method={RequestMethod.GET, RequestMethod.POST})
    public String removeItem(@RequestParam long orderItemId, @ModelAttribute CartSummary cartSummary, ModelMap model, HttpServletRequest request) {
        Order currentCartOrder = this.retrieveCartOrder(request, model);
        try {
            currentCartOrder = this.cartService.removeItemFromOrder(currentCartOrder.getId(), Long.valueOf(orderItemId));
        }
        catch (PricingException e) {
            model.addAttribute("error", (Object)"remove");
            LOG.error((Object)("An error occurred while removing an item from the cart: (" + orderItemId + ")"), (Throwable)e);
        }
        cartSummary.setOrderDiscounts(currentCartOrder.getTotalAdjustmentsValue().getAmount());
        return this.removeItemViewRedirect ? "redirect:" + this.removeItemView : this.removeItemView;
    }

    @RequestMapping(value={"/beginCheckout.htm"}, method={RequestMethod.GET})
    public String beginCheckout(@ModelAttribute CartSummary cartSummary, BindingResult errors, @RequestParam(required=false) Boolean isStorePickup, ModelMap model, HttpServletRequest request) {
        String view = "error";
        if (!view.equals("error")) {
            model.addAttribute("isStorePickup", (Object)isStorePickup);
            if (SecurityContextHolder.getContext().getAuthentication() == null || !SecurityContextHolder.getContext().getAuthentication().isAuthenticated()) {
                model.addAttribute("nextStep", (Object)"checkout");
                return "login";
            }
        }
        return view;
    }

    @RequestMapping(value={"/viewCart.htm"}, params={"updateItemQuantity"}, method={RequestMethod.POST})
    public String updateItemQuantity(@ModelAttribute(value="cartSummary") CartSummary cartSummary, Errors errors, ModelMap model, HttpServletRequest request) throws PricingException {
        if (errors.hasErrors()) {
            model.addAttribute("cartSummary", (Object)cartSummary);
            return this.cartView;
        }
        Order currentCartOrder = this.retrieveCartOrder(request, model);
        List orderItems = currentCartOrder.getOrderItems();
        ArrayList<CartOrderItem> items = new ArrayList<CartOrderItem>(cartSummary.getRows());
        for (CartOrderItem cartOrderItem : items) {
            OrderItem orderItem = (OrderItem)CollectionUtils.find((Collection)orderItems, (Predicate)new BeanPropertyValueEqualsPredicate("id", (Object)cartOrderItem.getOrderItem().getId()));
            if (orderItem == null) continue;
            if (cartOrderItem.getQuantity() > 0) {
                orderItem.setQuantity(cartOrderItem.getQuantity());
                try {
                    this.cartService.updateItemQuantity(currentCartOrder, orderItem);
                }
                catch (ItemNotFoundException e) {
                    LOG.error((Object)("Item not found in order: (" + orderItem.getId() + ")"), (Throwable)e);
                }
                catch (PricingException e) {
                    LOG.error((Object)("Unable to price the order: (" + currentCartOrder.getId() + ")"), (Throwable)e);
                }
                continue;
            }
            try {
                this.cartService.removeItemFromOrder(currentCartOrder, orderItem);
                cartSummary.getRows().remove(cartOrderItem);
            }
            catch (Exception e) {
                LOG.error((Object)("Unable to remove item from the order: (" + currentCartOrder.getId() + ")"));
            }
        }
        if (currentCartOrder.getOrderItems() != null) {
            cartSummary.getRows().clear();
            for (OrderItem orderItem : currentCartOrder.getOrderItems()) {
                CartOrderItem cartOrderItem = new CartOrderItem();
                cartOrderItem.setOrderItem(orderItem);
                cartOrderItem.setQuantity(orderItem.getQuantity());
                cartSummary.getRows().add(cartOrderItem);
            }
        }
        cartSummary.setOrderDiscounts(currentCartOrder.getTotalAdjustmentsValue().getAmount());
        model.addAttribute("cartSummary", (Object)cartSummary);
        return this.cartViewRedirect ? "redirect:" + this.cartView : this.cartView;
    }

    @RequestMapping(params={"checkout"}, method={RequestMethod.POST})
    public String checkout(@ModelAttribute(value="cartSummary") CartSummary cartSummary, Errors errors, ModelMap model, HttpServletRequest request) throws PricingException {
        Order currentCartOrder = this.retrieveCartOrder(request, model);
        this.updateFulfillmentGroups(cartSummary, currentCartOrder);
        return "redirect:/checkout/checkout.htm";
    }

    @RequestMapping(params={"updateShipping=performUpdate"}, method={RequestMethod.POST})
    public String updateShipping(@ModelAttribute(value="cartSummary") CartSummary cartSummary, ModelMap model, HttpServletRequest request) throws PricingException {
        Order currentCartOrder = this.retrieveCartOrder(request, model);
        cartSummary = this.createFulfillmentGroup(cartSummary, cartSummary.getFulfillmentGroup().getMethod(), cartSummary.getFulfillmentGroup().getService(), currentCartOrder);
        model.addAttribute("currentCartOrder", (Object)this.updateFulfillmentGroups(cartSummary, currentCartOrder));
        model.addAttribute("cartSummary", (Object)cartSummary);
        return this.cartView;
    }

    @RequestMapping(value={"/viewCart.htm"}, params={"addPromo"}, method={RequestMethod.POST})
    public String addPromoCode(@ModelAttribute(value="cartSummary") CartSummary cartSummary, ModelMap model, HttpServletRequest request) throws PricingException {
        Order currentCartOrder = this.retrieveCartOrder(request, model);
        if (cartSummary.getPromoCode() != null) {
            OfferCode code = this.offerService.lookupOfferCodeByCode(cartSummary.getPromoCode());
            if (code != null) {
                try {
                    currentCartOrder = this.cartService.addOfferCode(currentCartOrder, code, true);
                }
                catch (OfferMaxUseExceededException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Customer exceeded max uses for offer code " + code));
                    }
                    model.addAttribute("promoError", (Object)"That offer code has been used the maximum allowed number of times.");
                }
                currentCartOrder = this.updateFulfillmentGroups(cartSummary, currentCartOrder);
            } else {
                model.addAttribute("promoError", (Object)"Invalid promo code entered.");
            }
        }
        if (currentCartOrder.getOrderItems() != null) {
            cartSummary.getRows().clear();
            for (OrderItem orderItem : currentCartOrder.getOrderItems()) {
                CartOrderItem cartOrderItem = new CartOrderItem();
                cartOrderItem.setOrderItem(orderItem);
                cartOrderItem.setQuantity(orderItem.getQuantity());
                cartSummary.getRows().add(cartOrderItem);
            }
        }
        cartSummary.setPromoCode(null);
        model.addAttribute("currentCartOrder", (Object)currentCartOrder);
        model.addAttribute("cartSummary", (Object)cartSummary);
        return "redirect:/basket/viewCart.htm";
    }

    @RequestMapping(value={"/viewCart.htm"}, params={"removePromoFromCart"}, method={RequestMethod.GET, RequestMethod.POST})
    public String removePromoCode(@RequestParam String orderOfferCode, @ModelAttribute CartSummary cartSummary, ModelMap model, HttpServletRequest request) {
        Order currentCartOrder = this.retrieveCartOrder(request, model);
        try {
            currentCartOrder = this.cartService.removeOfferCode(currentCartOrder, this.offerService.lookupOfferCodeByCode(orderOfferCode), true);
        }
        catch (PricingException e) {
            model.addAttribute("error", (Object)"remove");
            LOG.error((Object)("An error occurred while removing a promo from the cart: (" + orderOfferCode + ")"), (Throwable)e);
        }
        cartSummary.setOrderDiscounts(currentCartOrder.getTotalAdjustmentsValue().getAmount());
        return "redirect:/basket/viewCart.htm";
    }

    protected Order updateFulfillmentGroups(CartSummary cartSummary, Order currentCartOrder) throws PricingException {
        FulfillmentGroup fg = cartSummary.getFulfillmentGroup();
        if (fg.getId() == null) {
            this.cartService.removeAllFulfillmentGroupsFromOrder(currentCartOrder, false);
            for (CartOrderItem item : cartSummary.getRows()) {
                item.getOrderItem().setOrder(currentCartOrder);
                fg = this.cartService.addItemToFulfillmentGroup(item.getOrderItem(), fg, item.getQuantity(), false);
            }
            cartSummary.setFulfillmentGroup(fg);
        }
        return this.cartService.save(currentCartOrder, Boolean.valueOf(true));
    }

    protected CartSummary createFulfillmentGroup(CartSummary cartSummary, String shippingMethod, String service, Order cart) {
        FulfillmentGroupImpl fulfillmentGroup = new FulfillmentGroupImpl();
        fulfillmentGroup.setMethod(shippingMethod);
        fulfillmentGroup.setService(service);
        fulfillmentGroup.setOrder(cart);
        cartSummary.setFulfillmentGroup((FulfillmentGroup)fulfillmentGroup);
        return cartSummary;
    }

    protected Order retrieveCartOrder(HttpServletRequest request, ModelMap model) {
        Customer currentCustomer = this.customerState.getCustomer(request);
        Order currentCartOrder = null;
        if (currentCustomer != null && (currentCartOrder = this.cartService.findCartForCustomer(currentCustomer)) == null) {
            currentCartOrder = this.cartService.createNewCartForCustomer(currentCustomer);
        }
        model.addAttribute("currentCartOrder", currentCartOrder);
        return currentCartOrder;
    }

    public void setCartView(String cartView) {
        this.cartView = cartView;
    }

    public void setAddItemView(String addItemView) {
        this.addItemView = addItemView;
    }

    public void setCartViewRedirect(boolean cartViewRedirect) {
        this.cartViewRedirect = cartViewRedirect;
    }

    public void setAddItemViewRedirect(boolean addItemViewRedirect) {
        this.addItemViewRedirect = addItemViewRedirect;
    }

    public void setRemoveItemView(String removeItemView) {
        this.removeItemView = removeItemView;
    }

    public void setRemoveItemViewRedirect(boolean removeItemViewRedirect) {
        this.removeItemViewRedirect = removeItemViewRedirect;
    }
}

