/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.catalog;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.broadleafcommerce.common.time.SystemTime;
import org.broadleafcommerce.core.catalog.domain.Category;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.catalog.service.CatalogService;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class SimpleCatalogController
extends AbstractController {
    private CatalogService catalogService;
    private String defaultCategoryView;
    private String defaultProductView;
    private Long rootCategoryId;
    private String categoryTemplatePrefix;

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        this.addCategoryToModel(request, model);
        boolean productFound = this.addProductsToModel(request, model);
        String view = this.defaultCategoryView;
        if (productFound) {
            view = this.defaultProductView;
        } else {
            Category currentCategory = (Category)model.get("currentCategory");
            if (currentCategory == null) {
                view = this.defaultCategoryView;
            } else {
                if (currentCategory.getUrl() != null) {
                    return new ModelAndView("redirect:" + currentCategory.getUrl().replace("index.jhtml", ""));
                }
                view = currentCategory.getDisplayTemplate() != null ? this.categoryTemplatePrefix + currentCategory.getDisplayTemplate() : this.defaultCategoryView;
            }
        }
        return new ModelAndView(view, model);
    }

    protected void addCategoryToModel(HttpServletRequest request, Map<String, Object> model) {
        Category rootCategory = null;
        if (this.getRootCategoryId() != null) {
            rootCategory = this.catalogService.findCategoryById(this.getRootCategoryId());
        }
        if (rootCategory == null) {
            throw new IllegalStateException("Catalog Controller configured incorrectly - rootId category not found: " + this.rootCategoryId);
        }
        String categoryId = request.getParameter("categoryId");
        Category category = null;
        if (categoryId != null) {
            category = this.catalogService.findCategoryById(new Long(categoryId));
        }
        if (category == null) {
            model.put("categoryError", true);
        }
        model.put("rootCategory", rootCategory);
        if (category != null) {
            model.put("currentCategory", category);
        } else {
            model.put("currentCategory", rootCategory);
        }
    }

    protected int findProductPositionInList(Product product, List<Product> products) {
        for (int i = 0; i < products.size(); ++i) {
            Product currentProduct = products.get(i);
            if (!product.getId().equals(currentProduct.getId())) continue;
            return i + 1;
        }
        return 0;
    }

    protected List<Category> buildCategoryList(Category rootCategory, Category currentCategory, String url) {
        List categoryIdList = (List)this.catalogService.getChildCategoryURLMapByCategoryId(rootCategory.getId()).get(url);
        ArrayList<Category> categoryList = null;
        if (categoryIdList != null) {
            categoryList = new ArrayList<Category>(categoryIdList.size());
            for (Long id : categoryIdList) {
                categoryList.add(this.catalogService.findCategoryById(id));
            }
        }
        if (categoryList == null) {
            categoryList = new ArrayList();
            while (currentCategory != null) {
                categoryList.add(currentCategory);
                currentCategory = currentCategory.getDefaultParentCategory();
            }
            Collections.reverse(categoryList);
        }
        return categoryList;
    }

    protected boolean validateProductAndAddToModel(Product product, Map<String, Object> model) {
        Category currentCategory = (Category)model.get("currentCategory");
        Category rootCategory = (Category)model.get("rootCategory");
        int productPosition = 0;
        List productList = this.catalogService.findActiveProductsByCategory(currentCategory, SystemTime.asDate());
        if (productList != null) {
            model.put("currentProducts", productList);
        }
        if ((productPosition = this.findProductPositionInList(product, productList)) == 0 && (currentCategory = product.getDefaultCategory()).isActive()) {
            String url;
            List<Category> categoryList;
            model.put("currentCategory", currentCategory);
            productList = this.catalogService.findActiveProductsByCategory(currentCategory, SystemTime.asDate());
            if (productList != null) {
                model.put("currentProducts", productList);
            }
            if ((categoryList = this.buildCategoryList(rootCategory, currentCategory, url = currentCategory.getGeneratedUrl())) != null) {
                productPosition = this.findProductPositionInList(product, productList);
            }
        }
        if (productPosition != 0) {
            model.put("productError", false);
            model.put("currentProduct", product);
            model.put("productPosition", productPosition);
            if (productPosition != 1) {
                model.put("previousProduct", productList.get(productPosition - 2));
            }
            if (productPosition < productList.size()) {
                model.put("nextProduct", productList.get(productPosition));
            }
            model.put("totalProducts", productList.size());
        } else {
            model.put("productError", true);
        }
        return productPosition != 0;
    }

    protected boolean addProductsToModel(HttpServletRequest request, Map<String, Object> model) {
        boolean productFound = false;
        String productId = request.getParameter("productId");
        Product product = null;
        try {
            product = this.catalogService.findProductById(new Long(productId));
        }
        catch (Exception e) {
            // empty catch block
        }
        if (product != null && product.isActive()) {
            productFound = this.validateProductAndAddToModel(product, model);
        } else {
            Category currentCategory = (Category)model.get("currentCategory");
            List productList = this.catalogService.findActiveProductsByCategory(currentCategory, SystemTime.asDate());
            model.put("currentProducts", productList);
        }
        return productFound;
    }

    public Long getRootCategoryId() {
        return this.rootCategoryId;
    }

    public void setRootCategoryId(Long rootCategoryId) {
        this.rootCategoryId = rootCategoryId;
    }

    public CatalogService getCatalogService() {
        return this.catalogService;
    }

    public void setCatalogService(CatalogService catalogService) {
        this.catalogService = catalogService;
    }

    public String getDefaultCategoryView() {
        return this.defaultCategoryView;
    }

    public void setDefaultCategoryView(String defaultCategoryView) {
        this.defaultCategoryView = defaultCategoryView;
    }

    public String getDefaultProductView() {
        return this.defaultProductView;
    }

    public void setDefaultProductView(String defaultProductView) {
        this.defaultProductView = defaultProductView;
    }

    public String getCategoryTemplatePrefix() {
        return this.categoryTemplatePrefix;
    }

    public void setCategoryTemplatePrefix(String categoryTemplatePrefix) {
        this.categoryTemplatePrefix = categoryTemplatePrefix;
    }
}

