/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.layout.tags;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.servlet.jsp.JspException;
import org.apache.commons.beanutils.BeanComparator;
import org.broadleafcommerce.core.marketing.domain.TargetContent;
import org.broadleafcommerce.core.web.layout.tags.ContentDisplayTag;

public class RandomContentDisplayTag
extends ContentDisplayTag {
    private static final long serialVersionUID = 1L;
    private int numItems;

    public int getNumItems() {
        return this.numItems;
    }

    public void setNumItems(int numItems) {
        this.numItems = numItems;
    }

    @Override
    public int doStartTag() throws JspException {
        super.doStartTag();
        List targetContents = (List)this.pageContext.getAttribute(this.getVarList());
        List<TargetContent> randomizedContents = this.randomizeSublist(targetContents, targetContents.size());
        Collections.sort(randomizedContents, new BeanComparator("priority"));
        this.pageContext.setAttribute(this.getVarList(), randomizedContents);
        this.pageContext.setAttribute(this.getVarFirstItem(), randomizedContents.size() > 0 ? randomizedContents.get(0) : null);
        return 6;
    }

    public List<TargetContent> randomizeSublist(List<TargetContent> list, int index) {
        if (index > 1) {
            int size = index;
            Random random = new Random();
            for (int i = 0; i <= size; --size, ++i) {
                int j = random.nextInt(size);
                TargetContent obj = list.get(i);
                list.set(i, list.get(i + j));
                list.set(i + j, obj);
            }
        }
        return list;
    }
}

