/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web;

import java.util.List;
import org.broadleafcommerce.core.web.AjaxFormCommandObject;

public class PaginationCommandObject
extends AjaxFormCommandObject {
    private int pageNumber = 0;
    private int pageSize = 1;
    private int listSize = -1;
    private List<?> displayList = null;
    private List<?> fullList = null;
    private String dataSource;
    private String containerId;
    private String previousLinkText = "&lt;- Previous";
    private String nextLinkText = "Next -&gt;";

    public String getPreviousLinkText() {
        return this.previousLinkText;
    }

    public void setPreviousLinkText(String previousLinkText) {
        this.previousLinkText = previousLinkText;
    }

    public String getNextLinkText() {
        return this.nextLinkText;
    }

    public void setNextLinkText(String nextLinkText) {
        this.nextLinkText = nextLinkText;
    }

    public String getContainerId() {
        return this.containerId;
    }

    public void setContainerId(String containerId) {
        this.containerId = containerId;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    public void setFullList(List<?> fullList) {
        this.fullList = fullList;
    }

    public List<?> getDisplayList() {
        if (this.displayList == null && this.fullList != null) {
            return this.fullList.subList(this.getStartIndex(), this.getEndIndex());
        }
        return this.displayList;
    }

    public void setDisplayList(List<?> displayList) {
        this.displayList = displayList;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(int pageNumber) {
        this.pageNumber = pageNumber;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getStartIndex() {
        int result = this.getPageNumber() * this.getPageSize();
        if (this.getListSize() >= 0 && result >= this.getListSize()) {
            result = this.getListSize() - this.getPageSize();
        }
        return Math.max(0, result);
    }

    public int getEndIndex() {
        if (this.getListSize() < 0) {
            return this.getStartIndex() + this.getPageSize();
        }
        return Math.min(this.getListSize(), this.getStartIndex() + this.getPageSize());
    }

    public int getListSize() {
        if (this.listSize == -1 && this.fullList != null) {
            return this.fullList.size();
        }
        return this.listSize;
    }

    public void setListSize(int listSize) {
        this.listSize = listSize;
    }

    public boolean isShowPrevious() {
        return this.getPageNumber() > 0;
    }

    public boolean isShowNext() {
        return (this.getPageNumber() + 1) * this.getPageSize() < this.getListSize();
    }
}

