-- This file is used to auto-populate the embedded database for the demo. Hibernate will look for a file called
-- import.sql in the root of the classpath whenever the hibernate.hbm2ddl.auto property is set to create or create-drop.

INSERT INTO BLC_ADMIN_USER (ADMIN_USER_ID, EMAIL, LOGIN, NAME, PASSWORD) VALUES (1,'admin@yourdomain.com','admin','Administrator','blc_admin');

INSERT INTO BLC_ADMIN_ROLE (ADMIN_ROLE_ID, DESCRIPTION, NAME) VALUES (1,'Admin Master Access','ROLE_ADMIN');

INSERT INTO BLC_ADMIN_PERMISSION (ADMIN_PERMISSION_ID, DESCRIPTION, NAME) VALUES (1,'Default Permission','DEFAULT_PERMISSION');

INSERT INTO BLC_ADMIN_ROLE_PERMISSION_XREF (ADMIN_ROLE_ID, ADMIN_PERMISSION_ID) VALUES (1,1);

INSERT INTO BLC_ADMIN_USER_ROLE_XREF (ADMIN_ROLE_ID, ADMIN_USER_ID) VALUES (1,1);

INSERT INTO BLC_CODE_TYPES (CODE_ID, CODE_TYPE, CODE_DESC, CODE_KEY, MODIFIABLE) VALUES (1,'CATEGORY_MEDIA','Large Category Media','large','N');
INSERT INTO BLC_CODE_TYPES (CODE_ID, CODE_TYPE, CODE_DESC, CODE_KEY, MODIFIABLE) VALUES (2,'CATEGORY_MEDIA','Small Category Media','small','N');
INSERT INTO BLC_CODE_TYPES (CODE_ID, CODE_TYPE, CODE_DESC, CODE_KEY, MODIFIABLE) VALUES (3,'PRODUCT_MEDIA','Large Product Media','large','N');
INSERT INTO BLC_CODE_TYPES (CODE_ID, CODE_TYPE, CODE_DESC, CODE_KEY, MODIFIABLE) VALUES (4,'PRODUCT_MEDIA','Small Product Media','small','N');

INSERT INTO BLC_CATEGORY (CATEGORY_ID,DESCRIPTION,DISPLAY_TEMPLATE,LONG_DESCRIPTION,NAME,URL,URL_KEY,DEFAULT_PARENT_CATEGORY_ID,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (1,'Store',NULL,NULL,'Store',NULL,'store',NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_CATEGORY (CATEGORY_ID,DESCRIPTION,DISPLAY_TEMPLATE,LONG_DESCRIPTION,NAME,URL,URL_KEY,DEFAULT_PARENT_CATEGORY_ID,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (1000,'Coffee Products',NULL,NULL,'Coffee Products',NULL,'coffee',1,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_CATEGORY (CATEGORY_ID,DESCRIPTION,DISPLAY_TEMPLATE,LONG_DESCRIPTION,NAME,URL,URL_KEY,DEFAULT_PARENT_CATEGORY_ID,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (1001,'Yuban',NULL,NULL,'Yuban',NULL,'yuban',1000,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_CATEGORY (CATEGORY_ID,DESCRIPTION,DISPLAY_TEMPLATE,LONG_DESCRIPTION,NAME,URL,URL_KEY,DEFAULT_PARENT_CATEGORY_ID,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (1002,'Eight O''Clock',NULL,NULL,'Eight O''Clock',NULL,'eight',1000,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_CATEGORY (CATEGORY_ID,DESCRIPTION,DISPLAY_TEMPLATE,LONG_DESCRIPTION,NAME,URL,URL_KEY,DEFAULT_PARENT_CATEGORY_ID,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (1003,'Seattle''s Best',NULL,NULL,'Seattle''s Best',NULL,'seattle',1000,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_CATEGORY (CATEGORY_ID,DESCRIPTION,DISPLAY_TEMPLATE,LONG_DESCRIPTION,NAME,URL,URL_KEY,DEFAULT_PARENT_CATEGORY_ID,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (1004,'Millstone',NULL,NULL,'Millstone',NULL,'millstone',1000,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_CATEGORY (CATEGORY_ID,DESCRIPTION,DISPLAY_TEMPLATE,LONG_DESCRIPTION,NAME,URL,URL_KEY,DEFAULT_PARENT_CATEGORY_ID,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (1005,'Chock Full o'' Nuts',NULL,NULL,'Chock Full o'' Nuts',NULL,'chock',1000,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_CATEGORY (CATEGORY_ID,DESCRIPTION,DISPLAY_TEMPLATE,LONG_DESCRIPTION,NAME,URL,URL_KEY,DEFAULT_PARENT_CATEGORY_ID,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (1006,'Maxwell House',NULL,NULL,'Maxwell House',NULL,'maxwell',1000,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_CATEGORY (CATEGORY_ID,DESCRIPTION,DISPLAY_TEMPLATE,LONG_DESCRIPTION,NAME,URL,URL_KEY,DEFAULT_PARENT_CATEGORY_ID,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (1007,'Folgers',NULL,NULL,'Folgers',NULL,'folgers',1000,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_CATEGORY (CATEGORY_ID,DESCRIPTION,DISPLAY_TEMPLATE,LONG_DESCRIPTION,NAME,URL,URL_KEY,DEFAULT_PARENT_CATEGORY_ID,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (1008,'Starbucks',NULL,NULL,'Starbucks',NULL,'starbucks',1000,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_CATEGORY (CATEGORY_ID,DESCRIPTION,DISPLAY_TEMPLATE,LONG_DESCRIPTION,NAME,URL,URL_KEY,DEFAULT_PARENT_CATEGORY_ID,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (2000,'Coffee Equipment',NULL,NULL,'Coffee Equipment',NULL,'equipment',1,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_CATEGORY (CATEGORY_ID,DESCRIPTION,DISPLAY_TEMPLATE,LONG_DESCRIPTION,NAME,URL,URL_KEY,DEFAULT_PARENT_CATEGORY_ID,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (2001,'Espresso Machines',NULL,NULL,'Espresso Machines',NULL,'espresso',2000,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_CATEGORY (CATEGORY_ID,DESCRIPTION,DISPLAY_TEMPLATE,LONG_DESCRIPTION,NAME,URL,URL_KEY,DEFAULT_PARENT_CATEGORY_ID,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (2002,'Coffee Brewers and Brewing Equipment',NULL,NULL,'Coffee Brewers and Brewing Equipment',NULL,'brewers',2000,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_CATEGORY (CATEGORY_ID,DESCRIPTION,DISPLAY_TEMPLATE,LONG_DESCRIPTION,NAME,URL,URL_KEY,DEFAULT_PARENT_CATEGORY_ID,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (2003,'Timers and Thermostats',NULL,NULL,'Timers and Thermostats',NULL,'timers_thermostats',2000,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_CATEGORY (CATEGORY_ID,DESCRIPTION,DISPLAY_TEMPLATE,LONG_DESCRIPTION,NAME,URL,URL_KEY,DEFAULT_PARENT_CATEGORY_ID,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (2004,'Coffee Roasters',NULL,NULL,'Coffee Roasters',NULL,'roasters',2000,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_CATEGORY (CATEGORY_ID,DESCRIPTION,DISPLAY_TEMPLATE,LONG_DESCRIPTION,NAME,URL,URL_KEY,DEFAULT_PARENT_CATEGORY_ID,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (2005,'Cups & Spoons',NULL,NULL,'Cups & Spoons',NULL,'cups',2000,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_CATEGORY (CATEGORY_ID,DESCRIPTION,DISPLAY_TEMPLATE,LONG_DESCRIPTION,NAME,URL,URL_KEY,DEFAULT_PARENT_CATEGORY_ID,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (2006,'Thermal Dispensers',NULL,NULL,'Thermal Dispensers',NULL,'dispensers',2000,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_CATEGORY (CATEGORY_ID,DESCRIPTION,DISPLAY_TEMPLATE,LONG_DESCRIPTION,NAME,URL,URL_KEY,DEFAULT_PARENT_CATEGORY_ID,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (2007,'Grinders',NULL,NULL,'Grinders',NULL,'grinders',2000,'2020-01-01',CURRENT_DATE);

INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (1,1001,'Original',NULL,0,1,NULL,NULL,NULL,'Yuban',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (2,1001,'Dark Roast',NULL,1,1,NULL,NULL,NULL,'Yuban',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (3,1001,'Decaffeinated',NULL,0,1,NULL,NULL,NULL,'Yuban',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (4,1002,'Original',NULL,1,1,NULL,NULL,NULL,'Eight O''Clock',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (5,1002,'50% Decaf',NULL,0,1,NULL,NULL,NULL,'Eight O''Clock',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (6,1002,'Mocha',NULL,1,1,NULL,NULL,NULL,'Eight O''Clock',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (7,1002,'Bokar',NULL,0,1,NULL,NULL,NULL,'Eight O''Clock',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (8,1002,'Decaf Original',NULL,1,1,NULL,NULL,NULL,'Eight O''Clock',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (9,1002,'French Vanilla',NULL,0,1,NULL,NULL,NULL,'Eight O''Clock',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (10,1002,'French Roast',NULL,1,1,NULL,NULL,NULL,'Eight O''Clock',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (11,1002,'100% Columbian',NULL,0,1,NULL,NULL,NULL,'Eight O''Clock',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (12,1002,'Hazelnut',NULL,0,1,NULL,NULL,NULL,'Eight O''Clock',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (13,1002,'Dark Italian Roast',NULL,0,1,NULL,NULL,NULL,'Eight O''Clock',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (14,1002,'Decaf 100% Columbian',NULL,1,1,NULL,NULL,NULL,'Eight O''Clock',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (15,1003,'BeachHouse Blend',NULL,0,1,NULL,NULL,NULL,'Seattle''s Best',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (16,1003,'Best Blend',NULL,0,1,NULL,NULL,NULL,'Seattle''s Best',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (17,1003,'Henry''s Blend',NULL,1,1,NULL,NULL,NULL,'Seattle''s Best',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (18,1003,'6th Avenue Bistro Blend',NULL,1,1,NULL,NULL,NULL,'Seattle''s Best',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (19,1003,'Almond Roca',NULL,0,1,NULL,NULL,NULL,'Seattle''s Best',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (20,1003,'Cinnabon',NULL,0,1,NULL,NULL,NULL,'Seattle''s Best',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (21,1003,'Colombian',NULL,0,1,NULL,NULL,NULL,'Seattle''s Best',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (22,1003,'Creme Brulee',NULL,0,1,NULL,NULL,NULL,'Seattle''s Best',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (23,1003,'Organic Fair Trade - French Roast',NULL,1,1,NULL,NULL,NULL,'Seattle''s Best',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (24,1003,'Hazelnut',NULL,0,1,NULL,NULL,NULL,'Seattle''s Best',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (25,1003,'Breakfast Blend',NULL,1,1,NULL,NULL,NULL,'Seattle''s Best',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (26,1003,'Organic House Blend',NULL,1,1,NULL,NULL,NULL,'Seattle''s Best',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (27,1003,'Organic Sumatra',NULL,1,1,NULL,NULL,NULL,'Seattle''s Best',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (28,1003,'Portside',NULL,0,1,NULL,NULL,NULL,'Seattle''s Best',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (29,1003,'Post Alley Blend',NULL,0,1,NULL,NULL,NULL,'Seattle''s Best',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (30,1003,'Saturday''s Blend',NULL,0,1,NULL,NULL,NULL,'Seattle''s Best',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (31,1003,'Vanilla Bean',NULL,0,1,NULL,NULL,NULL,'Seattle''s Best',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (32,1004,'Breakfast Blend - Light Roast',NULL,1,1,NULL,NULL,NULL,'Millstone',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (33,1004,'100% Colombian - Medium Roast',NULL,1,1,NULL,NULL,NULL,'Millstone',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (34,1004,'Bed & Breakfast Blend - Medium Dark Roast',NULL,1,1,NULL,NULL,NULL,'Millstone',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (35,1004,'Espresso',NULL,0,1,NULL,NULL,NULL,'Millstone',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (36,1004,'Organic Deep Peruvian Forest',NULL,1,1,NULL,NULL,NULL,'Millstone',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (37,1004,'Organic Mayan Black Oynx',NULL,0,1,NULL,NULL,NULL,'Millstone',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (38,1004,'Organic Mountain Fair Trade Certified',NULL,1,1,NULL,NULL,NULL,'Millstone',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (39,1004,'Organic Nicaraguan Mountain Twilight',NULL,0,1,NULL,NULL,NULL,'Millstone',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (40,1004,'Organic Rainforest Reserve',NULL,1,1,NULL,NULL,NULL,'Millstone',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (41,1004,'Caramel Trufle',NULL,0,1,NULL,NULL,NULL,'Millstone',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (42,1004,'Chocolate Velvet',NULL,1,1,NULL,NULL,NULL,'Millstone',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (43,1004,'Cinnamon Hazelnut',NULL,0,1,NULL,NULL,NULL,'Millstone',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (44,1004,'Decaf Caramel Truffle',NULL,1,1,NULL,NULL,NULL,'Millstone',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (45,1004,'Decaf Chocolate Velvet',NULL,1,1,NULL,NULL,NULL,'Millstone',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (46,1004,'Decaf French Vanilla',NULL,0,1,NULL,NULL,NULL,'Millstone',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (47,1004,'Decaf Hazelnut Cream Whole',NULL,1,1,NULL,NULL,NULL,'Millstone',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (48,1004,'French Vanilla',NULL,0,1,NULL,NULL,NULL,'Millstone',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (49,1004,'Hazelnut Cream Whole',NULL,1,1,NULL,NULL,NULL,'Millstone',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (50,1004,'Hazelnut Cream Ground',NULL,1,1,NULL,NULL,NULL,'Millstone',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (51,1004,'Decaf Hazelnut Cream Ground',NULL,1,1,NULL,NULL,NULL,'Millstone',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (52,1004,'Raspberries ''n Cream',NULL,0,1,NULL,NULL,NULL,'Millstone',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (53,1004,'Swiss Chocolate Almond',NULL,1,1,NULL,NULL,NULL,'Millstone',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (54,1004,'Vanilla Nut Cream',NULL,0,1,NULL,NULL,NULL,'Millstone',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (55,1005,'100% Columbian',NULL,1,1,NULL,NULL,NULL,'Chock Full o'' Nuts',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (56,1005,'Columbian Decaf',NULL,0,1,NULL,NULL,NULL,'Chock Full o'' Nuts',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (57,1005,'City Blend',NULL,1,1,NULL,NULL,NULL,'Chock Full o'' Nuts',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (58,1005,'Rich French Roast',NULL,0,1,NULL,NULL,NULL,'Chock Full o'' Nuts',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (59,1005,'French Roast Decaf',NULL,0,1,NULL,NULL,NULL,'Chock Full o'' Nuts',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (60,1005,'New York Roast',NULL,1,1,NULL,NULL,NULL,'Chock Full o'' Nuts',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (61,1005,'Original',NULL,1,1,NULL,NULL,NULL,'Chock Full o'' Nuts',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (62,1005,'Original Decaf',NULL,1,1,NULL,NULL,NULL,'Chock Full o'' Nuts',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (63,1005,'Hazelnut',NULL,1,1,NULL,NULL,NULL,'Chock Full o'' Nuts',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (64,1005,'Brick',NULL,0,1,NULL,NULL,NULL,'Chock Full o'' Nuts',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (65,1005,'SoHo Morning Roast',NULL,1,1,NULL,NULL,NULL,'Chock Full o'' Nuts',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (66,1005,'Upper West Side European Roast',NULL,0,1,NULL,NULL,NULL,'Chock Full o'' Nuts',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (67,1005,'Upper West Side European Roast Decaf',NULL,0,1,NULL,NULL,NULL,'Chock Full o'' Nuts',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (68,1005,'Midtown French',NULL,1,1,NULL,NULL,NULL,'Chock Full o'' Nuts',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (69,1005,'Greenwich Village',NULL,0,1,NULL,NULL,NULL,'Chock Full o'' Nuts',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (70,1006,'Dark Roast',NULL,1,1,NULL,NULL,NULL,'Maxwell House',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (71,1006,'Columbian Supreme',NULL,0,1,NULL,NULL,NULL,'Maxwell House',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (72,1006,'French Roast',NULL,1,1,NULL,NULL,NULL,'Maxwell House',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (73,1006,'South Pacific Blend',NULL,0,1,NULL,NULL,NULL,'Maxwell House',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (74,1006,'Slow Roast',NULL,1,1,NULL,NULL,NULL,'Maxwell House',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (75,1006,'Original',NULL,0,1,NULL,NULL,NULL,'Maxwell House',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (76,1006,'Lite',NULL,1,1,NULL,NULL,NULL,'Maxwell House',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (77,1006,'Master Blend',NULL,0,1,NULL,NULL,NULL,'Maxwell House',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (78,1006,'Breakfast Blend',NULL,1,1,NULL,NULL,NULL,'Maxwell House',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (79,1006,'Original Decaf',NULL,0,1,NULL,NULL,NULL,'Maxwell House',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (80,1006,'French Roast Decaf',NULL,1,1,NULL,NULL,NULL,'Maxwell House',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (81,1006,'Master Blend Decaf',NULL,0,1,NULL,NULL,NULL,'Maxwell House',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (82,1006,'Vanilla Flavored',NULL,1,1,NULL,NULL,NULL,'Maxwell House',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (83,1006,'Hazelnut Flavored',NULL,0,1,NULL,NULL,NULL,'Maxwell House',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (84,1006,'Original Instant',NULL,1,1,NULL,NULL,NULL,'Maxwell House',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (85,1006,'Decaf Instant',NULL,0,1,NULL,NULL,NULL,'Maxwell House',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (86,1006,'Sanka Instant Decaf',NULL,1,1,NULL,NULL,NULL,'Maxwell House',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (87,1006,'Coffee Singles',NULL,0,1,NULL,NULL,NULL,'Maxwell House',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (88,1007,'Classic Roast',NULL,0,1,NULL,NULL,NULL,'Folgers',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (89,1007,'Special Roast',NULL,0,1,NULL,NULL,NULL,'Folgers',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (90,1007,'Classic Roast Decaf',NULL,1,1,NULL,NULL,NULL,'Folgers',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (91,1007,'Bistro Blend',NULL,1,1,NULL,NULL,NULL,'Folgers',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (92,1007,'Hazelnut Creme',NULL,0,1,NULL,NULL,NULL,'Folgers',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (93,1007,'Vanilla Biscotti',NULL,1,1,NULL,NULL,NULL,'Folgers',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (94,1007,'Chocolate Truffle',NULL,0,1,NULL,NULL,NULL,'Folgers',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (95,1007,'Creme Brulee',NULL,1,1,NULL,NULL,NULL,'Folgers',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (96,1007,'Caramel Drizzle',NULL,0,1,NULL,NULL,NULL,'Folgers',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (97,1007,'Morning Cafe',NULL,1,1,NULL,NULL,NULL,'Folgers',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (98,1007,'Lively Columbian',NULL,0,1,NULL,NULL,NULL,'Folgers',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (99,1007,'Brazilian Blend',NULL,0,1,NULL,NULL,NULL,'Folgers',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (100,1007,'Bold Java',NULL,0,1,NULL,NULL,NULL,'Folgers',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (101,1008,'Arabian Mocha Sanani',NULL,1,1,NULL,NULL,NULL,'Starbucks',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (102,1008,'Brazil Ipanema Bourbon',NULL,1,1,NULL,NULL,NULL,'Starbucks',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (103,1008,'Bella Vista F.W. Tres Rios Costa Rica',NULL,1,1,NULL,NULL,NULL,'Starbucks',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (104,1008,'Breakfast Blend',NULL,0,1,NULL,NULL,NULL,'Starbucks',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (105,1008,'Guatemala Antigua',NULL,1,1,NULL,NULL,NULL,'Starbucks',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (106,1008,'Guatemala Casi Cielo',NULL,0,1,NULL,NULL,NULL,'Starbucks',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (107,1008,'House Blend',NULL,0,1,NULL,NULL,NULL,'Starbucks',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (108,1008,'Decaf House Blend',NULL,1,1,NULL,NULL,NULL,'Starbucks',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (109,1008,'Organic Shade Grown Mexico',NULL,1,1,NULL,NULL,NULL,'Starbucks',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (110,1008,'Columbian Narino Supremo',NULL,1,1,NULL,NULL,NULL,'Starbucks',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (111,1008,'Kenya',NULL,0,1,NULL,NULL,NULL,'Starbucks',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (112,1008,'Ethiopia Sidamo',NULL,1,1,NULL,NULL,NULL,'Starbucks',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (113,1008,'Sumatra',NULL,0,1,NULL,NULL,NULL,'Starbucks',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (114,1008,'Komodo Dragon Blend',NULL,1,1,NULL,NULL,NULL,'Starbucks',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (115,1008,'Decaf Sumatra',NULL,0,1,NULL,NULL,NULL,'Starbucks',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (116,1008,'Cafe Estima Blend',NULL,1,1,NULL,NULL,NULL,'Starbucks',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (117,1008,'Caffe Verona',NULL,0,1,NULL,NULL,NULL,'Starbucks',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (118,1008,'Caffe Verona Decaf',NULL,1,1,NULL,NULL,NULL,'Starbucks',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (119,1008,'Gold Coast Blend',NULL,1,1,NULL,NULL,NULL,'Starbucks',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (120,1008,'Organic Serena Blend',NULL,0,1,NULL,NULL,NULL,'Starbucks',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (121,1008,'Espresso Roast',NULL,1,1,NULL,NULL,NULL,'Starbucks',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (122,1008,'Decaf Espresso Roast',NULL,0,1,NULL,NULL,NULL,'Starbucks',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (123,1008,'French Roast',NULL,1,1,NULL,NULL,NULL,'Starbucks','1 lb',NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (124,1008,'Italian Roast',NULL,1,1,NULL,NULL,NULL,'Starbucks',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (125,1008,'Pike Place Roast',NULL,0,1,NULL,NULL,NULL,'Starbucks',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (126,1008,'Decaf Pike Place Roast',NULL,0,1,NULL,NULL,NULL,'Starbucks',NULL,NULL,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (127,2002,'DeLonghi - 10 Cup Drip Coffee Maker','Seamless brushed aluminum body durable and stylish, it beautifully complements any kitchen decor. Permanent gold-tone filter durable and long-lasting, the gold-tone filter is specially designed to keep even the finest grounds out of your coffee. Ergonomic handle for comfortable use and easy handling.',0,1,15.59,7.4,14.13,'DeLonghi','DCM900',6,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (128,2002,'DeLonghi - 14 Cup Drip Coffee Maker','24-hour programmable timer is convenient and easy-to-use. Just set the timer the night before, and wake up to the aroma of fresh brewed coffee. Internal water level indicator lets you know how much water is in the tank. Permanent gold-tone filter durable and long lasting, the gold-tone filter is specially designed to keep even the finest grounds out of your coffee.',0,1,8.5,9.75,12.71,'DeLonghi','DC514T',8.2,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (129,2002,'DeLonghi - 12-Cup Drip Coffee Maker w/ Frontal Access','24-hour programmable digital timer with 2 hour automatic shut-off. Water level indicator lets you know when the unit needs refilling. Permanent gold-tone filter durable and long lasting, the gold-tone filter is specially designed to keep even the finest grounds out of your coffee.',1,1,9.25,10.43,12.32,'DeLonghi','DCF212T',7.1,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (130,2002,'Capresso - Coffee Team Therm Grind/Brew Coffeemaker Kit','Perfect for the brewed coffee connoisseur, the programmable 10-cup capacity Capresso CoffeeTEAM is the only combination machine with a conical burr grinder and a stainless steel thermal carafe. Just pour in the beans, program the time and the amount of coffee to be ground and the brewer does the rest. High quality heating elements assure ideal brewing temperatures of over 200F and approximately 180F in the carafe directly after brewing.',1,1,16,12,11,'Capresso','B108',10,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (131,2002,'Capresso - MT500 PLUS Coffeemaker Kit','It''s easy to see why this programmable 10-cup coffee maker was named "2008 Consumers Digest Best Buy". With its beautiful high-gloss alloy body and stainless steel thermal carafe, the Capresso MT500 keeps coffee hot and fresh for up to 4 hours.',0,1,14,10,10,'Capresso','B109',7,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (132,2002,'Capresso - CoffeeTEC','Brews 10 5-ounce cups of coffee directly into a stainless-steel vacuum carafe. Virtually unbreakable carafe keeps coffee hot 4 hours without a warming plate. Programmable digital clock/timer for "wake-up" coffee; pour a cup midbrew via 20-second brew-pause. Permanent GoldTone filter eliminates messy paper filters; push-button, swing-out filter holder.',1,1,11,11,14,'Capresso','471',8,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (133,2002,'Bodum - Cafe Solo - Filtre Belgique','The design of the Filter Belgique is itself done with a "silent attitude", but the product incorporates a high content of design details which make it simple to use and nice to look at. In this way, it stands out from most of the same type of mass-market products. The Filter Belgique design came from the same honest work that so many scarcely noticed everyday essentials emerge from.',1,1,4.5,3.8,7.4,'Bodum','K10461-01',1,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (134,2001,'DeLonghi - Perfecta Fully Automatic Expresso Machine','Easy to use control panel with digital programmable menu settings allow you to adjust start time, auto shut and off and clock. You can adjust temperature of the coffee and water hardness. Plus, there are five settings for coffee strength: extra-mild, mild, regular, strong, and extra strong. The easy to use rotary control panel allows you to easily choose the size of cup you from small (risretto) to large (American coffee).',1,1,11.14,17.52,14.88,'DeLonghi','ESAM5500M',23.2,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (135,2001,'DeLonghi - Alicia Moka Expresso Maker','Transparent container allows you to easily monitor the entire brewing process. The container is durable and easy-to-clean. Filter adapter allows you to choose 3 or 6 cups of espresso. Cordless operation with detachable base makes serving simple.',0,1,4.8,7.28,9.25,'DeLonghi','EMK6',4,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (136,2001,'DeLonghi - Magnifica Super Automatic Espresso Machine','What you grind is what you brew. The compact and patented Direct-to-Brew System with Thermo Block technology provides excellent heat distribution and its removable for easy cleaning. The beans are ground instantly to ensure the freshest espresso or coffee.',0,1,11,15,14,'DeLonghi','ESAM3300',26.2,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (137,2001,'DeLonghi - Lattissima - Metal','Patented IFD system includes a 25 oz. milk container for cappuccino or latte macchiato. It also includes a unique automatic cleaning function with the easy push of a button. Plus, the entire container is detachable, so it can easily be placed in the refrigerator. Amounts of frothed / steamed milk and coffee are adjustable. Cup warming tray is perfect for warm, ready-to-use cups.',1,1,8,13.5,10,'DeLonghi','EN680M',22.4,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (138,2001,'DeLonghi - Pump Driven Espresso/Cappuccino','High performance pump pressure delivers rich and savory espresso with crema. Swivel jet frother utilizes dry steam to produce a thick milk froth for cappuccino, latte and hot chocolate. Adjustable steam emission For espresso or cappuccino includes pressure safety valve to ensure safe operation.',0,1,8.07,10.24,11.81,'DeLonghi','BAR32',11.2,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (139,2001,'DeLonghi - Magnifica Digital Auto Espresso/Cappuccino Machine','Digital programmable menu settingsallow you to adjust start time, auto shut-off and clock. You can adjust temperature of the coffee and water hardness. Plus, there are five settings for coffee strength: extra-mild, mild, regular, strong, and extra strong. Three buttons allow you to easily choose the size of cup you want: ristretto (small), espresso (medium) and large (American coffee). The three settings can be customized to your preferred taste.',1,1,11,15,14,'DeLonghi','ESAM3500',31,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (140,2001,'Pasquini - Livia Automatic Espresso Machine Kit','The ultimate gift for the discriminating espresso connoisseur and home barista, the Livia 90 Automatic is the top-of-the-line commercial-grade automatic home machine. This extraordinary machine has all the benefits of the Livia 90 with the added convenience of automatic espresso extraction settings and use of E.S.E. Servings (pods).',0,1,12.25,11.5,15,'Pasquini','E406',50,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (141,2001,'Illy - Francis Francis X1 Ground Espresso Machine Kit','Ideal for connoisseurs who love preparing authentic espresso the traditional way, the X1 Ground features new state-of-the-art electronics and automatic boiler refill. Featuring all new electronics and updated controls, this retro-futuristic espresso machine designed by Italian architect Luca Trazzi comes in a handsome finish that makes a bold statement in any kitchen.',1,1,12.5,10.5,9.5,'Illy','E410',15.4,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (142,2001,'Illy - Francis Francis X3 Espresso Machine Kit','A creation of renowned Italian architect Luca Trazzithis sleek, compact Francis Francis X3 espresso machine is designed for coffee lovers who may be more cost-conscious or have limited kitchen space but don''t want to sacrifice quality or aesthetics. It makes perfect espresso with illy''s Easy Serving Espresso (E.S.E.) system.',0,1,11.5,6,10.5,'Illy','E301',13.2,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (143,2001,'Illy - Francis Francis X1 Trio Espresso Machine Kit','Enjoy the pleasure of espresso three ways with the new Francis Francis X1 Trio featuring advanced trio technology for ristretto (short), espresso and espresso lungo with a turn of the brewing handle. Combining state-of-the-art electronics with the world famous, retro-futuristic design by Italian architect Luca Trazzi, the X1 Trio makes it easier than ever to prepare expert espresso and cappuccino each and every time.',1,1,13,9.85,10.25,'Illy','E409',15.43,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (144,2001,'Gaggia - Classic Espresso Machine Kit','The Classic is Italian espresso machine manufacturer Gaggia''s top of the line machine for home baristas. Loaded with commercial-quality components, the Classic is encased in a handsome and durable solid brushed stainless steel housing.',0,1,14.25,8,9.5,'Gaggia','E400',17,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (145,2001,'Jura - Capresso Impressa Z5 Espresso Machine Kit','This super automatic espresso machine lets you go from whole beans to superb espresso and any size cappuccino or latte with one-touch convenience. Programmable brewing buttons let you select your coffees size, strength and temperature. Built-in commercial burr grinder is extremely low-noise, making the Impressa Z5 the quietest automatic coffee center on the market today',1,1,14.5,12.2,17.1,'Jura','E412',30,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (146,2001,'Pasquini - Livietta Espresso Machine Kit','Compact and semi-automatic, Pasquini''s latest commercial machine for the home fits beautifully in almost any size kitchen. New thermoblock technology lets you steam milk and brew espresso at the same timemaking it ideal for entertaining. Use with illy E.S.E. pods or ground coffee.',0,1,12.5,8.5,14.25,'Pasquini','E408',23,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (147,2001,'Gaggia - Titanium Espresso Machine Kit','This super automatic, all-in-one home cafe machine makes espresso, cappuccino and latte almost instantly. Fully programmable with three brewing buttons to dispense any amount of coffee you like, plus a built-in professional burr grinder and two superb frothers, the Titanium will grind your beans, tamp, brew and discard the grounds, all at the touch of a button.',1,1,14.75,11.5,16.75,'Gaggia','E407',22,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (148,2001,'Saeco - Magic Cappuccino Espresso Machine Kit','This is a terrific machine that uses a patented nickel plated brass pressurized portfilter to ensure a great espresso extraction. It works by pressurizing the brewing chamber through a small spring-loaded valve located below the filter basket. The valve remains closed until enough pressure builds to open it and release the espresso.',1,1,16.75,11.5,13.25,'Saeco','E413',13.5,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (149,2001,'Gaggia - Evolution Espresso Machine Kit','The silver and chrome Gaggia Evolution espresso machine has a high-end look that speaks proudly of its Italian heritage. Featuring many commercial-quality components, the Evolution is an excellent mid-range espresso machine choice for the home.',0,1,13.4,8.7,10.6,'Gaggia','E401',15,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (150,2001,'Saeco - Magic Cappuccino Espresso Machine Kit','This is a terrific machine that uses a patented nickel plated brass pressurized portfilter to ensure a great espresso extraction. It works by pressurizing the brewing chamber through a small spring-loaded valve located below the filter basket. The valve remains closed until enough pressure builds to open it and release the espresso. The high pressure results in an optimal extraction of the coffee flavor and aroma, making a delicious espresso with a thick golden crema.',0,1,16.75,11.5,13.25,'Saeco','E413',13.5,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (151,2001,'Pasquini - Livia 90P Espresso Machine Kit','The ultimate gift for the discriminating espresso connoisseur and home barista. This kit includes the Pasquini Livia 90, the top-of-the-line espesso machine whose commercial-grade quality and design make it the very best semi-automatic home machine worldwide. With sturdy commercial components from Pasquini''s acclaimed professional line, the Livia 90 can steam milk and brew coffee simultaneously, making outstanding Italian espresso and cappuccino every time. Pasquini stainless base also available.',1,1,12.25,11.5,15,'Pasquini','E405',50,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (152,2001,'Kitchenaid - ProLine Espresso Machine Kit','The Kitchenaid Pro Line is a high-performance professional espresso machine designed for the home. Based on models used in Italian coffee bars, this stylish commercial-grade machine has dual boilers that let you brew espresso and steam milk with no downtime, making the Pro Line supberb for home entertaining. Use with ground coffee or illy''s E.S.E. servings (pods).',0,1,16,12.4,12.5,'Kitchenaid','E402',29.9,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (153,2001,'Illy - FrancisFrancis X6 Trio Espresso Machine Kit','From renowned Italian espresso machine maker francis francis and architect Luca Trazzi, the X6 features an 18 Bar pressure pump and unique Trio Technology that makes three espresso preparations: short (ristretto), normal(espresso) and long (espresso lungo). With quality all-brass boiler and brewing components, the X6 is designed to work exclusively with E.S.E. Servings (pods) for perfectly measured and tamped espresso every time. And the stylish retro-contemporary design makes a strong visual statement in any kitchen.',1,1,12.5,10.5,9.5,'Illy','E304',13.2,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (154,2001,'Illy - FrancisFrancis X8 iperEspresso Machine Kit','Designed to work exclusively with illy iperEspresso capsules, the state-of-the-art Francis Francis X8 iperEspresso machine makes extraordinary espresso with one-touch convenience. Unlike conventional one-stage systems, the iperEspresso method uses an innovative, patented two-stage process to create intensely aromatic, full-bodied espresso with rich, velvety crema that lasts and lasts. And because extraction takes place entirely inside the capsule, the coffee and machine never come in contact making for easy clean up.',1,1,12.6,7.9,13.4,'Illy','E309',13.3,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (155,2001,'Illy - FrancisFrancis X7 iperEspresso Machine Kit','Designed to work exclusively with illy iperEspresso capsules, the striking Francis Francis X7 makes extraordinary espresso with one-touch convenience. Unlike conventional one-stage systems, the iperEspresso method uses an innovative, patented two-stage process to create intensely aromatic, full-bodied espresso with rich, velvety crema that lasts and lasts. And because extraction takes place entirely inside the capsule, the coffee and machine never come in contact making for easy clean up.',1,1,12.2,11,13.2,'Illy','E307',13.2,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (156,2001,'DeLonghi - Magnifica Super Automatic Espresso Machine Kit','The Delonghi Magnifica lets you brew fresh, aromatic espresso or coffee from beans freshly ground in the professional-quality, lower-pitch conical burr grinder. What you grind is what you brew. The compact and patented Direct-to-Brew System with Thermo Block technology provides excellent heat distribution and its removable for easy cleaning. Double boiler with new stainless steel piped espresso boiler -no longer wait between espresso and steam.',0,1,14,11,15,'DeLonghi','E414',21,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (157,2001,'Saeco - Odea Giro Super Automatic Espresso Machine kit','Designed by BMW DesignworksUSA, the new Saeco Odea super automatic espresso machine lets you easily brew high-quality espresso and cappuccino at home. Featuring Saeco''s innovative Giro interface display with simplified programming, this super automatic starts with whole bean coffee and automatically grinds, tamps, doses and brews. Intuitive controls let you select the type of drink you want, your coffee strength (mild, medium, strong) and number of servings.',0,1,14.5,11.5,15,'Saeco','E411',19,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (158,2001,'Saeco - Nina Cappuccino,The mid-level machine in the Nina line','Nina Cappuccino features a cappuccinatore automatic frothing device that allows you to quickly and easily make delicious cappuccinos and lattes. It also stands out from the rest of the line with its beige exterior color. Other features include a valve water tank, height adjustable drip tray and the new ESE metal filter holder.',0,1,11,12,14,'Saeco','Nina Cappuccino',9,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (159,2001,'Saeco - Magic Cappuccino Plus','The Magic Cappuccino Plus is a combination of elegant style, with its stately silver color, and durable commercial characteristics. This unit has been a long time favorite due to sturdy construction and ease of use. This traditional pump driven espresso machine makes perfect espresso, cappuccino and lattes every time. The electric pump system and unique pressurized portafilter enable the user to make a perfect cup of espresso without being an expert barista',1,1,9.5,11,14,'Saeco','Magic Cappuccino Plus',13.5,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (160,2001,'Saeco - Nina Bar','The top level machine in the Nina line, Nina Bar features an innovative new interface that allows for more brewing control. With the push of a button you can program the electronic dosing system and control the amount of coffee brewed. Once programming is complete, the coffee buttons will dose the exact amount of coffee each time it you brew. Other features include a valve water tank, height adjustable drip tray and the new ESE metal filter holder.',1,1,11,12,14,'Saeco','Nina Bar',9,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (161,2001,'Saeco - Aroma','This traditional Italian-made espresso machine is a great addition to any kitchen. Featuring a sturdy all-metal body, this machine is designed to last. The steam wand allows you to froth milk quickly and easily, and even dispenses hot water for tea. Create all of your favorite coffee drinks, such as cappuccinos, lattes, and mochas. It includes a pressurized portafilter, making traditional espresso-brewing simple and easy.',0,1,8,10,11.75,'Saeco','Aroma',14,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (162,2001,'Saeco - Odea Giro Orange','Part of the new Odea line designed by BMW DesignworksUSA, the Odea Giro features Saeco''s latest innovations including a Giro (dial) interface, ceramic disc grinder, drip tray with manual Touch Lift technology, and OptiDose, to adjust the aroma of your favorite coffee. Thanks to Rapid Steam, you can use the redesigned steam wand to create delicious frothed milk in just a matter of seconds.',1,1,11.5,15,14.5,'Saeco','Odea Giro Orange',19,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (163,2001,'Saeco - Talea Touch','Part of the new Talea line designed by BMW DesignworksUSA, the Talea Touch features Saeco''s latest innovations including a large touch screen interface, SBS Saeco Brewing System, ceramic disc grinder and motorized drip tray with Touch Lift technology. This super automatic espresso machine includes Saeco''s Milk Island, an automatic milk frothing device.',0,1,13,16,14.5,'Saeco','Talea Touch',21,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (164,2001,'Saeco - Primea Ring','Designed exclusively by BMW Group DesignworksUSA, the Primea Ring is a masterpiece in design, and the latest in luxury for your home. Thanks to superior innovations in technology, the Primea Ring prepares espresso with a perfect crema, aroma and flavor every time. Fully programmable features, accessed through the click wheel interface, cater to the personal preferences of every coffee lover.',0,1,14,18,15,'Saeco','Primea Ring',33,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (165,2001,'Saeco - Royal Coffee Bar','The Royal Coffee Bar, stylish and sleek in silver and graphite, is sure to be an eye catcher in any kitchen or office. With the simple push button technology the machine will grind, tamp, and dispense espresso/coffee with a rich creamy crema. The digital display makes using the Royal Coffee Bar simple to operature, even for a beginner barista. Preset your individual drinks to the amount you desire, then steam milk with the Cappuccinatore, automatic frothing device and you will have a delicious cappuccino or latte.',1,1,15.25,17.5,15.75,'Saeco','Royal Coffee Bar',31.5,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (166,2001,'Saeco - Incanto Classic','Part of the Incanto family of automatic machines, the Incanto Classic features innovative Saeco technologies including 2 programmable beverage settings, Saeco OptiDose and built-in burr grinder. With the Saeco Brewing System, or SBS, the Classic makes it easier than ever before to customize and brew espresso at home; and thanks to the Rapid Steam technology, you can easily froth milk to quickly turn an espresso into a cappuccino or latte.',1,1,12,15.5,15,'Saeco','Incanto Classic',26,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (167,2001,'Saeco - Espresso Italiano','Bringing the caf into your own home has never been easier than with the Espresso Italiano. Just add whole beans and water, and instantly you will have a perfectly extracted espresso. With state-of-the-art technology, including a tri-colored digital display screen that helps to easily identify the machines functions, you can make all of your favorite espresso-based drinks, including cappuccino, latte and Americano.',0,1,13,19,14.5,'Saeco','Espresso Italiano',20,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (168,2001,'Saeco - Spidem Villa','The Villa Silver puts Saecos patented removable brew group technology into an easy-to-use interface. You can now make espressos, cappuccinos, lattes, and tea all from one machine that grinds, tamps, and brews gourmet coffee. The pump driven steam and hot water wand has an exclusive Pannarello to make frothing milk simple. The Villas adjustable conical burr grinder makes the perfect grind for gourmet coffee.',0,1,15,14,15.5,'Saeco','Spidem Villa',18,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (169,2001,'Jura - ENA 5','The new contemporary design is less than 9 inches wide, freeing up counter space while offering a true bean-to-cup experience. The new rotary switch makes the ENA the easiest to use automatic coffee center. The patent-pending Zero-Energy-Technology uses less electricity than any other coffee center on the market. Created for the coffee enthusiast, the ENA series offers the best in authentic crema coffee, espresso, cappuccino and latte in a flawless, striking design. The ENA series features 18 bars of pressure, a professional-grade conical burr grinder, energy saving technology and a wealth of convenience features.',1,1,14,9,17,'Jura','13442',20,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (170,2001,'Jura - IMPRESSA S9 One Touch','With the latest and most comprehensive One Touch technology, the Jura-Capresso IMPRESSA S9 One Touch lets you make cappuccino, cafe mocha, latte or latte macchiato with the simple touch of one button, without moving the cup.  It can grind, tamp and brew delicious crema coffee or espresso  in seconds, one or two cups at a time,  to 16 ounces  fresher than in a coffee bar.  The IMPRESSA S9 One Touch with two stainless steel-lined ThermoBlock heating systems and its large 96 ounce water capacity makes easy work out of espresso based drinks and frothed milk drinks, with no down time.',1,1,14.75,13.5,15,'Jura','13423',27,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (171,2001,'Jura - IMPRESSA J5','The IMPRESSA J5 is Juras first compact automatic coffee center expressing a new design philosophy. Smooth, clean lines, elegant accents, and an all-encompassing attention to detail make the J5 an aesthetic masterpiece from any angle. High-end materials, a rich platinum metallic treatment for the front and top with tasteful chrome accents contrast with matte black side panels. A second version features glossy piano white panels recognizing this resurgent kitchen dcor option.',1,1,13.6,11,17.1,'Jura','13333',22,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (172,2001,'Jura - IMPRESSA Z5','Beans are ground. Fresh, cold milk transforms into hot, frothed milk and pours into your cup. With high pressure hot water is forced through the perfectly ground and tamped coffee. Now espresso flows through the thick layer of milk froth: pick up your cappuccino and enjoy. In the meantime the used coffee grounds are discarded and you can immediately start dreaming about another cappuccino, latte, espresso or any other hot large cup of crema coffee.',0,1,12.2,14.5,17.1,'Jura','13339',30,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (173,2001,'Jura - IMPRESSA C9 One Touch','The IMPRESSA C9 One Touch is the most compact One Touch Automatic Coffee Center today.  With the ultimate in user-friendly technology, the C9 One Touch creates a cappuccino, cafe mocha or latte at the touch of one button, without moving the cup.  The insulated 14 oz. thermal stainless steel milk container keeps cold milk cold for up to eight hours, so you can leave the milk right next to the machine. No more running back and forth to the refrigerator.',0,1,13.5,11,16,'Jura','13422',21,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (174,2001,'Jura - IMPRESSA Z6','Add luxury to perfection! Grand curved high-gloss chrome plated-plated aluminum front. High-polished mirrored LED display (the LED information shines through the mirror finish). Hand-polished, oversized, drip tray made of die-cast zinc (weighs almost 1.5 lbs!) lets the Z6 shines even more. Custom designed 20 oz. stainless steel thermal milk container keeps cold milk cold for up to eight hours.',0,1,12.2,14.5,17.1,'Jura','13299',31.5,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (175,2007,'DeLonghi - Electric Coffee Grinder','4-12 cup (2.36-ounce) ground coffee capacity. Stainless steel grinding blades are durable and long lasting. Grind selector allows you to choose the perfect grind setting from coarse, to medium, to fine - indicated by the 3 green lights.',0,1,4.13,4.53,8.58,'DeLonghi','DCG39',3,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (176,2007,'Bodum - Venice','This stylish hand coffee grinder is made of brushed stainless steel and plastic. It features an adjustable grind control and easy-to-fill container that holds enough beans for an 8 cup BODUM coffee maker. The container has a bayonet cap fitting which is dishwasher safe. The opening on the top slides for easy fill of coffee beans.',0,1,6.1,4.5,8.5,'Bodum','0429-10',1.5,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (177,2007,'Bodum - C-Mill','Coffee culture in this country has improved a lot over the last years. Still, what''s not completely understood is what a big difference freshly ground coffee beans make to the taste. It''s the defining element in the coffee brewing process, next to the quality of the beans, the roast, the water, and the coffee maker.',0,1,NULL,NULL,NULL,'Bodum','5679-01US',4,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (178,2007,'Bodum - Antigua','Freshly ground coffee makes all the difference when brewing the perfect cup! Just like professional-grade coffee grinders, BODUMs Antigua electric coffee grinder features a conical burr grinder that cuts the coffee beans rather than crushing them, preventing the coffee from losing its characteristic taste and aroma.',0,1,NULL,NULL,NULL,'Bodum','10462-01USA',7,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (179,2007,'Capresso - Cool Grind Blade Grinder','Our Cool Grind blade grinders are suitable for drips coffee makers and percolators. They also to a great job for grinding spices and herbs. The large stainless steel grinding chamber reduces heat built-up to preserve more aroma.',0,1,8,4,4,'Capresso','503',2,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (180,2001,'Havaletta - Macchianator','Brass boiler, lines and chromed brass brewing head all maintain and distribute heat to brew the perfect cup of coffee.',0,1,8,4,4,'Havaletta','503',25,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (181,2005,'Havaletta - Basic Cup','The basic no frills option. For the person who wants the world to know that they''re drinking coffee, and that doesn''t have mean anything more.',0,1,8,4,4,'Havaletta','1',2,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (182,2005,'Havaletta - Diner Cup','Whether you prefer your greasy eggs with greasy sausage or greasy bacon, this cup will hold your black coffee with a flared top that makes it easier for the waitress to top you off.',0,1,8,4,4,'Havaletta','1',2,'2020-01-01',CURRENT_DATE);
INSERT INTO BLC_PRODUCT (PRODUCT_ID,DEFAULT_CATEGORY_ID,NAME,LONG_DESCRIPTION,IS_FEATURED_PRODUCT,IS_MACHINE_SORTABLE,WIDTH,HEIGHT,DEPTH,MANUFACTURE,MODEL,WEIGHT,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (183,2005,'Havaletta - Colored Ceramic Cup','These colored cups are perfect for curling up with a good book on a rainy Saturday morning.',0,1,8,4,4,'Havaletta','1',2,'2020-01-01',CURRENT_DATE);

INSERT INTO BLC_CATEGORY_XREF (SUB_CATEGORY_ID, CATEGORY_ID, DISPLAY_ORDER) VALUES (1000,1,1);
INSERT INTO BLC_CATEGORY_XREF (SUB_CATEGORY_ID, CATEGORY_ID, DISPLAY_ORDER) VALUES (2000,1,2);
INSERT INTO BLC_CATEGORY_XREF (SUB_CATEGORY_ID, CATEGORY_ID, DISPLAY_ORDER) VALUES (1001,1000,1);
INSERT INTO BLC_CATEGORY_XREF (SUB_CATEGORY_ID, CATEGORY_ID, DISPLAY_ORDER) VALUES (1002,1000,2);
INSERT INTO BLC_CATEGORY_XREF (SUB_CATEGORY_ID, CATEGORY_ID, DISPLAY_ORDER) VALUES (1003,1000,3);
INSERT INTO BLC_CATEGORY_XREF (SUB_CATEGORY_ID, CATEGORY_ID, DISPLAY_ORDER) VALUES (1004,1000,4);
INSERT INTO BLC_CATEGORY_XREF (SUB_CATEGORY_ID, CATEGORY_ID, DISPLAY_ORDER) VALUES (1005,1000,5);
INSERT INTO BLC_CATEGORY_XREF (SUB_CATEGORY_ID, CATEGORY_ID, DISPLAY_ORDER) VALUES (1006,1000,6);
INSERT INTO BLC_CATEGORY_XREF (SUB_CATEGORY_ID, CATEGORY_ID, DISPLAY_ORDER) VALUES (1007,1000,7);
INSERT INTO BLC_CATEGORY_XREF (SUB_CATEGORY_ID, CATEGORY_ID, DISPLAY_ORDER) VALUES (1008,1000,8);
INSERT INTO BLC_CATEGORY_XREF (SUB_CATEGORY_ID, CATEGORY_ID, DISPLAY_ORDER) VALUES (2001,2000,1);
INSERT INTO BLC_CATEGORY_XREF (SUB_CATEGORY_ID, CATEGORY_ID, DISPLAY_ORDER) VALUES (2002,2000,2);
INSERT INTO BLC_CATEGORY_XREF (SUB_CATEGORY_ID, CATEGORY_ID, DISPLAY_ORDER) VALUES (2003,2000,3);
INSERT INTO BLC_CATEGORY_XREF (SUB_CATEGORY_ID, CATEGORY_ID, DISPLAY_ORDER) VALUES (2004,2000,4);
INSERT INTO BLC_CATEGORY_XREF (SUB_CATEGORY_ID, CATEGORY_ID, DISPLAY_ORDER) VALUES (2005,2000,5);
INSERT INTO BLC_CATEGORY_XREF (SUB_CATEGORY_ID, CATEGORY_ID, DISPLAY_ORDER) VALUES (2006,2000,6);
INSERT INTO BLC_CATEGORY_XREF (SUB_CATEGORY_ID, CATEGORY_ID, DISPLAY_ORDER) VALUES (2007,2000,7);

INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (1,1,1001);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (2,2,1001);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (3,3,1001);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (1,4,1002);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (2,5,1002);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (3,6,1002);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (4,7,1002);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (5,8,1002);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (6,9,1002);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (7,10,1002);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (8,11,1002);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (9,12,1002);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (10,13,1002);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (11,14,1002);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (1,15,1003);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (2,16,1003);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (3,17,1003);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (4,18,1003);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (5,19,1003);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (6,20,1003);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (7,21,1003);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (8,22,1003);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (9,23,1003);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (10,24,1003);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (11,25,1003);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (12,26,1003);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (13,27,1003);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (14,28,1003);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (15,29,1003);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (16,30,1003);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (17,31,1003);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (1,32,1004);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (2,33,1004);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (3,34,1004);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (4,35,1004);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (5,36,1004);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (6,37,1004);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (7,38,1004);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (8,39,1004);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (9,40,1004);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (10,41,1004);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (11,42,1004);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (12,43,1004);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (13,44,1004);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (14,45,1004);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (15,46,1004);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (16,47,1004);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (17,48,1004);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (18,49,1004);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (19,50,1004);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (20,51,1004);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (21,52,1004);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (22,53,1004);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (23,54,1004);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (1,55,1005);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (2,56,1005);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (3,57,1005);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (4,58,1005);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (5,59,1005);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (6,60,1005);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (7,61,1005);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (8,62,1005);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (9,63,1005);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (10,64,1005);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (11,65,1005);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (12,66,1005);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (3,67,1005);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (14,68,1005);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (15,69,1005);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (1,70,1006);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (2,71,1006);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (3,72,1006);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (4,73,1006);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (5,74,1006);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (6,75,1006);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (7,76,1006);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (8,77,1006);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (9,78,1006);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (10,79,1006);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (11,80,1006);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (12,81,1006);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (13,82,1006);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (14,83,1006);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (15,84,1006);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (16,85,1006);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (17,86,1006);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (18,87,1006);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (1,88,1007);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (2,89,1007);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (3,90,1007);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (4,91,1007);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (5,92,1007);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (6,93,1007);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (7,94,1007);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (8,95,1007);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (9,96,1007);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (10,97,1007);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (11,98,1007);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (12,99,1007);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (13,100,1007);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (1,101,1008);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (2,102,1008);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (3,103,1008);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (4,104,1008);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (5,105,1008);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (6,106,1008);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (7,107,1008);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (8,108,1008);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (9,109,1008);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (10,110,1008);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (11,111,1008);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (12,112,1008);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (13,113,1008);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (14,114,1008);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (15,115,1008);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (16,116,1008);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (17,117,1008);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (18,118,1008);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (19,119,1008);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (20,120,1008);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (21,121,1008);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (22,122,1008);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (23,123,1008);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (24,124,1008);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (25,125,1008);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (26,126,1008);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (1,127,2002);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (2,128,2002);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (3,129,2002);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (4,130,2002);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (5,131,2002);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (6,132,2002);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (7,133,2002);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (1,134,2001);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (2,135,2001);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (3,136,2001);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (4,137,2001);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (5,138,2001);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (6,139,2001);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (7,140,2001);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (8,141,2001);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (9,142,2001);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (10,143,2001);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (11,144,2001);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (12,145,2001);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (13,146,2001);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (14,147,2001);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (15,148,2001);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (16,149,2001);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (17,150,2001);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (18,151,2001);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (19,152,2001);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (20,153,2001);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (21,154,2001);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (22,155,2001);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (23,156,2001);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (24,157,2001);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (25,158,2001);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (26,159,2001);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (27,160,2001);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (28,161,2001);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (29,162,2001);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (30,163,2001);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (31,164,2001);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (32,165,2001);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (33,166,2001);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (34,167,2001);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (35,168,2001);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (36,169,2001);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (37,170,2001);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (38,171,2001);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (39,172,2001);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (40,173,2001);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (41,174,2001);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (42,180,2001);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (1,175,2007);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (2,176,2007);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (3,177,2007);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (4,178,2007);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (5,179,2007);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (1,181,2005);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (2,182,2005);
INSERT INTO BLC_CATEGORY_PRODUCT_XREF (DISPLAY_ORDER, PRODUCT_ID, CATEGORY_ID) VALUES (3,183,2005);

INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (1,'Original',NULL,19.99,19.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (2,'Dark Roast',NULL,15.99,15.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (3,'Decaffeinated',NULL,22.99,22.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (4,'Original',NULL,5.99,3.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (5,'50% Decaf',NULL,9.99,6.99,'N','Y','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (6,'Mocha',NULL,19.99,17.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (7,'Bokar',NULL,11.99,9.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (8,'Decaf Original',NULL,8.99,8.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (9,'French Vanilla',NULL,8.99,6.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (10,'French Roast',NULL,8.99,6.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (11,'100% Columbian',NULL,17.99,15.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (12,'Hazelnut',NULL,5.99,3.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (13,'Dark Italian Roast',NULL,16.99,14.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (14,'Decaf 100% Columbian',NULL,10.99,10.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (15,'BeachHouse Blend',NULL,5.99,3.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (16,'Best Blend',NULL,20.99,18.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (17,'Henry''s Blend',NULL,5.99,3.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (18,'6th Avenue Bistro Blend',NULL,24.99,24.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (19,'Almond Roca',NULL,23.99,21.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (20,'Cinnabon',NULL,14.99,12.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (21,'Columbian',NULL,17.99,15.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (22,'Creme Brulee',NULL,4.99,4.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (23,'Decaf Organic Fair Trade Twilight',NULL,15.99,13.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (24,'Hazelnut',NULL,22.99,20.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (25,'Breakfast Blend',NULL,22.99,20.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (26,'Organic House Blend',NULL,18.99,18.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (27,'Organic Sumatra',NULL,14.99,12.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (28,'Portside',NULL,17.99,15.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (29,'Post Alley Blend',NULL,11.99,11.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (30,'Saturday''s Blend',NULL,18.99,16.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (31,'Vanilla Bean',NULL,22.99,20.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (32,'Light Roast',NULL,19.99,19.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (33,'Medium Roast',NULL,3.99,1.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (34,'Medium Dark Roast',NULL,18.99,18.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (35,'Dark Roast',NULL,20.99,18.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (36,'Organic Deep Peruvian Forest',NULL,8.99,8.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (37,'Organic Mayan Black Oynx',NULL,21.99,19.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (38,'Organic Mountain Fair Trade Certified',NULL,13.99,11.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (39,'Organic Nicaraguan Mountain Twilight',NULL,7.99,5.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (40,'Organic Rainforest Reserve',NULL,15.99,15.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (41,'Caramel Trufle',NULL,12.99,10.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (42,'Chocolate Velvet',NULL,20.99,20.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (43,'Cinnamon Hazelnut',NULL,20.99,18.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (44,'Decaf Caramel Truffle',NULL,15.99,13.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (45,'Decaf Chocolate Velvet',NULL,21.99,19.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (46,'Decaf French Vanilla',NULL,23.99,23.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (47,'Decaf Hazelnut Cream',NULL,22.99,20.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (48,'French Vanilla',NULL,17.99,15.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (49,'Hazelnut Cream',NULL,23.99,23.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (50,'Holiday Peppermint',NULL,6.99,4.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (51,'Pumpkin Spice',NULL,10.99,8.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (52,'Raspberries ''n Cream',NULL,16.99,14.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (53,'Swiss Chocolate Almond',NULL,3.99,1.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (54,'Vanilla Nut Cream',NULL,19.99,19.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (55,'100% Columbian',NULL,21.99,19.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (56,'Columbian Decaf',NULL,7.99,5.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (57,'City Blend',NULL,18.99,16.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (58,'Rich French Roast',NULL,23.99,21.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (59,'French Roast Decaf',NULL,13.99,13.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (60,'New York Roast',NULL,6.99,4.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (61,'Original',NULL,7.99,5.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (62,'Original Decaf',NULL,3.99,1.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (63,'Hazelnut',NULL,24.99,22.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (64,'Brick',NULL,9.99,9.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (65,'SoHo Morning Roast',NULL,14.99,12.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (66,'Upper West Side European Roast',NULL,17.99,15.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (67,'Upper West Side European Roast Decaf',NULL,20.99,18.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (68,'Midtown French',NULL,22.99,22.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (69,'Greenwich Village',NULL,10.99,8.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (70,'Dark Roast',NULL,8.99,6.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (71,'Columbian Supreme',NULL,19.99,19.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (72,'French Roast',NULL,21.99,19.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (73,'South Pacific Blend',NULL,11.99,9.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (74,'Slow Roast',NULL,8.99,8.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (75,'Original',NULL,16.99,14.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (76,'Lite',NULL,10.99,8.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (77,'Master Blend',NULL,21.99,19.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (78,'Breakfast Blend',NULL,10.99,10.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (79,'Original Decaf',NULL,16.99,14.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (80,'French Roast Decaf',NULL,20.99,18.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (81,'Master Blend Decaf',NULL,11.99,11.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (82,'Vanilla Flavored',NULL,18.99,16.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (83,'Hazelnut Flavored',NULL,6.99,6.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (84,'Original Instant',NULL,10.99,8.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (85,'Decaf Instant',NULL,24.99,24.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (86,'Sanka Instant Decaf',NULL,18.99,16.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (87,'Yuban Instant',NULL,16.99,14.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (88,'Classic Roast',NULL,24.99,24.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (89,'Special Roast',NULL,16.99,14.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (90,'Classic Roast Half Caff',NULL,7.99,7.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (91,'Bistro Blend',NULL,4.99,2.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (92,'Hazelnut Creme',NULL,5.99,3.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (93,'Vanilla Biscotti',NULL,19.99,19.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (94,'Chocolate Truffle',NULL,10.99,8.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (95,'Creme Brulee',NULL,7.99,7.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (96,'Caramel Drizzle',NULL,22.99,20.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (97,'Morning Cafe',NULL,3.99,3.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (98,'Lively Columbian',NULL,20.99,18.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (99,'Brazilian Sunrise',NULL,13.99,13.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (100,'Bold Java',NULL,24.99,22.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (101,'Arabian Mocha Sanani',NULL,18.99,18.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (102,'Brazil Ipanema Bourbon',NULL,12.99,10.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (103,'Bella Vista F.W. Tres Rios Costa Rica',NULL,5.99,3.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (104,'Breakfast Blend',NULL,21.99,21.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (105,'Guatemala Antigua',NULL,10.99,8.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (106,'Guatemala Casi Cielo',NULL,7.99,5.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (107,'House Blend',NULL,15.99,15.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (108,'Decaf House Blend',NULL,24.99,22.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (109,'Organic Shade Grown Mexico',NULL,19.99,17.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (110,'Columbian Narino Supremo',NULL,17.99,15.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (111,'Kenya',NULL,20.99,20.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (112,'Ethiopia Sidamo',NULL,12.99,10.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (113,'Sumatra',NULL,19.99,19.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (114,'Komodo Dragon Blend',NULL,19.99,17.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (115,'Decaf Sumatra',NULL,17.99,15.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (116,'Cafe Estima Blend',NULL,11.99,11.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (117,'Caffe Verona',NULL,3.99,1.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (118,'Caffe Verona Decaf',NULL,11.99,9.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (119,'Gold Coast Blend',NULL,20.99,20.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (120,'Organic Serena Blend',NULL,10.99,8.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (121,'Espresso Roast',NULL,11.99,11.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (122,'Decaf Espresso Roast',NULL,10.99,8.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (123,'French Roast',NULL,4.99,3.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (124,'Italian Roast',NULL,9.99,7.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (125,'Pike Place Roast',NULL,9.99,9.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (126,'Decaf Pike Place Roast',NULL,23.99,21.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (127,'DeLonghi - 10 Cup Drip Coffee Maker','Seamless brushed aluminum body durable and stylish, it beautifully complements any kitchen decor. Permanent gold-tone filter durable and long-lasting, the gold-tone filter is specially designed to keep even the finest grounds out of your coffee. Ergonomic handle for comfortable use and easy handling.',194.99,194.99,'N','Y','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (128,'DeLonghi - 14 Cup Drip Coffee Maker','24-hour programmable timer is convenient and easy-to-use. Just set the timer the night before, and wake up to the aroma of fresh brewed coffee. Internal water level indicator lets you know how much water is in the tank. Permanent gold-tone filter durable and long lasting, the gold-tone filter is specially designed to keep even the finest grounds out of your coffee.',198.99,198.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (129,'DeLonghi - 12-Cup Drip Coffee Maker w/ Frontal Access','24-hour programmable digital timer with 2 hour automatic shut-off. Water level indicator lets you know when the unit needs refilling. Permanent gold-tone filter durable and long lasting, the gold-tone filter is specially designed to keep even the finest grounds out of your coffee.',149.99,149.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (130,'Capresso - Coffee Team Therm Grind/Brew Coffeemaker Kit','Perfect for the brewed coffee connoisseur, the programmable 10-cup capacity Capresso CoffeeTEAM is the only combination machine with a conical burr grinder and a stainless steel thermal carafe. Just pour in the beans, program the time and the amount of coffee to be ground and the brewer does the rest. High quality heating elements assure ideal brewing temperatures of over 200F and approximately 180Ã°F in the carafe directly after brewing.',183.99,181.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (131,'Capresso - MT500 PLUS Coffeemaker Kit','It''s easy to see why this programmable 10-cup coffee maker was named "2008 Consumers Digest Best Buy". With its beautiful high-gloss alloy body and stainless steel thermal carafe, the Capresso MT500 keeps coffee hot and fresh for up to 4 hours.',67.99,67.99,'N','Y','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (132,'Capresso - CoffeeTEC','Brews 10 5-ounce cups of coffee directly into a stainless-steel vacuum carafe. Virtually unbreakable carafe keeps coffee hot 4 hours without a warming plate. Programmable digital clock/timer for "wake-up" coffee; pour a cup midbrew via 20-second brew-pause. Permanent GoldTone filter eliminates messy paper filters; push-button, swing-out filter holder.',207.99,205.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (133,'Bodum - Cafe Solo - Filtre Belgique','The design of the Filter Belgique is itself done with a "silent attitude", but the product incorporates a high content of design details which make it simple to use and nice to look at. In this way, it stands out from most of the same type of mass-market products. The Filter Belgique design came from the same honest work that so many scarcely noticed everyday essentials emerge from.',79.99,77.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (134,'DeLonghi - Perfecta Fully Automatic Expresso Machine','Easy to use control panel with digital programmable menu settings allow you to adjust start time, auto shut and off and clock. You can adjust temperature of the coffee and water hardness. Plus, there are five settings for coffee strength: extra-mild, mild, regular, strong, and extra strong. The easy to use rotary control panel allows you to easily choose the size of cup you from small (risretto) to large (American coffee).',43.99,41.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (135,'DeLonghi - Alicia Moka Expresso Maker','Transparent container allows you to easily monitor the entire brewing process. The container is durable and easy-to-clean. Filter adapter allows you to choose 3 or 6 cups of espresso. Cordless operation with detachable base makes serving simple.',138.99,138.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (136,'DeLonghi - Magnifica Super Automatic Espresso Machine','What you grind is what you brew. The compact and patented Direct-to-Brew System with Thermo Block technology provides excellent heat distribution and itâs removable for easy cleaning. The beans are ground instantly to ensure the freshest espresso or coffee.',178.99,176.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (137,'DeLonghi - Lattissima - Metal','Patented IFD system includes a 25 oz. milk container for cappuccino or latte macchiato. It also includes a unique automatic cleaning function with the easy push of a button. Plus, the entire container is detachable, so it can easily be placed in the refrigerator. Amounts of frothed / steamed milk and coffee are adjustable. Cup warming tray is perfect for warm, ready-to-use cups.',83.99,81.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (138,'DeLonghi - Pump Driven Espresso/Cappuccino','High performance pump pressure delivers rich and savory espresso with crema. Swivel jet frother utilizes dry steam to produce a thick milk froth for cappuccino, latte and hot chocolate. Adjustable steam emission For espresso or cappuccino includes pressure safety valve to ensure safe operation.',67.99,67.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (139,'DeLonghi - Magnifica Digital Auto Espresso/Cappuccino Machine','Digital programmable menu settingsallow you to adjust start time, auto shut-off and clock. You can adjust temperature of the coffee and water hardness. Plus, there are five settings for coffee strength: extra-mild, mild, regular, strong, and extra strong. Three buttons allow you to easily choose the size of cup you want: ristretto (small), espresso (medium) and large (American coffee). The three settings can be customized to your preferred taste.',125.99,123.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (140,'Pasquini - Livia Automatic Espresso Machine Kit','The ultimate gift for the discriminating espresso connoisseur and home barista, the Livia 90 Automatic is the top-of-the-line commercial-grade automatic home machine. This extraordinary machine has all the benefits of the Livia 90 with the added convenience of automatic espresso extraction settings and use of E.S.E. Servings (pods).',182.99,182.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (141,'Illy - Francis Francis X1 Ground Espresso Machine Kit','Ideal for connoisseurs who love preparing authentic espresso the traditional way, the X1 Ground features new state-of-the-art electronics and automatic boiler refill. Featuring all new electronics and updated controls, this retro-futuristic espresso machine designed by Italian architect Luca Trazzi comes in a handsome finish that makes a bold statement in any kitchen.',53.99,51.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (142,'Illy - Francis Francis X3 Espresso Machine Kit','A creation of renowned Italian architect Luca Trazziâthis sleek, compact Francis Francis X3 espresso machine is designed for coffee lovers who may be more cost-conscious or have limited kitchen space but don''t want to sacrifice quality or aesthetics. It makes perfect espresso with illy''s Easy Serving Espresso (E.S.E.) system.',150.99,150.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (143,'Illy - Francis Francis X1 Trio Espresso Machine Kit','Enjoy the pleasure of espresso three ways with the new Francis Francis X1 Trio featuring advanced trio technology for ristretto (short), espresso and espresso lungo with a turn of the brewing handle. Combining state-of-the-art electronics with the world famous, retro-futuristic design by Italian architect Luca Trazzi, the X1 Trio makes it easier than ever to prepare expert espresso and cappuccino each and every time.',110.99,108.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (144,'Gaggia - Classic Espresso Machine Kit','The Classic is Italian espresso machine manufacturer Gaggia''s top of the line machine for home baristas. Loaded with commercial-quality components, the Classic is encased in a handsome and durable solid brushed stainless steel housing.',74.99,72.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (145,'Jura - Capresso Impressa Z5 Espresso Machine Kit','This super automatic espresso machine lets you go from whole beans to superb espresso and any size cappuccino or latte with one-touch convenience. Programmable brewing buttons let you select your coffeeâs size, strength and temperature. Built-in commercial burr grinder is extremely low-noise, making the Impressa Z5 the quietest automatic coffee center on the market today',182.99,182.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (146,'Pasquini - Livietta Espresso Machine Kit','Compact and semi-automatic, Pasquini''s latest commercial machine for the home fits beautifully in almost any size kitchen. New thermoblock technology lets you steam milk and brew espresso at the same timeâmaking it ideal for entertaining. Use with illy E.S.E. pods or ground coffee.',151.99,151.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (147,'Gaggia - Titanium Espresso Machine Kit','This super automatic, all-in-one home cafe machine makes espresso, cappuccino and latte almost instantly. Fully programmable with three brewing buttons to dispense any amount of coffee you like, plus a built-in professional burr grinder and two superb frothers, the Titanium will grind your beans, tamp, brew and discard the grounds, all at the touch of a button.',179.99,177.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (148,'Saeco - Magic Cappuccino Espresso Machine Kit','This is a terrific machine that uses a patented nickel plated brass pressurized portfilter to ensure a great espresso extraction. It works by pressurizing the brewing chamber through a small spring-loaded valve located below the filter basket. The valve remains closed until enough pressure builds to open it and release the espresso.',144.99,142.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (149,'Gaggia - Evolution Espresso Machine Kit','The silver and chrome Gaggia Evolution espresso machine has a high-end look that speaks proudly of its Italian heritage. Featuring many commercial-quality components, the Evolution is an excellent mid-range espresso machine choice for the home.',184.99,184.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (150,'Saeco - Magic Cappuccino Espresso Machine Kit','This is a terrific machine that uses a patented nickel plated brass pressurized portfilter to ensure a great espresso extraction. It works by pressurizing the brewing chamber through a small spring-loaded valve located below the filter basket. The valve remains closed until enough pressure builds to open it and release the espresso. The high pressure results in an optimal extraction of the coffee flavor and aroma, making a delicious espresso with a thick golden crema.',71.99,69.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (151,'Pasquini - Livia 90P Espresso Machine Kit','The ultimate gift for the discriminating espresso connoisseur and home barista. This kit includes the Pasquini Livia 90, the top-of-the-line espesso machine whose commercial-grade quality and design make it the very best semi-automatic home machine worldwide. With sturdy commercial components from Pasquini''s acclaimed professional line, the Livia 90 can steam milk and brew coffee simultaneously, making outstanding Italian espresso and cappuccino every time. Pasquini stainless base also available.',73.99,73.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (152,'Kitchenaid - ProLine Espresso Machine Kit','The Kitchenaid Pro Line is a high-performance professional espresso machine designed for the home. Based on models used in Italian coffee bars, this stylish commercial-grade machine has dual boilers that let you brew espresso and steam milk with no downtime, making the Pro Line supberb for home entertaining. Use with ground coffee or illy''s E.S.E. servings (pods).',75.99,73.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (153,'Illy - FrancisFrancis X6 Trio Espresso Machine Kit','From renowned Italian espresso machine maker francis francis and architect Luca Trazzi, the X6 features an 18 Bar pressure pump and unique Trio Technology that makes three espresso preparations: short (ristretto), normal(espresso) and long (espresso lungo). With quality all-brass boiler and brewing components, the X6 is designed to work exclusively with E.S.E. Servings (pods) for perfectly measured and tamped espresso every time. And the stylish retro-contemporary design makes a strong visual statement in any kitchen.',187.99,185.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (154,'Illy - FrancisFrancis X8 iperEspresso Machine Kit','Designed to work exclusively with illy iperEspresso capsules, the state-of-the-art Francis Francis X8 iperEspresso machine makes extraordinary espresso with one-touch convenience. Unlike conventional one-stage systems, the iperEspresso method uses an innovative, patented two-stage process to create intensely aromatic, full-bodied espresso with rich, velvety crema that lasts and lasts. And because extraction takes place entirely inside the capsule, the coffee and machine never come in contact making for easy clean up.',133.99,131.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (155,'Illy - FrancisFrancis X7 iperEspresso Machine Kit','Designed to work exclusively with illy iperEspresso capsules, the striking Francis Francis X7 makes extraordinary espresso with one-touch convenience. Unlike conventional one-stage systems, the iperEspresso method uses an innovative, patented two-stage process to create intensely aromatic, full-bodied espresso with rich, velvety crema that lasts and lasts. And because extraction takes place entirely inside the capsule, the coffee and machine never come in contact making for easy clean up.',68.99,68.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (156,'DeLonghi - Magnifica Super Automatic Espresso Machine Kit','The Delonghi Magnifica lets you brew fresh, aromatic espresso or coffee from beans freshly ground in the professional-quality, lower-pitch conical burr grinder. What you grind is what you brew. The compact and patented Direct-to-Brew System with Thermo Block technology provides excellent heat distribution and itâs removable for easy cleaning. Double boiler with new stainless steel piped espresso boiler -no longer wait between espresso and steam.',167.99,167.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (157,'Saeco - Odea Giro Super Automatic Espresso Machine kit','Designed by BMW DesignworksUSA, the new Saeco Odea super automatic espresso machine lets you easily brew high-quality espresso and cappuccino at home. Featuring Saeco''s innovative Giro interface display with simplified programming, this super automatic starts with whole bean coffee and automatically grinds, tamps, doses and brews. Intuitive controls let you select the type of drink you want, your coffee strength (mild, medium, strong) and number of servings.',129.99,127.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (158,'Saeco - Nina Cappuccino','The mid-level machine in the Nina line, Nina Cappuccino features a cappuccinatore automatic frothing device that allows you to quickly and easily make delicious cappuccinos and lattes. It also stands out from the rest of the line with its beige exterior color. Other features include a valve water tank, height adjustable drip tray and the new ESE metal filter holder.',207.99,205.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (159,'Saeco - Magic Cappuccino Plus','The Magic Cappuccino Plus is a combination of elegant style, with its stately silver color, and durable commercial characteristics. This unit has been a long time favorite due to sturdy construction and ease of use. This traditional pump driven espresso machine makes perfect espresso, cappuccino and lattes every time. The electric pump system and unique pressurized portafilter enable the user to make a perfect cup of espresso without being an expert barista',105.99,105.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (160,'Saeco - Nina Bar','The top level machine in the Nina line, Nina Bar features an innovative new interface that allows for more brewing control. With the push of a button you can program the electronic dosing system and control the amount of coffee brewed. Once programming is complete, the coffee buttons will dose the exact amount of coffee each time it you brew. Other features include a valve water tank, height adjustable drip tray and the new ESE metal filter holder.',66.99,64.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (161,'Saeco - Aroma','This traditional Italian-made espresso machine is a great addition to any kitchen. Featuring a sturdy all-metal body, this machine is designed to last. The steam wand allows you to froth milk quickly and easily, and even dispenses hot water for tea. Create all of your favorite coffee drinks, such as cappuccinos, lattes, and mochas. It includes a pressurized portafilter, making traditional espresso-brewing simple and easy.',40.99,40.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (162,'Saeco - Odea Giro Orange','Part of the new Odea line designed by BMW DesignworksUSA, the Odea Giro features Saeco''s latest innovations including a Giro (dial) interface, ceramic disc grinder, drip tray with manual Touch Lift technology, and OptiDose, to adjust the aroma of your favorite coffee. Thanks to Rapid SteamÃ®, you can use the redesigned steam wand to create delicious frothed milk in just a matter of seconds.',147.99,145.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (163,'Saeco - Talea Touch','Part of the new Talea line designed by BMW DesignworksUSA, the Talea Touch features Saeco''s latest innovations including a large touch screen interface, SBS Saeco Brewing System, ceramic disc grinder and motorized drip tray with Touch Lift technology. This super automatic espresso machine includes Saeco''s Milk Island, an automatic milk frothing device.',152.99,150.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (164,'Saeco - Primea Ring','Designed exclusively by BMW Group DesignworksUSA, the Primea Ring is a masterpiece in design, and the latest in luxury for your home. Thanks to superior innovations in technology, the Primea Ring prepares espresso with a perfect crema, aroma and flavor every time. Fully programmable features, accessed through the click wheel interface, cater to the personal preferences of every coffee lover.',175.99,175.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (165,'Saeco - Royal Coffee Bar','The Royal Coffee Bar, stylish and sleek in silver and graphite, is sure to be an eye catcher in any kitchen or office. With the simple push button technology the machine will grind, tamp, and dispense espresso/coffee with a rich creamy crema. The digital display makes using the Royal Coffee Bar simple to operature, even for a beginner barista. Preset your individual drinks to the amount you desire, then steam milk with the Cappuccinatore, automatic frothing device and you will have a delicious cappuccino or latte.',171.99,169.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (166,'Saeco - Incanto Classic','Part of the Incanto family of automatic machines, the Incanto Classic features innovative Saeco technologies including 2 programmable beverage settings, Saeco OptiDose and built-in burr grinder. With the Saeco Brewing System, or SBS, the Classic makes it easier than ever before to customize and brew espresso at home; and thanks to the Rapid SteamÃ® technology, you can easily froth milk to quickly turn an espresso into a cappuccino or latte.',193.99,191.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (167,'Saeco - Espresso Italiano','Bringing the cafÃ© into your own home has never been easier than with the Espresso Italiano. Just add whole beans and water, and instantly you will have a perfectly extracted espresso. With state-of-the-art technology, including a tri-colored digital display screen that helps to easily identify the machineâs functions, you can make all of your favorite espresso-based drinks, including cappuccino, latte and Americano.',75.99,75.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (168,'Saeco - Spidem Villa','The Villa Silver puts Saecoâs patented removable brew group technology into an easy-to-use interface. You can now make espressos, cappuccinos, lattes, and tea all from one machine that grinds, tamps, and brews gourmet coffee. The pump driven steam and hot water wand has an exclusive Pannarello to make frothing milk simple. The Villaâs adjustable conical burr grinder makes the perfect grind for gourmet coffee.',56.99,56.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (169,'Jura - ENA 5','The new contemporary design is less than 9Ã½ inches wide, freeing up counter space while offering a true bean-to-cup experience. The new rotary switch makes the ENA the easiest to use automatic coffee center. The patent-pending Zero-Energy-Technology uses less electricity than any other coffee center on the market. Created for the coffee enthusiast, the ENA series offers the best in authentic crema coffee, espresso, cappuccino and latte in a flawless, striking design. The ENA series features 18 bars of pressure, a professional-grade conical burr grinder, energy saving technology and a wealth of convenience features.',41.99,39.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (170,'Jura - IMPRESSA S9 One Touch','With the latest and most comprehensive One Touch technology, the Jura-Capresso IMPRESSA S9 One Touch lets you make cappuccino, cafe mocha, latte or latte macchiato with the simple touch of one button, without moving the cup.  It can grind, tamp and brew delicious crema coffee or espresso â in seconds, one or two cups at a time, Ã½ to 16 ounces â fresher than in a coffee bar.  The IMPRESSA S9 One Touch with two stainless steel-lined ThermoBlock heating systems and its large 96 ounce water capacity makes easy work out of espresso based drinks and frothed milk drinks, with no down time.',161.99,159.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (171,'Jura - IMPRESSA J5','The IMPRESSA J5 is Juraâs first compact automatic coffee center expressing a new design philosophy. Smooth, clean lines, elegant accents, and an all-encompassing attention to detail make the J5 an aesthetic masterpiece from any angle. High-end materials, a rich platinum metallic treatment for the front and top with tasteful chrome accents contrast with matte black side panels. A second version features glossy piano white panels recognizing this resurgent kitchen decor option.',172.99,170.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (172,'Jura - IMPRESSA Z5','Beans are ground. Fresh, cold milk transforms into hot, frothed milk and pours into your cup. With high pressure hot water is forced through the perfectly ground and tamped coffee. Now espresso flows through the thick layer of milk froth: pick up your cappuccino and enjoy. In the meantime the used coffee grounds are discarded and you can immediately start dreaming about another cappuccino, latte, espresso or any other hot large cup of crema coffee.',79.99,79.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (173,'Jura - IMPRESSA C9 One Touch','The IMPRESSA C9 One Touch is the most compact One Touch Automatic Coffee Center today.  With the ultimate in user-friendly technology, the C9 One Touch creates a cappuccino, cafe mocha or latte at the touch of one button, without moving the cup.  The insulated 14 oz. thermal stainless steel milk container keeps cold milk cold for up to eight hours, so you can leave the milk right next to the machine. No more running back and forth to the refrigerator.',174.99,172.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (174,'Jura - IMPRESSA Z6','Add luxury to perfection! Grand curved high-gloss chrome plated-plated aluminum front. High-polished mirrored LED display (the LED information shines through the mirror finish). Hand-polished, oversized, drip tray made of die-cast zinc (weighs almost 1.5 lbs!) lets the Z6 shines even more. Custom designed 20 oz. stainless steel thermal milk container keeps cold milk cold for up to eight hours.',190.99,190.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (175,'DeLonghi - Electric Coffee Grinder','4-12 cup (2.36-ounce) ground coffee capacity. Stainless steel grinding blades are durable and long lasting. Grind selector allows you to choose the perfect grind setting from coarse, to medium, to fine - indicated by the 3 green lights.',154.99,152.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (176,'Bodum - Venice','This stylish hand coffee grinder is made of brushed stainless steeel and plastic. It features an adjustable grind control and easy-to-fill container that holds enough beans for an 8 cup BODUM coffee maker. The container has a bayonet cap fitting which is dishwasher safe. The opening on the top slides for easy fill of coffee beans.',180.99,178.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (177,'Bodum - C-Mill','Coffee culture in this country has improved a lot over the last years. Still, what''s not completely understood is what a big difference freshly ground coffee beans make to the taste. It''s the defining element in the coffee brewing process, next to the quality of the beans, the roast, the water, and the coffee maker.',106.99,104.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (178,'Bodum - Antigua','Freshly ground coffee makes all the difference when brewing the perfect cup! Just like professional-grade coffee grinders, BODUMâs Antigua electric coffee grinder features a conical burr grinder that cuts the coffee beans rather than crushing them, preventing the coffee from losing its characteristic taste and aroma.',59.99,57.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (179,'Capresso - Cool Grind Blade Grinder','Our Cool Grind blade grinders are suitable for drips coffee makers and percolators. They also to a great job for grinding spices and herbs. The large stainless steel grinding chamber reduces heat built-up to preserve more aroma.',185.99,183.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (180,'Havaletta - Macchianator','Brass boiler, lines and chromed brass brewing head all maintain and distribute heat to brew the perfect cup of coffee.',445.89,445.89,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (181,'Havaletta - Basic Cup','The basic no frills option. For the person who wants the world to know that they''re drinking coffee, and that doesn''t have mean anything more.',4.99,3.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (182,'Havaletta - Diner Cup','Whether you prefer your greasy eggs with greasy sausage or greasy bacon, this cup will hold your black coffee with a flared top that makes it easier for the waitress to top you off.',5.99,4.99,'N','N','2020-01-01',CURRENT_DATE);
INSERT INTO BLC_SKU (SKU_ID,NAME,DESCRIPTION,RETAIL_PRICE,SALE_PRICE,TAXABLE_FLAG,DISCOUNTABLE_FLAG,ACTIVE_END_DATE,ACTIVE_START_DATE) VALUES (183,'Havaletta - Colored Ceramic Cup','These colored cups are perfect for curling up with a good book on a rainy Saturday morning.',14.99,8.99,'N','N','2020-01-01',CURRENT_DATE);

INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(1,1);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(2,2);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(3,3);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(4,4);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(5,5);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(6,6);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(7,7);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(8,8);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(9,9);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(10,10);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(11,11);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(12,12);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(13,13);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(14,14);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(15,15);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(16,16);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(17,17);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(18,18);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(19,19);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(20,20);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(21,21);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(22,22);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(23,23);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(24,24);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(25,25);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(26,26);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(27,27);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(28,28);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(29,29);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(30,30);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(31,31);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(32,32);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(33,33);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(34,34);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(35,35);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(36,36);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(37,37);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(38,38);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(39,39);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(40,40);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(41,41);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(42,42);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(43,43);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(44,44);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(45,45);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(46,46);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(47,47);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(48,48);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(49,49);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(50,50);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(51,51);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(52,52);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(53,53);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(54,54);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(55,55);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(56,56);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(57,57);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(58,58);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(59,59);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(60,60);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(61,61);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(62,62);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(63,63);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(64,64);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(65,65);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(66,66);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(67,67);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(68,68);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(69,69);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(70,70);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(71,71);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(72,72);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(73,73);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(74,74);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(75,75);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(76,76);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(77,77);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(78,78);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(79,79);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(80,80);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(81,81);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(82,82);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(83,83);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(84,84);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(85,85);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(86,86);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(87,87);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(88,88);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(89,89);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(90,90);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(91,91);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(92,92);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(93,93);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(94,94);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(95,95);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(96,96);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(97,97);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(98,98);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(99,99);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(100,100);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(101,101);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(102,102);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(103,103);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(104,104);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(105,105);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(106,106);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(107,107);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(108,108);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(109,109);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(110,110);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(111,111);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(112,112);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(113,113);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(114,114);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(115,115);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(116,116);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(117,117);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(118,118);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(119,119);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(120,120);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(121,121);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(122,122);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(123,123);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(124,124);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(125,125);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(126,126);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(127,127);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(128,128);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(129,129);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(130,130);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(131,131);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(132,132);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(133,133);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(134,134);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(135,135);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(136,136);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(137,137);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(138,138);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(139,139);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(140,140);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(141,141);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(142,142);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(143,143);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(144,144);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(145,145);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(146,146);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(147,147);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(148,148);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(149,149);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(150,150);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(151,151);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(152,152);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(153,153);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(154,154);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(155,155);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(156,156);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(157,157);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(158,158);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(159,159);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(160,160);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(161,161);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(162,162);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(163,163);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(164,164);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(165,165);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(166,166);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(167,167);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(168,168);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(169,169);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(170,170);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(171,171);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(172,172);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(173,173);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(174,174);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(175,175);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(176,176);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(177,177);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(178,178);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(179,179);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(180,180);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(181,181);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(182,182);
INSERT INTO BLC_PRODUCT_SKU_XREF VALUES(183,183);

INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (1,127,'Manufacturer','DeLonghi',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (2,127,'Product Name','DeLonghi - 10 Cup Drip Coffee Maker',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (3,127,'Description','Seamless brushed aluminum body durable and stylish, it beautifully complements any kitchen décor. Permanent gold-tone filter durable and long-lasting, the gold-tone filter is specially designed to keep even the finest grounds out of your coffee. Ergonomic handle for comfortable use and easy handling.',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (4,127,'Dimensions','15.59 x 7.40 x 14.13',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (5,127,'Weight','6 lb',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (6,127,'Model','DCM900',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (7,127,'Image Name','DCM900.jpg',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (8,128,'Manufacturer','DeLonghi',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (9,128,'Product Name','DeLonghi - 14 Cup Drip Coffee Maker',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (10,128,'Description','24-hour programmable timer is convenient and easy-to-use. Just set the timer the night before, and wake up to the aroma of fresh brewed coffee. Internal water level indicator lets you know how much water is in the tank. Permanent gold-tone filter durable and long lasting, the gold-tone filter is specially designed to keep even the finest grounds out of your coffee.',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (11,128,'Dimensions','8.50 x 9.75 x 12.71',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (12,128,'Weight','8.2 lb',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (13,128,'Model','DC514T',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (14,128,'Image Name','DC514T.jpg',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (15,129,'Manufacturer','DeLonghi',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (16,129,'Product Name','DeLonghi - 12-Cup Drip Coffee Maker w/ Frontal Access',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (17,129,'Description','24-hour programmable digital timer with 2 hour automatic shut-off. Water level indicator lets you know when the unit needs refilling. Permanent gold-tone filter durable and long lasting, the gold-tone filter is specially designed to keep even the finest grounds out of your coffee.',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (18,129,'Dimensions','9.25 x 10.43 x 12.32',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (19,129,'Weight','7.1 lb',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (20,129,'Model','DCF212T',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (21,129,'Image Name','DCF212T.jpg',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (22,130,'Manufacturer','Capresso',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (23,130,'Product Name','Capresso - Coffee Team Therm Grind/Brew Coffeemaker Kit',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (24,130,'Description','Perfect for the brewed coffee connoisseur, the programmable 10-cup capacity Capresso CoffeeTEAM is the only combination machine with a conical burr grinder and a stainless steel thermal carafe. Just pour in the beans, program the time and the amount of coffee to be ground and the brewer does the rest. High quality heating elements assure ideal brewing temperatures of over 200F and approximately 180F in the carafe directly after brewing.',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (25,130,'Dimensions','16 x 12 x 11',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (26,130,'Weight','10 lb',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (27,130,'Model','B108',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (28,130,'Image Name','B108.jpg',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (29,131,'Manufacturer','Capresso',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (30,131,'Product Name','Capresso - MT500 PLUS Coffeemaker Kit',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (31,131,'Description','It''s easy to see why this programmable 10-cup coffee maker was named "2008 Consumers Digest Best Buy". With its beautiful high-gloss alloy body and stainless steel thermal carafe, the Capresso MT500 keeps coffee hot and fresh for up to 4 hours.',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (32,131,'Dimensions','14 x 10 x 10',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (33,131,'Weight','7 lb',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (34,131,'Model','B109',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (35,131,'Image Name','B109.jpg',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (36,132,'Manufacturer','Capresso',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (37,132,'Product Name','Capresso - CoffeeTEC',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (38,132,'Description','Brews 10 5-ounce cups of coffee directly into a stainless-steel vacuum carafe. Virtually unbreakable carafe keeps coffee hot 4 hours without a warming plate. Programmable digital clock/timer for "wake-up" coffee; pour a cup midbrew via 20-second brew-pause. Permanent GoldTone filter eliminates messy paper filters; push-button, swing-out filter holder.',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (39,132,'Dimensions','11 x 11 x 14',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (40,132,'Weight','8 lb',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (41,132,'Model','471',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (42,132,'Image Name','471.jpg',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (43,133,'Manufacturer','Bodum',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (44,133,'Product Name','Bodum - Cafe Solo - Filtre Belgique',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (45,133,'Description','The design of the Filter Belgique is itself done with a "silent attitude", but the product incorporates a high content of design details which make it simple to use and nice to look at. In this way, it stands out from most of the same type of mass-market products. The Filter Belgique design came from the same honest work that so many scarcely noticed everyday essentials emerge from.',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (46,133,'Dimensions','4.5 x 3.8 x 7.4',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (47,133,'Weight','1 lb',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (48,133,'Model','K10461-01',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (49,133,'Image Name','K10461-01.jpg',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (50,134,'Manufacturer','DeLonghi',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (51,134,'Product Name','DeLonghi - Perfecta Fully Automatic Expresso Machine',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (52,134,'Model','ESAM5500M',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (53,134,'Description','Easy to use control panel with digital programmable menu settings allow you to adjust start time, auto shut and off and clock. You can adjust temperature of the coffee and water hardness. Plus, there are five settings for coffee strength: extra-mild, mild, regular, strong, and extra strong. The easy to use rotary control panel allows you to easily choose the size of cup you from small (risretto) to large (American coffee).',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (54,134,'Dimensions','11.14 x 17.52 x 14.88',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (55,134,'Weight','23.2 lb',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (56,134,'Image Name','ESAM5500M.jpg',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (57,135,'Manufacturer','DeLonghi',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (58,135,'Product Name','DeLonghi - Alicia Moka Expresso Maker',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (59,135,'Model','EMK6',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (60,135,'Description','Transparent container allows you to easily monitor the entire brewing process. The container is durable and easy-to-clean. Filter adapter allows you to choose 3 or 6 cups of espresso. Cordless operation with detachable base makes serving simple.',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (61,135,'Dimensions','4.80 x 7.28 x 9.25',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (62,135,'Weight','4 lb',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (63,135,'Image Name','EMK6.jpg',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (64,136,'Manufacturer','DeLonghi',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (65,136,'Product Name','DeLonghi - Magnifica Super Automatic Espresso Machine',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (66,136,'Model','ESAM3300',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (67,136,'Description','What you grind is what you brew. The compact and patented Direct-to-Brew System with Thermo Block technology provides excellent heat distribution and its removable for easy cleaning. The beans are ground instantly to ensure the freshest espresso or coffee.',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (68,136,'Dimensions','11.00 x 15.00 x 14.00',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (69,136,'Weight','26.2 lb',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (70,136,'Image Name','ESAM3300.jpg',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (71,137,'Manufacturer','DeLonghi',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (72,137,'Product Name','DeLonghi - Lattissima - Metal',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (73,137,'Model','EN680M',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (74,137,'Description','Patented IFD system includes a 25 oz. milk container for cappuccino or latte macchiato. It also includes a unique automatic cleaning function with the easy push of a button. Plus, the entire container is detachable, so it can easily be placed in the refrigerator. Amounts of frothed / steamed milk and coffee are adjustable. Cup warming tray is perfect for warm, ready-to-use cups.',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (75,137,'Dimensions','8.00 x 13.50 x 10.00',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (76,137,'Weight','22.4 lb',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (77,137,'Image Name','EN680M.jpg',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (78,138,'Manufacturer','DeLonghi',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (79,138,'Product Name','DeLonghi - Pump Driven Espresso/Cappuccino',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (80,138,'Model','BAR32',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (81,138,'Description','High performance pump pressure delivers rich and savory espresso with crema. Swivel jet frother utilizes dry steam to produce a thick milk froth for cappuccino, latte and hot chocolate. Adjustable steam emission For espresso or cappuccino includes pressure safety valve to ensure safe operation.',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (82,138,'Dimensions','8.07 x 10.24 x 11.81',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (83,138,'Weight','11.2 lb',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (84,138,'Image Name','BAR32.jpg',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (85,139,'Manufacturer','DeLonghi',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (86,139,'Product Name','DeLonghi - Magnifica Digital Auto Espresso/Cappuccino Machine',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (87,139,'Model','ESAM3500',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (88,139,'Description','Digital programmable menu settingsallow you to adjust start time, auto shut-off and clock. You can adjust temperature of the coffee and water hardness. Plus, there are five settings for coffee strength: extra-mild, mild, regular, strong, and extra strong. Three buttons allow you to easily choose the size of cup you want: ristretto (small), espresso (medium) and large (American coffee). The three settings can be customized to your preferred taste.',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (89,139,'Dimensions','11 x 15 x 14',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (90,139,'Weight','31 lb',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (91,139,'Image Name','ESAM3500.jpg',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (92,140,'Manufacturer','Pasquini',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (93,140,'Product Name','Pasquini - Livia Automatic Espresso Machine Kit',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (94,140,'Model','E406',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (95,140,'Description','The ultimate gift for the discriminating espresso connoisseur and home barista, the Livia 90 Automatic is the top-of-the-line commercial-grade automatic home machine. This extraordinary machine has all the benefits of the Livia 90 with the added convenience of automatic espresso extraction settings and use of E.S.E. Servings (pods).',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (96,140,'Dimensions','12.25 x 11.5 x 15',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (97,140,'Weight','50 lb',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (98,140,'Image Name','E406.jpg',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (99,141,'Manufacturer','Illy',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (100,141,'Product Name','Illy - Francis Francis X1 Ground Espresso Machine Kit',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (101,141,'Model','E410',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (102,141,'Description','Ideal for connoisseurs who love preparing authentic espresso the traditional way, the X1 Ground features new state-of-the-art electronics and automatic boiler refill. Featuring all new electronics and updated controls, this retro-futuristic espresso machine designed by Italian architect Luca Trazzi comes in a handsome finish that makes a bold statement in any kitchen.',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (103,141,'Dimensions','12.5 x 10.5 x 9.5',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (104,141,'Weight','15.4 lb',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (105,141,'Image Name','E410.jpg',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (106,142,'Manufacturer','Illy',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (107,142,'Product Name','Illy - Francis Francis X3 Espresso Machine Kit',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (108,142,'Model','E301',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (109,142,'Description','A creation of renowned Italian architect Luca Trazzithis sleek, compact Francis Francis X3 espresso machine is designed for coffee lovers who may be more cost-conscious or have limited kitchen space but don''t want to sacrifice quality or aesthetics. It makes perfect espresso with illy''s Easy Serving Espresso (E.S.E.) system.',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (110,142,'Dimensions','11.5 x 6 x 10 1/2',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (111,142,'Weight','13.2 lb',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (112,142,'Image Name','E301.jpg',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (113,143,'Manufacturer','Illy',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (114,143,'Product Name','Illy - Francis Francis X1 Trio Espresso Machine Kit',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (115,143,'Model','E409',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (116,143,'Description','Enjoy the pleasure of espresso three ways with the new Francis Francis X1 Trio featuring advanced trio technology for ristretto (short), espresso and espresso lungo with a turn of the brewing handle. Combining state-of-the-art electronics with the world famous, retro-futuristic design by Italian architect Luca Trazzi, the X1 Trio makes it easier than ever to prepare expert espresso and cappuccino each and every time.',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (117,143,'Dimensions','13 x 9.85 x 10.25',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (118,143,'Weight','15.43 lb',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (119,143,'Image Name','E409.jpg',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (120,144,'Manufacturer','Gaggia',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (121,144,'Product Name','Gaggia - Classic Espresso Machine Kit',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (122,144,'Model','E400',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (123,144,'Description','The Classic is Italian espresso machine manufacturer Gaggia''s top of the line machine for home baristas. Loaded with commercial-quality components, the Classic is encased in a handsome and durable solid brushed stainless steel housing.',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (124,144,'Dimensions','14.25 x 8 x 9.5',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (125,144,'Weight','17 lb',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (126,144,'Image Name','E400.jpg',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (127,145,'Manufacturer','Jura',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (128,145,'Product Name','Jura - Capresso Impressa Z5 Espresso Machine Kit',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (129,145,'Model','E412',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (130,145,'Description','This super automatic espresso machine lets you go from whole beans to superb espresso and any size cappuccino or latte with one-touch convenience. Programmable brewing buttons let you select your coffees size, strength and temperature. Built-in commercial burr grinder is extremely low-noise, making the Impressa Z5 the quietest automatic coffee center on the market today',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (131,145,'Dimensions','14.5 x 12.2 x 17.1',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (132,145,'Weight','30 lb',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (133,145,'Image Name','E412.jpg',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (134,146,'Manufacturer','Pasquini',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (135,146,'Product Name','Pasquini - Livietta Espresso Machine Kit',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (136,146,'Model','E408',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (137,146,'Description','Compact and semi-automatic, Pasquini''s latest commercial machine for the home fits beautifully in almost any size kitchen. New thermoblock technology lets you steam milk and brew espresso at the same timemaking it ideal for entertaining. Use with illy E.S.E. pods or ground coffee.',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (138,146,'Dimensions','12.5 x 8.5 x 14.25',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (139,146,'Weight','23 lb',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (140,146,'Image Name','E408.jpg',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (141,147,'Manufacturer','Gaggia',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (142,147,'Product Name','Gaggia - Titanium Espresso Machine Kit',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (143,147,'Model','E407',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (144,147,'Description','This super automatic, all-in-one home caf machine makes espresso, cappuccino and latte almost instantly. Fully programmable with three brewing buttons to dispense any amount of coffee you like, plus a built-in professional burr grinder and two superb frothers, the Titanium will grind your beans, tamp, brew and discard the grounds, all at the touch of a button.',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (145,147,'Dimensions','14.75 x 11.5 x 16.75',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (146,147,'Weight','22 lb',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (147,147,'Image Name','E407.jpg',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (148,148,'Manufacturer','Saeco',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (149,148,'Product Name','Saeco - Magic Cappuccino Espresso Machine Kit',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (150,148,'Model','E413',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (151,148,'Description','This is a terrific machine that uses a patented nickel plated brass pressurized portfilter to ensure a great espresso extraction. It works by pressurizing the brewing chamber through a small spring-loaded valve located below the filter basket. The valve remains closed until enough pressure builds to open it and release the espresso.',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (152,148,'Dimensions','16.75 x 11.5 x 13.25',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (153,148,'Weight','13.5 lb',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (154,148,'Image Name','E413.jpg',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (155,149,'Manufacturer','Gaggia',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (156,149,'Product Name','Gaggia - Evolution Espresso Machine Kit',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (157,149,'Model','E401',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (158,149,'Description','The silver and chrome Gaggia Evolution espresso machine has a high-end look that speaks proudly of its Italian heritage. Featuring many commercial-quality components, the Evolution is an excellent mid-range espresso machine choice for the home.',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (159,149,'Dimensions','13.4 x 8.7 x 10.6',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (160,149,'Weight','15 lb',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (161,149,'Image Name','E401.jpg',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (162,150,'Manufacturer','Saeco',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (163,150,'Product Name','Saeco - Magic Cappuccino Espresso Machine Kit',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (164,150,'Model','E413',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (165,150,'Description','This is a terrific machine that uses a patented nickel plated brass pressurized portfilter to ensure a great espresso extraction. It works by pressurizing the brewing chamber through a small spring-loaded valve located below the filter basket. The valve remains closed until enough pressure builds to open it and release the espresso. The high pressure results in an optimal extraction of the coffee flavor and aroma, making a delicious espresso with a thick golden crema.',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (166,150,'Dimensions','16.75 x 11.5 x 13.25',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (167,150,'Weight','13.5 lb',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (168,150,'Image Name','E413.jpg',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (169,151,'Manufacturer','Pasquini',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (170,151,'Product Name','Pasquini - Livia 90P Espresso Machine Kit',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (171,151,'Model','E405',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (172,151,'Description','The ultimate gift for the discriminating espresso connoisseur and home barista. This kit includes the Pasquini Livia 90, the top-of-the-line espesso machine whose commercial-grade quality and design make it the very best semi-automatic home machine worldwide. With sturdy commercial components from Pasquini''s acclaimed professional line, the Livia 90 can steam milk and brew coffee simultaneously, making outstanding Italian espresso and cappuccino every time. Pasquini stainless base also available.',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (173,151,'Dimensions','12.25 x 11.5 x 15',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (174,151,'Weight','50 lb',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (175,151,'Image Name','E405.jpg',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (176,152,'Manufacturer','Kitchenaid',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (177,152,'Product Name','Kitchenaid - ProLine Espresso Machine Kit',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (178,152,'Model','E402',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (179,152,'Description','The Kitchenaid Pro Line is a high-performance professional espresso machine designed for the home. Based on models used in Italian coffee bars, this stylish commercial-grade machine has dual boilers that let you brew espresso and steam milk with no downtime, making the Pro Line supberb for home entertaining. Use with ground coffee or illy''s E.S.E. servings (pods).',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (180,152,'Dimensions','16 x 12.4 x 12.5',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (181,152,'Weight','29.9 lb',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (182,152,'Image Name','E402.jpg',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (183,153,'Manufacturer','Illy',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (184,153,'Product Name','Illy - FrancisFrancis X6 Trio Espresso Machine Kit',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (185,153,'Model','E304',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (186,153,'Description','From renowned Italian espresso machine maker francis francis and architect Luca Trazzi, the X6 features an 18 Bar pressure pump and unique Trio Technology that makes three espresso preparations: short (ristretto), normal(espresso) and long (espresso lungo). With quality all-brass boiler and brewing components, the X6 is designed to work exclusively with E.S.E. Servings (pods) for perfectly measured and tamped espresso every time. And the stylish retro-contemporary design makes a strong visual statement in any kitchen.',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (187,153,'Dimensions','12.5 x 10.5 x 9.5',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (188,153,'Weight','13.2 lb',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (189,153,'Image Name','E304.jpg',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (190,154,'Manufacturer','Illy',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (191,154,'Product Name','Illy - FrancisFrancis X8 iperEspresso Machine Kit',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (192,154,'Model','E309',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (193,154,'Description','Designed to work exclusively with illy iperEspresso capsules, the state-of-the-art Francis Francis X8 iperEspresso machine makes extraordinary espresso with one-touch convenience. Unlike conventional one-stage systems, the iperEspresso method uses an innovative, patented two-stage process to create intensely aromatic, full-bodied espresso with rich, velvety crema that lasts and lasts. And because extraction takes place entirely inside the capsule, the coffee and machine never come in contact making for easy clean up.',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (194,154,'Dimensions','12.6 x 7.9 x 13.4',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (195,154,'Weight','13.3 lb',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (196,154,'Image Name','E309.jpg',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (197,155,'Manufacturer','Illy',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (198,155,'Product Name','Illy - FrancisFrancis X7 iperEspresso Machine Kit',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (199,155,'Model','E307',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (200,155,'Description','Designed to work exclusively with illy iperEspresso capsules, the striking Francis Francis X7 makes extraordinary espresso with one-touch convenience. Unlike conventional one-stage systems, the iperEspresso method uses an innovative, patented two-stage process to create intensely aromatic, full-bodied espresso with rich, velvety crema that lasts and lasts. And because extraction takes place entirely inside the capsule, the coffee and machine never come in contact making for easy clean up.',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (201,155,'Dimensions','12.2 x 11 x 13.2',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (202,155,'Weight','13.2 lb',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (203,155,'Image Name','E307.jpg',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (204,156,'Manufacturer','DeLonghi',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (205,156,'Product Name','DeLonghi - Magnifica Super Automatic Espresso Machine Kit',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (206,156,'Model','E414',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (207,156,'Description','The Delonghi Magnifica lets you brew fresh, aromatic espresso or coffee from beans freshly ground in the professional-quality, lower-pitch conical burr grinder. What you grind is what you brew. The compact and patented Direct-to-Brew System with Thermo Block technology provides excellent heat distribution and its removable for easy cleaning. Double boiler with new stainless steel piped espresso boiler -no longer wait between espresso and steam.',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (208,156,'Dimensions','14 x 11 x 15',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (209,156,'Weight','21 lb',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (210,156,'Image Name','E414.jpg',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (211,157,'Manufacturer','Saeco',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (212,157,'Product Name','Saeco - Odea Giro Super Automatic Espresso Machine kit',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (213,157,'Model','E411',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (214,157,'Description','Designed by BMW DesignworksUSA, the new Saeco Odea super automatic espresso machine lets you easily brew high-quality espresso and cappuccino at home. Featuring Saeco''s innovative Giro interface display with simplified programming, this super automatic starts with whole bean coffee and automatically grinds, tamps, doses and brews. Intuitive controls let you select the type of drink you want, your coffee strength (mild, medium, strong) and number of servings.',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (215,157,'Dimensions','14.5 x 11.5 x 15',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (216,157,'Weight','19 lb',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (217,157,'Image Name','E411.jpg',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (218,158,'Manufacturer','Saeco',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (219,158,'Product Name','Saeco - Nina Cappuccino',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (220,158,'Model','Nina Cappuccino',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (221,158,'Description','The mid-level machine in the Nina line, Nina Cappuccino features a cappuccinatore automatic frothing device that allows you to quickly and easily make delicious cappuccinos and lattes. It also stands out from the rest of the line with its beige exterior color. Other features include a valve water tank, height adjustable drip tray and the new ESE metal filter holder.',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (222,158,'Dimensions','11 x 12 x 14',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (223,158,'Weight','9 lb',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (224,158,'Image Name','Nina-Cappuccino.jpg',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (225,159,'Manufacturer','Saeco',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (226,159,'Product Name','Saeco - Magic Cappuccino Plus',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (227,159,'Model','Magic Cappuccino Plus',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (228,159,'Description','The Magic Cappuccino Plus is a combination of elegant style, with its stately silver color, and durable commercial characteristics. This unit has been a long time favorite due to sturdy construction and ease of use. This traditional pump driven espresso machine makes perfect espresso, cappuccino and lattes every time. The electric pump system and unique pressurized portafilter enable the user to make a perfect cup of espresso without being an expert barista',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (229,159,'Dimensions','9.5 x 11 x 14',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (230,159,'Weight','13.5 lb',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (231,159,'Image Name','Magic-Cappuccino-Plus.jpg',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (232,160,'Manufacturer','Saeco',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (233,160,'Product Name','Saeco - Nina Bar',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (234,160,'Model','Nina Bar',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (235,160,'Description','The top level machine in the Nina line, Nina Bar features an innovative new interface that allows for more brewing control. With the push of a button you can program the electronic dosing system and control the amount of coffee brewed. Once programming is complete, the coffee buttons will dose the exact amount of coffee each time it you brew. Other features include a valve water tank, height adjustable drip tray and the new ESE metal filter holder.',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (236,160,'Dimensions','11 x 12 x 14',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (237,160,'Weight','9 lb',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (238,160,'Image Name','Nina-Bar.jpg',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (239,161,'Manufacturer','Saeco',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (240,161,'Product Name','Saeco - Aroma',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (241,161,'Model','Aroma',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (242,161,'Description','This traditional Italian-made espresso machine is a great addition to any kitchen. Featuring a sturdy all-metal body, this machine is designed to last. The steam wand allows you to froth milk quickly and easily, and even dispenses hot water for tea. Create all of your favorite coffee drinks, such as cappuccinos, lattes, and mochas. It includes a pressurized portafilter, making traditional espresso-brewing simple and easy.',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (243,161,'Dimensions','8 x 10 x 11.75',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (244,161,'Weight','14 lb',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (245,161,'Image Name','Aroma.jpg',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (246,162,'Manufacturer','Saeco',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (247,162,'Product Name','Saeco - Odea Giro Orange',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (248,162,'Model','Odea Giro Orange',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (249,162,'Description','Part of the new Odea line designed by BMW DesignworksUSA, the Odea Giro features Saeco''s latest innovations including a Giro (dial) interface, ceramic disc grinder, drip tray with manual Touch Lift technology, and OptiDose, to adjust the aroma of your favorite coffee. Thanks to Rapid Steam, you can use the redesigned steam wand to create delicious frothed milk in just a matter of seconds.',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (250,162,'Dimensions','11.5 x 15 x 14.5',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (251,162,'Weight','19 lb',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (252,162,'Image Name','Odea-Giro-Orange.jpg',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (253,163,'Manufacturer','Saeco',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (254,163,'Product Name','Saeco - Talea Touch',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (255,163,'Model','Talea Touch',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (256,163,'Description','Part of the new Talea line designed by BMW DesignworksUSA, the Talea Touch features Saeco''s latest innovations including a large touch screen interface, SBS Saeco Brewing System, ceramic disc grinder and motorized drip tray with Touch Lift technology. This super automatic espresso machine includes Saeco''s Milk Island, an automatic milk frothing device.',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (257,163,'Dimensions','13 x 16 x 14.5',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (258,163,'Weight','21 lb',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (259,163,'Image Name','Talea-Touch.jpg',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (260,164,'Manufacturer','Saeco',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (261,164,'Product Name','Saeco - Primea Ring',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (262,164,'Model','Primea Ring',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (263,164,'Description','Designed exclusively by BMW Group DesignworksUSA, the Primea Ring is a masterpiece in design, and the latest in luxury for your home. Thanks to superior innovations in technology, the Primea Ring prepares espresso with a perfect crema, aroma and flavor every time. Fully programmable features, accessed through the click wheel interface, cater to the personal preferences of every coffee lover.',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (264,164,'Dimensions','14 x 18 x 15',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (265,164,'Weight','33 lb',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (266,164,'Image Name','Primea-Ring.jpg',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (267,165,'Manufacturer','Saeco',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (268,165,'Product Name','Saeco - Royal Coffee Bar',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (269,165,'Model','Royal Coffee Bar',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (270,165,'Description','The Royal Coffee Bar, stylish and sleek in silver and graphite, is sure to be an eye catcher in any kitchen or office. With the simple push button technology the machine will grind, tamp, and dispense espresso/coffee with a rich creamy crema. The digital display makes using the Royal Coffee Bar simple to operature, even for a beginner barista. Preset your individual drinks to the amount you desire, then steam milk with the Cappuccinatore, automatic frothing device and you will have a delicious cappuccino or latte.',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (271,165,'Dimensions','15.25 x 17.5 x 15.75',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (272,165,'Weight','31.5 lb',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (273,165,'Image Name','Royal-Coffee-Bar.jpg',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (274,166,'Manufacturer','Saeco',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (275,166,'Product Name','Saeco - Incanto Classic',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (276,166,'Model','Incanto Classic',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (277,166,'Description','Part of the Incanto family of automatic machines, the Incanto Classic features innovative Saeco technologies including 2 programmable beverage settings, Saeco OptiDose and built-in burr grinder. With the Saeco Brewing System, or SBS, the Classic makes it easier than ever before to customize and brew espresso at home; and thanks to the Rapid Steam technology, you can easily froth milk to quickly turn an espresso into a cappuccino or latte.',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (278,166,'Dimensions','12 x 15.5 x 15',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (279,166,'Weight','26 lb',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (280,166,'Image Name','Incanto-Classic.jpg',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (281,167,'Manufacturer','Saeco',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (282,167,'Product Name','Saeco - Espresso Italiano',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (283,167,'Model','Espresso Italiano',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (284,167,'Description','Bringing the caf into your own home has never been easier than with the Espresso Italiano. Just add whole beans and water, and instantly you will have a perfectly extracted espresso. With state-of-the-art technology, including a tri-colored digital display screen that helps to easily identify the machines functions, you can make all of your favorite espresso-based drinks, including cappuccino, latte and Americano.',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (285,167,'Dimensions','13 x 19 x 14.5',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (286,167,'Weight','20 lb',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (287,167,'Image Name','Espresso-Italiano.jpg',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (288,168,'Manufacturer','Saeco',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (289,168,'Product Name','Saeco - Spidem Villa',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (290,168,'Model','Spidem Villa',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (291,168,'Description','The Villa Silver puts Saecos patented removable brew group technology into an easy-to-use interface. You can now make espressos, cappuccinos, lattes, and tea all from one machine that grinds, tamps, and brews gourmet coffee. The pump driven steam and hot water wand has an exclusive Pannarello to make frothing milk simple. The Villas adjustable conical burr grinder makes the perfect grind for gourmet coffee.',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (292,168,'Dimensions','15 x 14 x 15.5',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (293,168,'Weight','18 lb',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (294,168,'Image Name','Spidem-Villa.jpg',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (295,169,'Manufacturer','Jura',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (296,169,'Product Name','Jura - ENA 5',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (297,169,'Model','13442',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (298,169,'Description','The new contemporary design is less than 9 inches wide, freeing up counter space while offering a true bean-to-cup experience. The new rotary switch makes the ENA the easiest to use automatic coffee center. The patent-pending Zero-Energy-Technology uses less electricity than any other coffee center on the market. Created for the coffee enthusiast, the ENA series offers the best in authentic crema coffee, espresso, cappuccino and latte in a flawless, striking design. The ENA series features 18 bars of pressure, a professional-grade conical burr grinder, energy saving technology and a wealth of convenience features.',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (299,169,'Dimensions','14 x 9 x 17',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (300,169,'Weight','20 lb',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (301,169,'Image Name','13442.jpg',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (302,170,'Manufacturer','Jura',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (303,170,'Product Name','Jura - IMPRESSA S9 One Touch',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (304,170,'Model','13423',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (305,170,'Description','With the latest and most comprehensive One Touch technology, the Jura-Capresso IMPRESSA S9 One Touch lets you make cappuccino, caf mocha, latte or latte macchiato with the simple touch of one button, without moving the cup.  It can grind, tamp and brew delicious crema coffee or espresso  in seconds, one or two cups at a time,  to 16 ounces  fresher than in a coffee bar.  The IMPRESSA S9 One Touch with two stainless steel-lined ThermoBlock heating systems and its large 96 ounce water capacity makes easy work out of espresso based drinks and frothed milk drinks, with no down time.',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (306,170,'Dimensions','14.75 x 13.5 x 15',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (307,170,'Weight','27 lb',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (308,170,'Image Name','13423.jpg',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (309,171,'Manufacturer','Jura',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (310,171,'Product Name','Jura - IMPRESSA J5',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (311,171,'Model','13333',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (312,171,'Description','The IMPRESSA J5 is Juras first compact automatic coffee center expressing a new design philosophy. Smooth, clean lines, elegant accents, and an all-encompassing attention to detail make the J5 an aesthetic masterpiece from any angle. High-end materials, a rich platinum metallic treatment for the front and top with tasteful chrome accents contrast with matte black side panels. A second version features glossy piano white panels recognizing this resurgent kitchen dcor option.',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (313,171,'Dimensions','13.6 x 11 x 17.1',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (314,171,'Weight','22 lb',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (315,171,'Image Name','13333.jpg',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (316,172,'Manufacturer','Jura',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (317,172,'Product Name','Jura - IMPRESSA Z5',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (318,172,'Model','13339',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (319,172,'Description','Beans are ground. Fresh, cold milk transforms into hot, frothed milk and pours into your cup. With high pressure hot water is forced through the perfectly ground and tamped coffee. Now espresso flows through the thick layer of milk froth: pick up your cappuccino and enjoy. In the meantime the used coffee grounds are discarded and you can immediately start dreaming about another cappuccino, latte, espresso or any other hot large cup of crema coffee.',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (320,172,'Dimensions','12.2 x 14.5 x 17.1',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (321,172,'Weight','30 lb',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (322,172,'Image Name','13339.jpg',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (323,173,'Manufacturer','Jura',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (324,173,'Product Name','Jura - IMPRESSA C9 One Touch',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (325,173,'Model','13422',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (326,173,'Description','The IMPRESSA C9 One Touch is the most compact One Touch Automatic Coffee Center today.  With the ultimate in user-friendly technology, the C9 One Touch creates a cappuccino, caf mocha or latte at the touch of one button, without moving the cup.  The insulated 14 oz. thermal stainless steel milk container keeps cold milk cold for up to eight hours, so you can leave the milk right next to the machine. No more running back and forth to the refrigerator.',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (327,173,'Dimensions','13.5 x 11 x 16',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (328,173,'Weight','21 lb',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (329,173,'Image Name','13422.jpg',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (330,174,'Manufacturer','Jura',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (331,174,'Product Name','Jura - IMPRESSA Z6',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (332,174,'Model','13299',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (333,174,'Description','Add luxury to perfection! Grand curved high-gloss chrome plated-plated aluminum front. High-polished mirrored LED display (the LED information shines through the mirror finish). Hand-polished, oversized, drip tray made of die-cast zinc (weighs almost 1.5 lbs!) lets the Z6 shines even more. Custom designed 20 oz. stainless steel thermal milk container keeps cold milk cold for up to eight hours.',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (334,174,'Dimensions','12.2 x 14.5 x 17.1',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (335,174,'Weight','31.5 lb',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (336,174,'Image Name','13299.jpg',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (337,175,'Manufacturer','DeLonghi',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (338,175,'Product Name','DeLonghi - Electric Coffee Grinder',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (339,175,'Model','DCG39',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (340,175,'Description','4-12 cup (2.36-ounce) ground coffee capacity. Stainless steel grinding blades are durable and long lasting. Grind selector allows you to choose the perfect grind setting from coarse, to medium, to fine - indicated by the 3 green lights.',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (341,175,'Dimensions','4.13 x 4.53 x 8.58',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (342,175,'Weight','3 lb',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (343,175,'Image Name','dcg39.jpg',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (344,176,'Manufacturer','Bodum',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (345,176,'Product Name','Bodum - Venice',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (346,176,'Model','0429-10',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (347,176,'Description','This stylish hand coffee grinder is made of brushed stainless steeel and plastic. It features an adjustable grind control and easy-to-fill container that holds enough beans for an 8 cup BODUM coffee maker. The container has a bayonet cap fitting which is dishwasher safe. The opening on the top slides for easy fill of coffee beans.',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (348,176,'Dimensions','6.1 x 4.5 x 8.5',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (349,176,'Weight','1.5 lb',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (350,176,'Image Name','0429-10.jpg',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (351,177,'Manufacturer','Bodum',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (352,177,'Product Name','Bodum - C-Mill',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (353,177,'Model','5679-01US',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (354,177,'Description','Coffee culture in this country has improved a lot over the last years. Still, what''s not completely understood is what a big difference freshly ground coffee beans make to the taste. It''s the defining element in the coffee brewing process, next to the quality of the beans, the roast, the water, and the coffee maker.',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (355,177,'Dimensions','N/A',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (356,177,'Weight','4 lb',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (357,177,'Image Name','5679-01US.jpg',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (358,178,'Manufacturer','Bodum',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (359,178,'Product Name','Bodum - Antigua',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (360,178,'Model','10462-01USA',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (361,178,'Description','Freshly ground coffee makes all the difference when brewing the perfect cup! Just like professional-grade coffee grinders, BODUMs Antigua electric coffee grinder features a conical burr grinder that cuts the coffee beans rather than crushing them, preventing the coffee from losing its characteristic taste and aroma.',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (362,178,'Dimensions','N/A',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (363,178,'Weight','7 lb',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (364,178,'Image Name','10462-01USA.jpg',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (365,179,'Manufacturer','Capresso',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (366,179,'Product Name','Capresso - Cool Grind Blade Grinder',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (367,179,'Model','503',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (368,179,'Description','Our Cool Grind blade grinders are suitable for drips coffee makers and percolators. They also to a great job for grinding spices and herbs. The large stainless steel grinding chamber reduces heat built-up to preserve more aroma.',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (369,179,'Dimensions','8 x 4 x 4',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (370,179,'Weight','2 lb',1);
INSERT INTO BLC_PRODUCT_ATTRIBUTE (PRODUCT_ATTRIBUTE_ID, PRODUCT_ID, NAME, VALUE, SEARCHABLE) VALUES (371,179,'Image Name','503.jpg',1);

INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (1,'/images/products/large/yuban_original.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (2,'/images/products/large/yuban_dark_roast.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (3,'/images/products/large/yuban_decaffinated.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (4,'/images/products/large/eightOClock_original.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (5,'/images/products/large/eightOClock_50decaf.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (6,'/images/products/large/eightOClock_mocha.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (7,'/images/products/large/eightOClock_bokar.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (8,'/images/products/large/eightOClock_decafOriginal.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (9,'/images/products/large/eightOClock_frenchVanilla.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (10,'/images/products/large/eightOClock_frenchRoast.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (11,'/images/products/large/eightOClock_columbian.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (12,'/images/products/large/eightOClock_hazelnut.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (13,'/images/products/large/eightOClock_darkItalian.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (14,'/images/products/large/eightOClock_decafColumbian.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (15,'/images/products/large/seattle_beachHouse.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (16,'/images/products/large/seattle_bestBlend.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (17,'/images/products/large/seattle_henrysBlend.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (18,'/images/products/large/seattle_6thAvenueBistroBlend.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (19,'/images/products/large/seattle_almondRoca.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (20,'/images/products/large/seattle_cinnabon.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (21,'/images/products/large/seattle_colombian.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (22,'/images/products/large/seattle_cremeBrulee.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (23,'/images/products/large/seattle_organicFairTrade.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (24,'/images/products/large/seattle_hazelnut.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (25,'/images/products/large/seattle_breakfastBlend.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (26,'/images/products/large/seattle_organicHouseBlend.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (27,'/images/products/large/seattle_organicSumatra.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (28,'/images/products/large/seattle_portside.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (29,'/images/products/large/seattle_postAlleyBlend.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (30,'/images/products/large/seattle_saturdaysBlend.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (31,'/images/products/large/seattle_vanillaBean.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (32,'/images/products/large/millstone_breakfastBlend.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (33,'/images/products/large/millstone_colombianMedium.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (34,'/images/products/large/millstone_bedBreakfast.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (35,'/images/products/large/millstone_espresso.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (36,'/images/products/large/millstone_organicPeruvian.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (37,'/images/products/large/millstone_organicMayan.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (38,'/images/products/large/millstone_organicMountain.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (39,'/images/products/large/millstone_organicNicaraguan.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (40,'/images/products/large/millstone_organicRainforest.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (41,'/images/products/large/millstone_caramelTruffle.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (42,'/images/products/large/millstone_chocolateVelvet.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (43,'/images/products/large/millstone_cinnamonHazelnut.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (44,'/images/products/large/millstone_caramelTruffleDecaf.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (45,'/images/products/large/millstone_chocolateDecaf.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (46,'/images/products/large/millstone_frenchVanillaDecaf.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (47,'/images/products/large/millstone_hazelnutDecafWhole.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (48,'/images/products/large/millstone_frenchVanilla.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (49,'/images/products/large/millstone_hazelnutWhole.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (50,'/images/products/large/millstone_hazelnutGround.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (51,'/images/products/large/millstone_hazelnutDecafGround.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (52,'/images/products/large/millstone_raspberriesNCream.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (53,'/images/products/large/millstone_swissChocolate.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (54,'/images/products/large/millstone_vanillaNut.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (55,'/images/products/large/chock_columbian.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (56,'/images/products/large/chock_columbianDecaf.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (57,'/images/products/large/chock_city.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (58,'/images/products/large/chock_frenchRoast.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (59,'/images/products/large/chock_frenchRoastDecaf.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (60,'/images/products/large/chock_nyRoast.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (61,'/images/products/large/chock_original.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (62,'/images/products/large/chock_originalDecaf.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (63,'/images/products/large/chock_hazelnut.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (64,'/images/products/large/chock_brick.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (65,'/images/products/large/chock_soho.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (66,'/images/products/large/chock_westSideEuropean.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (67,'/images/products/large/chock_westSideEuropeanDecaf.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (68,'/images/products/large/chock_midtownFrench.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (69,'/images/products/large/chock_greenwich.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (70,'/images/products/large/maxwell_darkRoast.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (71,'/images/products/large/maxwell_columbianSupreme.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (72,'/images/products/large/maxwell_frenchRoast.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (73,'/images/products/large/maxwell_southPacific.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (74,'/images/products/large/maxwell_slowRoast.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (75,'/images/products/large/maxwell_original.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (76,'/images/products/large/maxwell_lite.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (77,'/images/products/large/maxwell_masterBlend.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (78,'/images/products/large/maxwell_breakfastBlend.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (79,'/images/products/large/maxwell_originalDecaf.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (80,'/images/products/large/maxwell_frenchRoastDecaf.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (81,'/images/products/large/maxwell_masterBlendDecaf.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (82,'/images/products/large/maxwell_vanilla.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (83,'/images/products/large/maxwell_hazelnut.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (84,'/images/products/large/maxwell_originalInstant.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (85,'/images/products/large/maxwell_decafInstant.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (86,'/images/products/large/maxwell_sankaInstant.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (87,'/images/products/large/maxwell_coffeeSingles.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (88,'/images/products/large/folgers_classicRoast.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (89,'/images/products/large/folgers_specialRoast.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (90,'/images/products/large/folgers_classicRoastDecaf.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (91,'/images/products/large/folgers_bistroBlend.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (92,'/images/products/large/folgers_hazelnutCreme.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (93,'/images/products/large/folgers_vanillaBiscotti.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (94,'/images/products/large/folgers_chocolateTruffle.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (95,'/images/products/large/folgers_cremeBrulee.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (96,'/images/products/large/folgers_caramelDrizzle.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (97,'/images/products/large/folgers_morningCafe.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (98,'/images/products/large/folgers_livelyColombian.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (99,'/images/products/large/folgers_brazilianBlend.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (100,'/images/products/large/folgers_boldJava.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (101,'/images/products/large/starbucks_arabianMochaSanani.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (102,'/images/products/large/starbucks_brazil.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (103,'/images/products/large/starbucks_bellaVista.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (104,'/images/products/large/starbucks_breakfastBlend.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (105,'/images/products/large/starbucks_guatemalaAntigua.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (106,'/images/products/large/starbucks_guatemalaCasiCielo.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (107,'/images/products/large/starbucks_houseBlend.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (108,'/images/products/large/starbucks_decafHouseBlend.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (109,'/images/products/large/starbucks_organicShadeGrown.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (110,'/images/products/large/starbucks_colombianNarino.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (111,'/images/products/large/starbucks_kenya.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (112,'/images/products/large/starbucks_ethiopiaSidamo.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (113,'/images/products/large/starbucks_sumatra.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (114,'/images/products/large/starbucks_komodoDragon.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (115,'/images/products/large/starbucks_decafSumatra.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (116,'/images/products/large/starbucks_cafeEstima.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (117,'/images/products/large/starbucks_caffeVerona.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (118,'/images/products/large/starbucks_caffeVeronaDecaf.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (119,'/images/products/large/starbucks_goldCoastBlend.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (120,'/images/products/large/starbucks_organicSerenaBlend.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (121,'/images/products/large/starbucks_espressoRoast.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (122,'/images/products/large/starbucks_decafEspressoRoast.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (123,'/images/products/large/starbucks_frenchRoast.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (124,'/images/products/large/starbucks_italianRoast.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (125,'/images/products/large/starbucks_pikePlaceRoast.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (126,'/images/products/large/starbucks_decafPikePlaceRoast.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (127,'/images/products/large/dcm900.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (128,'/images/products/large/dc514t.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (129,'/images/products/large/dcf212t.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (130,'/images/products/large/b108.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (131,'/images/products/large/b109.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (132,'/images/products/large/471.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (133,'/images/products/large/k10461-01.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (134,'/images/products/large/esam5500m.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (135,'/images/products/large/emk6.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (136,'/images/products/large/esam3300.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (137,'/images/products/large/en680m.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (138,'/images/products/large/bar32.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (139,'/images/products/large/esam3500.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (140,'/images/products/large/e406.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (141,'/images/products/large/e410.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (142,'/images/products/large/e301.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (143,'/images/products/large/e409.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (144,'/images/products/large/e400.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (145,'/images/products/large/e412.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (146,'/images/products/large/e408.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (147,'/images/products/large/e407.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (148,'/images/products/large/e413.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (149,'/images/products/large/e401.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (150,'/images/products/large/e413.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (151,'/images/products/large/e405.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (152,'/images/products/large/e402.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (153,'/images/products/large/e304.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (154,'/images/products/large/e309.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (155,'/images/products/large/e307.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (156,'/images/products/large/e414.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (157,'/images/products/large/e411.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (158,'/images/products/large/nina-cappuccino.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (159,'/images/products/large/magic-cappuccino-plus.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (160,'/images/products/large/nina-bar.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (161,'/images/products/large/aroma.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (162,'/images/products/large/odea-giro-orange.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (163,'/images/products/large/talea-touch.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (164,'/images/products/large/primea-ring.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (165,'/images/products/large/royal-coffee-bar.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (166,'/images/products/large/incanto-classic.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (167,'/images/products/large/espresso-italiano.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (168,'/images/products/large/spidem-villa.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (169,'/images/products/large/13442.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (170,'/images/products/large/13423.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (171,'/images/products/large/impressa-J5.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (172,'/images/products/large/13339.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (173,'/images/products/large/13422.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (174,'/images/products/large/13299.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (175,'/images/products/large/dcg39.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (176,'/images/products/large/0429-10.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (177,'/images/products/large/5679-01us.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (178,'/images/products/large/10462-01usa.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (179,'/images/products/large/503.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (1,'/images/products/small/yuban_original.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (2,'/images/products/small/yuban_dark_roast.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (3,'/images/products/small/yuban_decaffinated.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (4,'/images/products/small/eightOClock_original.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (5,'/images/products/small/eightOClock_50decaf.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (6,'/images/products/small/eightOClock_mocha.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (7,'/images/products/small/eightOClock_bokar.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (8,'/images/products/small/eightOClock_decafOriginal.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (9,'/images/products/small/eightOClock_frenchVanilla.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (10,'/images/products/small/eightOClock_frenchRoast.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (11,'/images/products/small/eightOClock_columbian.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (12,'/images/products/small/eightOClock_hazelnut.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (13,'/images/products/small/eightOClock_darkItalian.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (14,'/images/products/small/eightOClock_decafColumbian.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (15,'/images/products/small/seattle_beachHouse.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (16,'/images/products/small/seattle_bestBlend.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (17,'/images/products/small/seattle_henrysBlend.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (18,'/images/products/small/seattle_6thAvenueBistroBlend.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (19,'/images/products/small/seattle_almondRoca.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (20,'/images/products/small/seattle_cinnabon.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (21,'/images/products/small/seattle_colombian.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (22,'/images/products/small/seattle_cremeBrulee.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (23,'/images/products/small/seattle_organicFairTrade.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (24,'/images/products/small/seattle_hazelnut.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (25,'/images/products/small/seattle_breakfastBlend.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (26,'/images/products/small/seattle_organicHouseBlend.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (27,'/images/products/small/seattle_organicSumatra.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (28,'/images/products/small/seattle_portside.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (29,'/images/products/small/seattle_postAlleyBlend.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (30,'/images/products/small/seattle_saturdaysBlend.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (31,'/images/products/small/seattle_vanillaBean.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (32,'/images/products/small/millstone_breakfastBlend.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (33,'/images/products/small/millstone_colombianMedium.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (34,'/images/products/small/millstone_bedBreakfast.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (35,'/images/products/small/millstone_espresso.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (36,'/images/products/small/millstone_organicPeruvian.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (37,'/images/products/small/millstone_organicMayan.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (38,'/images/products/small/millstone_organicMountain.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (39,'/images/products/small/millstone_organicNicaraguan.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (40,'/images/products/small/millstone_organicRainforest.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (41,'/images/products/small/millstone_caramelTruffle.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (42,'/images/products/small/millstone_chocolateVelvet.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (43,'/images/products/small/millstone_cinnamonHazelnut.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (44,'/images/products/small/millstone_caramelTruffleDecaf.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (45,'/images/products/small/millstone_chocolateDecaf.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (46,'/images/products/small/millstone_frenchVanillaDecaf.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (47,'/images/products/small/millstone_hazelnutDecafWhole.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (48,'/images/products/small/millstone_frenchVanilla.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (49,'/images/products/small/millstone_hazelnutWhole.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (50,'/images/products/small/millstone_hazelnutGround.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (51,'/images/products/small/millstone_hazelnutDecafGround.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (52,'/images/products/small/millstone_raspberriesNCream.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (53,'/images/products/small/millstone_swissChocolate.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (54,'/images/products/small/millstone_vanillaNut.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (55,'/images/products/small/chock_columbian.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (56,'/images/products/small/chock_columbianDecaf.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (57,'/images/products/small/chock_city.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (58,'/images/products/small/chock_frenchRoast.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (59,'/images/products/small/chock_frenchRoastDecaf.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (60,'/images/products/small/chock_nyRoast.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (61,'/images/products/small/chock_original.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (62,'/images/products/small/chock_originalDecaf.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (63,'/images/products/small/chock_hazelnut.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (64,'/images/products/small/chock_brick.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (65,'/images/products/small/chock_soho.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (66,'/images/products/small/chock_westSideEuropean.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (67,'/images/products/small/chock_westSideEuropeanDecaf.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (68,'/images/products/small/chock_midtownFrench.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (69,'/images/products/small/chock_greenwich.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (70,'/images/products/small/maxwell_darkRoast.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (71,'/images/products/small/maxwell_columbianSupreme.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (72,'/images/products/small/maxwell_frenchRoast.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (73,'/images/products/small/maxwell_southPacific.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (74,'/images/products/small/maxwell_slowRoast.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (75,'/images/products/small/maxwell_original.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (76,'/images/products/small/maxwell_lite.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (77,'/images/products/small/maxwell_masterBlend.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (78,'/images/products/small/maxwell_breakfastBlend.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (79,'/images/products/small/maxwell_originalDecaf.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (80,'/images/products/small/maxwell_frenchRoastDecaf.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (81,'/images/products/small/maxwell_masterBlendDecaf.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (82,'/images/products/small/maxwell_vanilla.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (83,'/images/products/small/maxwell_hazelnut.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (84,'/images/products/small/maxwell_originalInstant.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (85,'/images/products/small/maxwell_decafInstant.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (86,'/images/products/small/maxwell_sankaInstant.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (87,'/images/products/small/maxwell_coffeeSingles.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (88,'/images/products/small/folgers_classicRoast.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (89,'/images/products/small/folgers_specialRoast.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (90,'/images/products/small/folgers_classicRoastDecaf.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (91,'/images/products/small/folgers_bistroBlend.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (92,'/images/products/small/folgers_hazelnutCreme.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (93,'/images/products/small/folgers_vanillaBiscotti.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (94,'/images/products/small/folgers_chocolateTruffle.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (95,'/images/products/small/folgers_cremeBrulee.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (96,'/images/products/small/folgers_caramelDrizzle.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (97,'/images/products/small/folgers_morningCafe.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (98,'/images/products/small/folgers_livelyColombian.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (99,'/images/products/small/folgers_brazilianBlend.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (100,'/images/products/small/folgers_boldJava.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (101,'/images/products/small/starbucks_arabianMochaSanani.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (102,'/images/products/small/starbucks_brazil.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (103,'/images/products/small/starbucks_bellaVista.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (104,'/images/products/small/starbucks_breakfastBlend.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (105,'/images/products/small/starbucks_guatemalaAntigua.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (106,'/images/products/small/starbucks_guatemalaCasiCielo.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (107,'/images/products/small/starbucks_houseBlend.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (108,'/images/products/small/starbucks_decafHouseBlend.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (109,'/images/products/small/starbucks_organicShadeGrown.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (110,'/images/products/small/starbucks_colombianNarino.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (111,'/images/products/small/starbucks_kenya.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (112,'/images/products/small/starbucks_ethiopiaSidamo.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (113,'/images/products/small/starbucks_sumatra.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (114,'/images/products/small/starbucks_komodoDragon.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (115,'/images/products/small/starbucks_decafSumatra.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (116,'/images/products/small/starbucks_cafeEstima.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (117,'/images/products/small/starbucks_caffeVerona.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (118,'/images/products/small/starbucks_caffeVeronaDecaf.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (119,'/images/products/small/starbucks_goldCoastBlend.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (120,'/images/products/small/starbucks_organicSerenaBlend.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (121,'/images/products/small/starbucks_espressoRoast.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (122,'/images/products/small/starbucks_decafEspressoRoast.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (123,'/images/products/small/starbucks_frenchRoast.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (124,'/images/products/small/starbucks_italianRoast.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (125,'/images/products/small/starbucks_pikePlaceRoast.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (126,'/images/products/small/starbucks_decafPikePlaceRoast.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (127,'/images/products/small/dcm900.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (128,'/images/products/small/dc514t.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (129,'/images/products/small/dcf212t.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (130,'/images/products/small/b108.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (131,'/images/products/small/b109.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (132,'/images/products/small/471.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (133,'/images/products/small/k10461-01.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (134,'/images/products/small/esam5500m.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (135,'/images/products/small/emk6.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (136,'/images/products/small/esam3300.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (137,'/images/products/small/en680m.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (138,'/images/products/small/bar32.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (139,'/images/products/small/esam3500.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (140,'/images/products/small/e406.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (141,'/images/products/small/e410.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (142,'/images/products/small/e301.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (143,'/images/products/small/e409.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (144,'/images/products/small/e400.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (145,'/images/products/small/e412.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (146,'/images/products/small/e408.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (147,'/images/products/small/e407.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (148,'/images/products/small/e413.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (149,'/images/products/small/e401.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (150,'/images/products/small/e413.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (151,'/images/products/small/e405.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (152,'/images/products/small/e402.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (153,'/images/products/small/e304.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (154,'/images/products/small/e309.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (155,'/images/products/small/e307.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (156,'/images/products/small/e414.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (157,'/images/products/small/e411.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (158,'/images/products/small/nina-cappuccino.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (159,'/images/products/small/magic-cappuccino-plus.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (160,'/images/products/small/nina-bar.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (161,'/images/products/small/aroma.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (162,'/images/products/small/odea-giro-orange.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (163,'/images/products/small/talea-touch.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (164,'/images/products/small/primea-ring.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (165,'/images/products/small/royal-coffee-bar.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (166,'/images/products/small/incanto-classic.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (167,'/images/products/small/espresso-italiano.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (168,'/images/products/small/spidem-villa.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (169,'/images/products/small/13442.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (170,'/images/products/small/13423.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (171,'/images/products/small/impressa-J5.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (172,'/images/products/small/13339.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (173,'/images/products/small/13422.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (174,'/images/products/small/13299.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (175,'/images/products/small/dcg39.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (176,'/images/products/small/0429-10.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (177,'/images/products/small/5679-01us.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (178,'/images/products/small/10462-01usa.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (179,'/images/products/small/503.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (180,'/images/products/large/macchianator.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (180,'/images/products/small/macchianator.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (181,'/images/products/large/basicmug.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (181,'/images/products/small/basicmug.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (182,'/images/products/large/dinermug.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (182,'/images/products/small/dinermug.jpg','small');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (183,'/images/products/large/colormug.jpg','large');
INSERT INTO BLC_PRODUCT_IMAGE (PRODUCT_ID, URL, NAME) VALUES (183,'/images/products/small/colormug.jpg','small');

INSERT INTO SEQUENCE_GENERATOR VALUES ('CustomerId',1);
INSERT INTO SEQUENCE_GENERATOR VALUES ('OrderId',2);
INSERT INTO SEQUENCE_GENERATOR VALUES ('OrderItemId',9);
INSERT INTO SEQUENCE_GENERATOR VALUES ('FulfillmentGroupId',3);
INSERT INTO SEQUENCE_GENERATOR VALUES ('AddressId',3);
INSERT INTO SEQUENCE_GENERATOR VALUES ('PhoneId',1);
INSERT INTO SEQUENCE_GENERATOR VALUES ('FulfillmentGroupItemId',1);
INSERT INTO SEQUENCE_GENERATOR VALUES ('PersonalMessageId',1);
INSERT INTO SEQUENCE_GENERATOR VALUES ('RatingSummaryImpl',10);
INSERT INTO SEQUENCE_GENERATOR VALUES ('RatingDetailImpl',10);
INSERT INTO SEQUENCE_GENERATOR VALUES ('ReviewDetailImpl',10);
INSERT INTO SEQUENCE_GENERATOR VALUES ('MediaId',1);
INSERT INTO SEQUENCE_GENERATOR VALUES ('CategoryImpl',10000);
INSERT INTO SEQUENCE_GENERATOR VALUES ('ProductImpl',1000);
INSERT INTO SEQUENCE_GENERATOR VALUES ('AdminUserImpl',100);
INSERT INTO SEQUENCE_GENERATOR VALUES ('CodeTypeId',100);
INSERT INTO SEQUENCE_GENERATOR VALUES ('OfferImpl',500);
INSERT INTO SEQUENCE_GENERATOR VALUES ('CategoryProductImpl',500);
INSERT INTO SEQUENCE_GENERATOR VALUES ('AdminRoleImpl',2);
INSERT INTO SEQUENCE_GENERATOR VALUES ('SearchInterceptImpl',1);
INSERT INTO SEQUENCE_GENERATOR VALUES ('SkuImpl',10000);

INSERT INTO BLC_COUNTRY VALUES ('US','United States');
INSERT INTO BLC_COUNTRY VALUES ('CA','Canada');
INSERT INTO BLC_COUNTRY VALUES ('MX','Mexico');

INSERT INTO BLC_STATE (NAME, ABBREVIATION, COUNTRY) VALUES ('ALABAMA','AL','US');
INSERT INTO BLC_STATE (NAME, ABBREVIATION, COUNTRY) VALUES ('ALASKA','AK','US');
INSERT INTO BLC_STATE (NAME, ABBREVIATION, COUNTRY) VALUES ('AMERICAN SAMOA','AS','US');
INSERT INTO BLC_STATE (NAME, ABBREVIATION, COUNTRY) VALUES ('ARIZONA','AZ','US');
INSERT INTO BLC_STATE (NAME, ABBREVIATION, COUNTRY) VALUES ('ARKANSAS','AR','US');
INSERT INTO BLC_STATE (NAME, ABBREVIATION, COUNTRY) VALUES ('CALIFORNIA','CA','US');
INSERT INTO BLC_STATE (NAME, ABBREVIATION, COUNTRY) VALUES ('COLORADO','CO','US');
INSERT INTO BLC_STATE (NAME, ABBREVIATION, COUNTRY) VALUES ('CONNECTICUT','CT','US');
INSERT INTO BLC_STATE (NAME, ABBREVIATION, COUNTRY) VALUES ('DELAWARE','DE','US');
INSERT INTO BLC_STATE (NAME, ABBREVIATION, COUNTRY) VALUES ('DISTRICT OF COLUMBIA','DC','US');
INSERT INTO BLC_STATE (NAME, ABBREVIATION, COUNTRY) VALUES ('FEDERATED STATES OF MICRONESIA','FM','US');
INSERT INTO BLC_STATE (NAME, ABBREVIATION, COUNTRY) VALUES ('FLORIDA','FL','US');
INSERT INTO BLC_STATE (NAME, ABBREVIATION, COUNTRY) VALUES ('GEORGIA','GA','US');
INSERT INTO BLC_STATE (NAME, ABBREVIATION, COUNTRY) VALUES ('GUAM','GU','US');
INSERT INTO BLC_STATE (NAME, ABBREVIATION, COUNTRY) VALUES ('HAWAII','HI','US');
INSERT INTO BLC_STATE (NAME, ABBREVIATION, COUNTRY) VALUES ('IDAHO','ID','US');
INSERT INTO BLC_STATE (NAME, ABBREVIATION, COUNTRY) VALUES ('ILLINOIS','IL','US');
INSERT INTO BLC_STATE (NAME, ABBREVIATION, COUNTRY) VALUES ('INDIANA','IN','US');
INSERT INTO BLC_STATE (NAME, ABBREVIATION, COUNTRY) VALUES ('IOWA','IA','US');
INSERT INTO BLC_STATE (NAME, ABBREVIATION, COUNTRY) VALUES ('KANSAS','KS','US');
INSERT INTO BLC_STATE (NAME, ABBREVIATION, COUNTRY) VALUES ('KENTUCKY','KY','US');
INSERT INTO BLC_STATE (NAME, ABBREVIATION, COUNTRY) VALUES ('LOUISIANA','LA','US');
INSERT INTO BLC_STATE (NAME, ABBREVIATION, COUNTRY) VALUES ('MAINE','ME','US');
INSERT INTO BLC_STATE (NAME, ABBREVIATION, COUNTRY) VALUES ('MARSHALL ISLANDS','MH','US');
INSERT INTO BLC_STATE (NAME, ABBREVIATION, COUNTRY) VALUES ('MARYLAND','MD','US');
INSERT INTO BLC_STATE (NAME, ABBREVIATION, COUNTRY) VALUES ('MASSACHUSETTS','MA','US');
INSERT INTO BLC_STATE (NAME, ABBREVIATION, COUNTRY) VALUES ('MICHIGAN','MI','US');
INSERT INTO BLC_STATE (NAME, ABBREVIATION, COUNTRY) VALUES ('MINNESOTA','MN','US');
INSERT INTO BLC_STATE (NAME, ABBREVIATION, COUNTRY) VALUES ('MISSISSIPPI','MS','US');
INSERT INTO BLC_STATE (NAME, ABBREVIATION, COUNTRY) VALUES ('MISSOURI','MO','US');
INSERT INTO BLC_STATE (NAME, ABBREVIATION, COUNTRY) VALUES ('MONTANA','MT','US');
INSERT INTO BLC_STATE (NAME, ABBREVIATION, COUNTRY) VALUES ('NEBRASKA','NE','US');
INSERT INTO BLC_STATE (NAME, ABBREVIATION, COUNTRY) VALUES ('NEVADA','NV','US');
INSERT INTO BLC_STATE (NAME, ABBREVIATION, COUNTRY) VALUES ('NEW HAMPSHIRE','NH','US');
INSERT INTO BLC_STATE (NAME, ABBREVIATION, COUNTRY) VALUES ('NEW JERSEY','NJ','US');
INSERT INTO BLC_STATE (NAME, ABBREVIATION, COUNTRY) VALUES ('NEW MEXICO','NM','US');
INSERT INTO BLC_STATE (NAME, ABBREVIATION, COUNTRY) VALUES ('NEW YORK','NY','US');
INSERT INTO BLC_STATE (NAME, ABBREVIATION, COUNTRY) VALUES ('NORTH CAROLINA','NC','US');
INSERT INTO BLC_STATE (NAME, ABBREVIATION, COUNTRY) VALUES ('NORTH DAKOTA','ND','US');
INSERT INTO BLC_STATE (NAME, ABBREVIATION, COUNTRY) VALUES ('NORTHERN MARIANA ISLANDS','MP','US');
INSERT INTO BLC_STATE (NAME, ABBREVIATION, COUNTRY) VALUES ('OHIO','OH','US');
INSERT INTO BLC_STATE (NAME, ABBREVIATION, COUNTRY) VALUES ('OKLAHOMA','OK','US');
INSERT INTO BLC_STATE (NAME, ABBREVIATION, COUNTRY) VALUES ('OREGON','OR','US');
INSERT INTO BLC_STATE (NAME, ABBREVIATION, COUNTRY) VALUES ('PALAU','PW','US');
INSERT INTO BLC_STATE (NAME, ABBREVIATION, COUNTRY) VALUES ('PENNSYLVANIA','PA','US');
INSERT INTO BLC_STATE (NAME, ABBREVIATION, COUNTRY) VALUES ('PUERTO RICO','PR','US');
INSERT INTO BLC_STATE (NAME, ABBREVIATION, COUNTRY) VALUES ('RHODE ISLAND','RI','US');
INSERT INTO BLC_STATE (NAME, ABBREVIATION, COUNTRY) VALUES ('SOUTH CAROLINA','SC','US');
INSERT INTO BLC_STATE (NAME, ABBREVIATION, COUNTRY) VALUES ('SOUTH DAKOTA','SD','US');
INSERT INTO BLC_STATE (NAME, ABBREVIATION, COUNTRY) VALUES ('TENNESSEE','TN','US');
INSERT INTO BLC_STATE (NAME, ABBREVIATION, COUNTRY) VALUES ('TEXAS','TX','US');
INSERT INTO BLC_STATE (NAME, ABBREVIATION, COUNTRY) VALUES ('UTAH','UT','US');
INSERT INTO BLC_STATE (NAME, ABBREVIATION, COUNTRY) VALUES ('VERMONT','VT','US');
INSERT INTO BLC_STATE (NAME, ABBREVIATION, COUNTRY) VALUES ('VIRGIN ISLANDS','VI','US');
INSERT INTO BLC_STATE (NAME, ABBREVIATION, COUNTRY) VALUES ('VIRGINIA','VA','US');
INSERT INTO BLC_STATE (NAME, ABBREVIATION, COUNTRY) VALUES ('WASHINGTON','WA','US');
INSERT INTO BLC_STATE (NAME, ABBREVIATION, COUNTRY) VALUES ('WEST VIRGINIA','WV','US');
INSERT INTO BLC_STATE (NAME, ABBREVIATION, COUNTRY) VALUES ('WISCONSIN','WI','US');
INSERT INTO BLC_STATE (NAME, ABBREVIATION, COUNTRY) VALUES ('WYOMING','WY','US');

INSERT INTO BLC_SHIPPING_RATE (ID, FEE_TYPE, FEE_SUB_TYPE, FEE_BAND, BAND_UNIT_QTY, BAND_RESULT_QTY, BAND_RESULT_PCT) VALUES (1,'SHIPPING','ALL',1,29.99,8.5,0);
INSERT INTO BLC_SHIPPING_RATE (ID, FEE_TYPE, FEE_SUB_TYPE, FEE_BAND, BAND_UNIT_QTY, BAND_RESULT_QTY, BAND_RESULT_PCT) VALUES (2,'EXPEDITED','ALL',2,39.99,10.5,0);
INSERT INTO BLC_SHIPPING_RATE (ID, FEE_TYPE, FEE_SUB_TYPE, FEE_BAND, BAND_UNIT_QTY, BAND_RESULT_QTY, BAND_RESULT_PCT) VALUES (3,'SHIPPING','ALL',1,999999,30,0);
INSERT INTO BLC_SHIPPING_RATE (ID, FEE_TYPE, FEE_SUB_TYPE, FEE_BAND, BAND_UNIT_QTY, BAND_RESULT_QTY, BAND_RESULT_PCT) VALUES (4,'EXPEDITED','ALL',2,999999,50,0);

INSERT INTO BLC_ROLE (ROLE_ID, ROLE_NAME) VALUES (1,'ROLE_USER');

INSERT INTO BLC_ID_GENERATION (ID_TYPE, BATCH_SIZE, BATCH_START, VERSION) VALUES ('org.broadleafcommerce.profile.domain.Customer',100,100,1);

INSERT INTO BLC_CUSTOMER (CUSTOMER_ID, FIRST_NAME, LAST_NAME, EMAIL_ADDRESS, PASSWORD_CHANGE_REQUIRED, RECEIVE_EMAIL, IS_REGISTERED, USER_NAME, PASSWORD) VALUES (1,'John','Doe','jdoe@gmail.com',0,0,0,'jdoe','foo');

INSERT INTO BLC_PHONE (PHONE_ID, PHONE_NUMBER, IS_ACTIVE, IS_DEFAULT) VALUES (1,'7135684249',1,1);

INSERT INTO BLC_CUSTOMER_PHONE (CUSTOMER_PHONE_ID, PHONE_NAME, CUSTOMER_ID, PHONE_ID) VALUES (1,'Home Phone',1,1);

INSERT INTO BLC_CHALLENGE_QUESTION (QUESTION_ID, QUESTION) VALUES (1,'What is your favorite sports team?');
INSERT INTO BLC_CHALLENGE_QUESTION (QUESTION_ID, QUESTION) VALUES (2,'What was your high school name?');
INSERT INTO BLC_CHALLENGE_QUESTION (QUESTION_ID, QUESTION) VALUES (3,'What was your childhood nickname?'); 
INSERT INTO BLC_CHALLENGE_QUESTION (QUESTION_ID, QUESTION) VALUES (4,'What street did you live on in third grade?');
INSERT INTO BLC_CHALLENGE_QUESTION (QUESTION_ID, QUESTION) VALUES (5,'What is your oldest sibling''s middle name?');
INSERT INTO BLC_CHALLENGE_QUESTION (QUESTION_ID, QUESTION) VALUES (6,'What school did you attend for sixth grade?');
INSERT INTO BLC_CHALLENGE_QUESTION (QUESTION_ID, QUESTION) VALUES (7,'Where does your nearest sibling live?');
INSERT INTO BLC_CHALLENGE_QUESTION (QUESTION_ID, QUESTION) VALUES (8,'What is your youngest brothers birthday?');
INSERT INTO BLC_CHALLENGE_QUESTION (QUESTION_ID, QUESTION) VALUES (9,'In what city or town was your first job?');

INSERT INTO BLC_PRODUCT_CROSS_SALE (CROSS_SALE_PRODUCT_ID, PROMOTION_MESSAGE, SEQUENCE, PRODUCT_ID, RELATED_SALE_PRODUCT_ID) VALUES (1,'BUY ME!!',1,128,129);
INSERT INTO BLC_PRODUCT_CROSS_SALE (CROSS_SALE_PRODUCT_ID, PROMOTION_MESSAGE, SEQUENCE, PRODUCT_ID, RELATED_SALE_PRODUCT_ID) VALUES (2,'BUY ME!!',1,128,130);
INSERT INTO BLC_PRODUCT_CROSS_SALE (CROSS_SALE_PRODUCT_ID, PROMOTION_MESSAGE, SEQUENCE, PRODUCT_ID, RELATED_SALE_PRODUCT_ID) VALUES (3,'BUY ME!!',1,128,131);

INSERT INTO BLC_PRODUCT_UP_SALE (UP_SALE_PRODUCT_ID, PROMOTION_MESSAGE, SEQUENCE, PRODUCT_ID, RELATED_SALE_PRODUCT_ID) VALUES (1,'BUY ME!!',1,128,130);

INSERT INTO BLC_STORE (STORE_ID, STORE_NAME, ADDRESS_1, ADDRESS_2, STORE_CITY, STORE_STATE, STORE_ZIP, LATITUDE, LONGITUDE) VALUES (1,'The Coffee Shop','12770 Merit Drive',NULL,'Dallas','Texas',75251,32.9209,-96.7735);
INSERT INTO BLC_STORE (STORE_ID, STORE_NAME, ADDRESS_1, ADDRESS_2, STORE_CITY, STORE_STATE, STORE_ZIP, LATITUDE, LONGITUDE) VALUES (2,'Java Coffee Shop','5657 Amesbury Drive',NULL,'Dallas','Texas',75206,32.8225,-96.7762);

INSERT INTO BLC_ZIP_CODE (ZIP_CODE_ID, ZIPCODE, ZIP_LATITUDE, ZIP_LONGITUDE) VALUES (1,75206,32.8225,-96.7762);
INSERT INTO BLC_ZIP_CODE (ZIP_CODE_ID, ZIPCODE, ZIP_LATITUDE, ZIP_LONGITUDE) VALUES (2,75251,32.9209,-96.7735);
INSERT INTO BLC_ZIP_CODE (ZIP_CODE_ID, ZIPCODE, ZIP_LATITUDE, ZIP_LONGITUDE) VALUES (3,75056,33.0787,-96.9102);

INSERT INTO BLC_PRODUCT_FEATURED (FEATURED_PRODUCT_ID, PROMOTION_MESSAGE, SEQUENCE, CATEGORY_ID, PRODUCT_ID) VALUES (1,'Great for brewing coffee!',1,2002,130);
INSERT INTO BLC_PRODUCT_FEATURED (FEATURED_PRODUCT_ID, PROMOTION_MESSAGE, SEQUENCE, CATEGORY_ID, PRODUCT_ID) VALUES (2,'Great sale on this item',1,2002,131);

INSERT INTO BLC_CATEGORY_IMAGE (CATEGORY_ID, URL, NAME) VALUES (1005,'/images/categories/large/chock_logo.jpg','large');
INSERT INTO BLC_CATEGORY_IMAGE (CATEGORY_ID, URL, NAME) VALUES (1002,'/images/categories/large/eoc_logo.jpg','large');
INSERT INTO BLC_CATEGORY_IMAGE (CATEGORY_ID, URL, NAME) VALUES (1007,'/images/categories/large/folgers_logo.jpg','large');
INSERT INTO BLC_CATEGORY_IMAGE (CATEGORY_ID, URL, NAME) VALUES (1006,'/images/categories/large/maxwell_logo.jpg','large');
INSERT INTO BLC_CATEGORY_IMAGE (CATEGORY_ID, URL, NAME) VALUES (1004,'/images/categories/large/millstone_logo.jpg','large');
INSERT INTO BLC_CATEGORY_IMAGE (CATEGORY_ID, URL, NAME) VALUES (1003,'/images/categories/large/seattles_logo.jpg','large');
INSERT INTO BLC_CATEGORY_IMAGE (CATEGORY_ID, URL, NAME) VALUES (1008,'/images/categories/large/starbucks_logo.jpg','large');
INSERT INTO BLC_CATEGORY_IMAGE (CATEGORY_ID, URL, NAME) VALUES (1001,'/images/categories/large/yuban_logo.jpg','large');
INSERT INTO BLC_CATEGORY_IMAGE (CATEGORY_ID, URL, NAME) VALUES (1005,'/images/categories/small/chock_logo.jpg','small');
INSERT INTO BLC_CATEGORY_IMAGE (CATEGORY_ID, URL, NAME) VALUES (1002,'/images/categories/small/eoc_logo.jpg','small');
INSERT INTO BLC_CATEGORY_IMAGE (CATEGORY_ID, URL, NAME) VALUES (1007,'/images/categories/small/folgers_logo.jpg','small');
INSERT INTO BLC_CATEGORY_IMAGE (CATEGORY_ID, URL, NAME) VALUES (1006,'/images/categories/small/maxwell_logo.jpg','small');
INSERT INTO BLC_CATEGORY_IMAGE (CATEGORY_ID, URL, NAME) VALUES (1004,'/images/categories/small/millstone_logo.jpg','small');
INSERT INTO BLC_CATEGORY_IMAGE (CATEGORY_ID, URL, NAME) VALUES (1003,'/images/categories/small/seattles_logo.jpg','small');
INSERT INTO BLC_CATEGORY_IMAGE (CATEGORY_ID, URL, NAME) VALUES (1008,'/images/categories/small/starbucks_logo.jpg','small');
INSERT INTO BLC_CATEGORY_IMAGE (CATEGORY_ID, URL, NAME) VALUES (1001,'/images/categories/small/yuban_logo.jpg','small');
INSERT INTO BLC_CATEGORY_IMAGE (CATEGORY_ID, URL, NAME) VALUES (2001,'/images/products/large/esam5500m.jpg','large');
INSERT INTO BLC_CATEGORY_IMAGE (CATEGORY_ID, URL, NAME) VALUES (2002,'/images/products/large/b109.jpg','large');
INSERT INTO BLC_CATEGORY_IMAGE (CATEGORY_ID, URL, NAME) VALUES (2007,'/images/products/large/0429-10.jpg','large');
INSERT INTO BLC_CATEGORY_IMAGE (CATEGORY_ID, URL, NAME) VALUES (2001,'/images/products/small/esam5500m.jpg','small');
INSERT INTO BLC_CATEGORY_IMAGE (CATEGORY_ID, URL, NAME) VALUES (2002,'/images/products/small/b109.jpg','small');
INSERT INTO BLC_CATEGORY_IMAGE (CATEGORY_ID, URL, NAME) VALUES (2007,'/images/products/small/0429-10.jpg','small');

INSERT INTO BLC_OFFER (OFFER_ID, APPLIES_TO_RULES, OFFER_NAME, START_DATE, END_DATE, OFFER_TYPE, OFFER_DISCOUNT_TYPE, OFFER_VALUE, OFFER_DELIVERY_TYPE, STACKABLE, COMBINABLE_WITH_OTHER_OFFERS, OFFER_PRIORITY, APPLY_OFFER_TO_MARKED_ITEMS, APPLY_TO_SALE_PRICE, USES, MAX_USES) VALUES (1,'discreteOrderItem.sku.id == 127','20 Percent Off Item Offer','2009-08-05 14:28:36','2009-12-22 14:28:36','ORDER_ITEM','PERCENT_OFF',20,'CODE',1,1,10,0,0,0,10);
INSERT INTO BLC_OFFER (OFFER_ID, APPLIES_TO_RULES, OFFER_NAME, START_DATE, END_DATE, OFFER_TYPE, OFFER_DISCOUNT_TYPE, OFFER_VALUE, OFFER_DELIVERY_TYPE, STACKABLE, COMBINABLE_WITH_OTHER_OFFERS, OFFER_PRIORITY, APPLY_OFFER_TO_MARKED_ITEMS, APPLY_TO_SALE_PRICE, USES, MAX_USES) VALUES (2,NULL,'1.20 Dollars Off Order Offer','2009-08-05 14:28:36','2009-12-22 14:28:36','ORDER','AMOUNT_OFF',1.2,'CODE',1,1,10,0,1,0,10);

INSERT INTO BLC_OFFER_CODE (OFFER_CODE_ID, OFFER_CODE, OFFER_ID, MAX_USES, USES) VALUES (1,'OPRAH',1,10,0);
INSERT INTO BLC_OFFER_CODE (OFFER_CODE_ID, OFFER_CODE, OFFER_ID, MAX_USES, USES) VALUES (2,'ONEDOLLAR',2,10,0);

INSERT INTO BLC_RATING_SUMMARY (RATING_SUMMARY_ID, AVERAGE_RATING, ITEM_ID, RATING_TYPE) VALUES (1,0,127,'PRODUCT');

INSERT INTO BLC_RATING_DETAIL (RATING_DETAIL_ID, RATING, CUSTOMER_ID, RATING_SUMMARY_ID, RATING_SUBMITTED_DATE) VALUES (1,4,1,1,CURRENT_DATE);
INSERT INTO BLC_RATING_DETAIL (RATING_DETAIL_ID, RATING, CUSTOMER_ID, RATING_SUMMARY_ID, RATING_SUBMITTED_DATE) VALUES (2,3,1,1,CURRENT_DATE);
INSERT INTO BLC_RATING_DETAIL (RATING_DETAIL_ID, RATING, CUSTOMER_ID, RATING_SUMMARY_ID, RATING_SUBMITTED_DATE) VALUES (3,5,1,1,CURRENT_DATE);

INSERT INTO BLC_REVIEW_DETAIL (REVIEW_DETAIL_ID, HELPFUL_COUNT, NOT_HELPFUL_COUNT, REVIEW_STATUS, REVIEW_TEXT, CUSTOMER_ID, RATING_SUMMARY_ID, RATING_DETAIL_ID, REVIEW_SUBMITTED_DATE) VALUES (1,0,0,'APPROVED','I bought this grinder after seeing it recommended on another site. Unfortunately, I quickly discovered that this grinder does not do a good job of fine grinding. Also, the lid is a little finicky going on and can''t be used to hold the ground coffee. If you need your coffee ground fine, and don''t want to shell out the bucks for a burr grinder, try the Braun KSM2.',1,1,1,CURRENT_DATE);
INSERT INTO BLC_REVIEW_DETAIL (REVIEW_DETAIL_ID, HELPFUL_COUNT, NOT_HELPFUL_COUNT, REVIEW_STATUS, REVIEW_TEXT, CUSTOMER_ID, RATING_SUMMARY_ID, RATING_DETAIL_ID, REVIEW_SUBMITTED_DATE) VALUES (2,0,0,'APPROVED','This coffee grinder is very inconvenient to use--getting the ground coffee out of the machine is difficult and messy. Removing the coffee requires a tiny spoon or a brush, and even then is incomplete, leaving dregs in the grinder to turn rancid and spoil the flavor of future coffee, and a mess on the counter. I''ve used several less expensive models that were lots less trouble. Also, the body of the grinder is too fat to pick up securely with one hand, creating a tendency to drop it and make an even bigger mess. It looks like very little thought went into this design.',1,1,2,CURRENT_DATE);
INSERT INTO BLC_REVIEW_DETAIL (REVIEW_DETAIL_ID, HELPFUL_COUNT, NOT_HELPFUL_COUNT, REVIEW_STATUS, REVIEW_TEXT, CUSTOMER_ID, RATING_SUMMARY_ID, RATING_DETAIL_ID, REVIEW_SUBMITTED_DATE) VALUES (3,0,0,'APPROVED','I''ve had nothing but good from this grinder and would recommend it. I AM drinking more coffee because it produces such a fine smooth cup. I shake it around as it hums and tap it out into my Bodum French Press and, man, what a good cup of coffee. It has made me move up the coffee bean path (via Whole Foods) from my good old family standard. Ethiopian beans, fresh ground with this machine, fresh shaked into the press and zapp! I''m awake to sip and enjoy my morning. It''s been the good machine you''d expect from Bodum and presents a pleasant experience. I fresh grind all my coffee now.',1,1,3,CURRENT_DATE);
