/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.adapt;

import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tiles.TilesApplicationContext;
import org.apache.tiles.TilesContainer;
import org.apache.tiles.TilesException;
import org.apache.tiles.access.TilesAccess;
import org.apache.tiles.context.AbstractTilesApplicationContextFactory;
import org.apache.tiles.evaluator.el.ELAttributeEvaluator;
import org.apache.tiles.factory.AbstractTilesContainerFactory;
import org.apache.tiles.preparer.BasicPreparerFactory;
import org.apache.tiles.servlet.context.ServletTilesApplicationContext;
import org.apache.tiles.servlet.context.wildcard.WildcardServletTilesApplicationContextFactory;
import org.apache.tiles.web.util.ServletContextAdapter;
import org.broadleafcommerce.adapt.TilesConfigurer;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.servlet.view.tiles2.SpringLocaleResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TilesConfigurer
implements ServletContextAware,
InitializingBean,
DisposableBean {
    protected static final Log logger = LogFactory.getLog(TilesConfigurer.class);
    private final Properties tilesPropertyMap = new Properties();
    private ServletContext servletContext;
    private TilesApplicationContext tilesContext;

    public TilesConfigurer() {
        this.tilesPropertyMap.put("org.apache.tiles.context.AbstractTilesApplicationContextFactory", WildcardServletTilesApplicationContextFactory.class.getName());
        this.tilesPropertyMap.put("org.apache.tiles.preparer.PreparerFactory", BasicPreparerFactory.class.getName());
        this.tilesPropertyMap.put("org.apache.tiles.locale.LocaleResolver", SpringLocaleResolver.class.getName());
        this.tilesPropertyMap.put("org.apache.tiles.evaluator.AttributeEvaluator", ELAttributeEvaluator.class.getName());
        this.tilesPropertyMap.put("org.apache.tiles.factory.TilesContainerFactory.MUTABLE", Boolean.toString(false));
    }

    public void setDefinitions(String[] definitions) {
        if (definitions != null) {
            String defs = StringUtils.arrayToCommaDelimitedString((Object[])definitions);
            if (logger.isInfoEnabled()) {
                logger.info((Object)("TilesConfigurer: adding definitions [" + defs + "]"));
            }
            this.tilesPropertyMap.put("org.apache.tiles.definition.DefinitionsFactory.DEFINITIONS_CONFIG", defs);
        }
    }

    public void setValidateDefinitions(boolean validateDefinitions) {
        this.tilesPropertyMap.put("org.apache.tiles.definition.digester.DigesterDefinitionsReader.PARSER_VALIDATE", Boolean.toString(validateDefinitions));
    }

    public void setDefinitionsFactoryClass(Class<?> definitionsFactoryClass) {
        this.tilesPropertyMap.put("org.apache.tiles.definition.DefinitionsFactory", definitionsFactoryClass.getName());
    }

    public void setPreparerFactoryClass(Class<?> preparerFactoryClass) {
        this.tilesPropertyMap.put("org.apache.tiles.preparer.PreparerFactory", preparerFactoryClass.getName());
    }

    public void setUseMutableTilesContainer(boolean useMutableTilesContainer) {
        this.tilesPropertyMap.put("org.apache.tiles.factory.TilesContainerFactory.MUTABLE", Boolean.toString(useMutableTilesContainer));
    }

    public void setTilesProperties(Properties tilesProperties) {
        CollectionUtils.mergePropertiesIntoMap((Properties)tilesProperties, (Map)this.tilesPropertyMap);
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void afterPropertiesSet() throws TilesException {
        TilesContainer container = this.createTilesContainer();
        TilesAccess.setContainer((TilesApplicationContext)this.tilesContext, (TilesContainer)container);
    }

    protected TilesContainer createTilesContainer() throws TilesException {
        ServletContextAdapter adaptedContext = new ServletContextAdapter((ServletConfig)new DelegatingServletConfig(this, null));
        ServletTilesApplicationContext preliminaryContext = new ServletTilesApplicationContext((ServletContext)adaptedContext);
        AbstractTilesApplicationContextFactory contextFactory = AbstractTilesApplicationContextFactory.createFactory((TilesApplicationContext)preliminaryContext);
        this.tilesContext = contextFactory.createApplicationContext((Object)adaptedContext);
        AbstractTilesContainerFactory factory = AbstractTilesContainerFactory.getTilesContainerFactory((TilesApplicationContext)this.tilesContext);
        return factory.createContainer(this.tilesContext);
    }

    public void destroy() throws TilesException {
        TilesAccess.setContainer((TilesApplicationContext)this.tilesContext, null);
    }

    static /* synthetic */ ServletContext access$100(TilesConfigurer x0) {
        return x0.servletContext;
    }

    static /* synthetic */ Properties access$200(TilesConfigurer x0) {
        return x0.tilesPropertyMap;
    }
}

