/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.pricing.service.module;

import java.util.ArrayList;
import java.util.Currency;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.common.vendor.service.exception.TaxException;
import org.broadleafcommerce.core.order.domain.BundleOrderItem;
import org.broadleafcommerce.core.order.domain.DiscreteOrderItem;
import org.broadleafcommerce.core.order.domain.FulfillmentGroup;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupFee;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupImpl;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupItem;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.payment.domain.PaymentInfo;
import org.broadleafcommerce.core.pricing.service.module.TaxModule;
import org.broadleafcommerce.service.module.CyberSourceModule;
import org.broadleafcommerce.vendor.cybersource.service.CyberSourceServiceManager;
import org.broadleafcommerce.vendor.cybersource.service.message.CyberSourceBillingRequest;
import org.broadleafcommerce.vendor.cybersource.service.tax.CyberSourceTaxService;
import org.broadleafcommerce.vendor.cybersource.service.tax.message.CyberSourceTaxItemRequest;
import org.broadleafcommerce.vendor.cybersource.service.tax.message.CyberSourceTaxItemResponse;
import org.broadleafcommerce.vendor.cybersource.service.tax.message.CyberSourceTaxRequest;
import org.broadleafcommerce.vendor.cybersource.service.tax.message.CyberSourceTaxResponse;

public class CyberSourceTaxModule
extends CyberSourceModule
implements TaxModule {
    public static final String MODULENAME = "cyberSourceTaxModule";
    protected String name = "cyberSourceTaxModule";
    private CyberSourceServiceManager serviceManager;
    private List<String> nexus = new ArrayList<String>();
    private List<String> nonexus = new ArrayList<String>();
    private String orderAcceptanceCity;
    private String orderAcceptanceCounty;
    private String orderAcceptanceCountry;
    private String orderAcceptanceState;
    private String orderAcceptancePostalCode;

    public Order calculateTaxForOrder(Order order) throws org.broadleafcommerce.core.pricing.service.exception.TaxException {
        CyberSourceTaxResponse response;
        if (this.orderAcceptanceCountry != null && !this.orderAcceptanceCountry.equalsIgnoreCase("CA") && !this.orderAcceptanceCountry.equalsIgnoreCase("US")) {
            throw new org.broadleafcommerce.core.pricing.service.exception.TaxException("CyberSource tax calculation only supported for the United States and Canada.");
        }
        HashMap<Long, CyberSourceTaxItemRequest> requestLibrary = new HashMap<Long, CyberSourceTaxItemRequest>();
        CyberSourceTaxRequest taxRequest = this.createTaxRequest(order, requestLibrary);
        try {
            response = this.callService(taxRequest);
        }
        catch (TaxException e) {
            throw new org.broadleafcommerce.core.pricing.service.exception.TaxException((Throwable)e);
        }
        this.calculateTaxes(order, requestLibrary, response);
        return order;
    }

    private void calculateTaxes(Order order, HashMap<Long, CyberSourceTaxItemRequest> requestLibrary, CyberSourceTaxResponse response) {
        order.setCityTax(new Money(0.0));
        order.setCountyTax(new Money(0.0));
        order.setStateTax(new Money(0.0));
        order.setDistrictTax(new Money(0.0));
        order.setCountryTax(new Money(0.0));
        order.setTotalTax(new Money(0.0));
        for (CyberSourceTaxItemResponse itemResponse : response.getItemResponses()) {
            CyberSourceTaxItemRequest itemRequest = requestLibrary.get((long)itemResponse.getId());
            order.setCityTax(order.getCityTax().add(itemResponse.getCityTaxAmount().multiply((double)itemRequest.getNonCyberSourceQuantity().longValue())));
            order.setCountyTax(order.getCountyTax().add(itemResponse.getCountyTaxAmount().multiply((double)itemRequest.getNonCyberSourceQuantity().longValue())));
            order.setStateTax(order.getStateTax().add(itemResponse.getStateTaxAmount().multiply((double)itemRequest.getNonCyberSourceQuantity().longValue())));
            order.setDistrictTax(order.getDistrictTax().add(itemResponse.getDistrictTaxAmount().multiply((double)itemRequest.getNonCyberSourceQuantity().longValue())));
            order.setTotalTax(order.getTotalTax().add(itemResponse.getTotalTaxAmount().multiply((double)itemRequest.getNonCyberSourceQuantity().longValue())));
            FulfillmentGroupImpl searchParam = new FulfillmentGroupImpl();
            searchParam.setId(itemRequest.getNonCyberSourceFulfillmentGroupId());
            FulfillmentGroup myGroup = (FulfillmentGroup)order.getFulfillmentGroups().get(order.getFulfillmentGroups().indexOf(searchParam));
            if (myGroup.getCityTax() == null) {
                myGroup.setCityTax(new Money(0.0));
            }
            if (myGroup.getCountyTax() == null) {
                myGroup.setCountyTax(new Money(0.0));
            }
            if (myGroup.getStateTax() == null) {
                myGroup.setStateTax(new Money(0.0));
            }
            if (myGroup.getDistrictTax() == null) {
                myGroup.setDistrictTax(new Money(0.0));
            }
            if (myGroup.getCountryTax() == null) {
                myGroup.setCountryTax(new Money(0.0));
            }
            if (myGroup.getTotalTax() == null) {
                myGroup.setTotalTax(new Money(0.0));
            }
            myGroup.setCityTax(myGroup.getCityTax().add(itemResponse.getCityTaxAmount().multiply((double)itemRequest.getNonCyberSourceQuantity().longValue())));
            myGroup.setCountyTax(myGroup.getCountyTax().add(itemResponse.getCountyTaxAmount().multiply((double)itemRequest.getNonCyberSourceQuantity().longValue())));
            myGroup.setStateTax(myGroup.getStateTax().add(itemResponse.getStateTaxAmount().multiply((double)itemRequest.getNonCyberSourceQuantity().longValue())));
            myGroup.setDistrictTax(myGroup.getDistrictTax().add(itemResponse.getDistrictTaxAmount().multiply((double)itemRequest.getNonCyberSourceQuantity().longValue())));
            myGroup.setTotalTax(myGroup.getTotalTax().add(itemResponse.getTotalTaxAmount().multiply((double)itemRequest.getNonCyberSourceQuantity().longValue())));
        }
    }

    private CyberSourceTaxRequest createTaxRequest(Order order, HashMap<Long, CyberSourceTaxItemRequest> requestLibrary) throws org.broadleafcommerce.core.pricing.service.exception.TaxException {
        String myNoNexus;
        if (order.getPaymentInfos() == null || order.getPaymentInfos().get(0) == null || ((PaymentInfo)order.getPaymentInfos().get(0)).getAddress() == null) {
            throw new org.broadleafcommerce.core.pricing.service.exception.TaxException("The order must have at least one PaymentInfo instance associated with a completed Address in order to calculate tax.");
        }
        CyberSourceTaxRequest taxRequest = new CyberSourceTaxRequest();
        this.setCurrency(order, taxRequest);
        CyberSourceBillingRequest billingRequest = this.createBillingRequest((PaymentInfo)order.getPaymentInfos().get(0));
        taxRequest.setBillingRequest(billingRequest);
        String myNexus = StringUtils.join((Object[])this.nexus.toArray(new String[0]), (char)',');
        if (!StringUtils.isEmpty((String)myNexus)) {
            taxRequest.setNexus(myNexus);
        }
        if (!StringUtils.isEmpty((String)(myNoNexus = StringUtils.join((Object[])this.nonexus.toArray(new String[0]), (char)',')))) {
            taxRequest.setNoNexus(myNoNexus);
        }
        taxRequest.setOrderAcceptanceCity(this.orderAcceptanceCity);
        taxRequest.setOrderAcceptanceCounty(this.orderAcceptanceCounty);
        taxRequest.setOrderAcceptanceCountry(this.orderAcceptanceCountry);
        taxRequest.setOrderAcceptanceState(this.orderAcceptanceState);
        taxRequest.setOrderAcceptancePostalCode(this.orderAcceptancePostalCode);
        for (FulfillmentGroup fulfillmentGroup : order.getFulfillmentGroups()) {
            if (fulfillmentGroup.getAddress().getCountry() != null && !fulfillmentGroup.getAddress().getCountry().getAbbreviation().equalsIgnoreCase("CA") && !fulfillmentGroup.getAddress().getCountry().getAbbreviation().equalsIgnoreCase("US")) {
                throw new org.broadleafcommerce.core.pricing.service.exception.TaxException("CyberSource tax calculation only supported for the United States and Canada.");
            }
            for (FulfillmentGroupItem item : fulfillmentGroup.getFulfillmentGroupItems()) {
                OrderItem orderItem = item.getOrderItem();
                if (!orderItem.getTaxablePrice().greaterThan(Money.zero((String)taxRequest.getCurrency()))) continue;
                CyberSourceTaxItemRequest itemRequest = new CyberSourceTaxItemRequest();
                itemRequest.setNonCyberSourceFulfillmentGroupId(fulfillmentGroup.getId());
                if (DiscreteOrderItem.class.isAssignableFrom(orderItem.getClass())) {
                    DiscreteOrderItem discreteItem = (DiscreteOrderItem)orderItem;
                    itemRequest.setProductName(discreteItem.getName());
                    itemRequest.setProductSKU(discreteItem.getSku().getName());
                    itemRequest.setDescription(discreteItem.getSku().getDescription());
                } else if (BundleOrderItem.class.isAssignableFrom(orderItem.getClass())) {
                    BundleOrderItem bundleItem = (BundleOrderItem)orderItem;
                    itemRequest.setProductName(bundleItem.getName());
                    itemRequest.setDescription("Bundled Order Item");
                } else {
                    itemRequest.setProductName("Other");
                    itemRequest.setDescription("Other product type: " + orderItem.getClass().getName());
                }
                itemRequest.setQuantity(1L);
                itemRequest.setNonCyberSourceQuantity(Integer.valueOf(item.getQuantity()).longValue());
                itemRequest.setUnitPrice(orderItem.getTaxablePrice());
                taxRequest.getItemRequests().add(itemRequest);
                requestLibrary.put(itemRequest.getId(), itemRequest);
            }
            for (FulfillmentGroupFee fulfillmentGroupFee : fulfillmentGroup.getFulfillmentGroupFees()) {
                if (!fulfillmentGroupFee.isTaxable().booleanValue() || !fulfillmentGroupFee.getAmount().greaterThan(Money.zero((String)taxRequest.getCurrency()))) continue;
                CyberSourceTaxItemRequest itemRequest = new CyberSourceTaxItemRequest();
                itemRequest.setNonCyberSourceFulfillmentGroupId(fulfillmentGroup.getId());
                itemRequest.setProductName(fulfillmentGroupFee.getName() == null ? "Fee" : fulfillmentGroupFee.getName());
                itemRequest.setDescription(fulfillmentGroupFee.getReportingCode() == null ? "None" : fulfillmentGroupFee.getReportingCode());
                itemRequest.setQuantity(1L);
                itemRequest.setNonCyberSourceQuantity(1L);
                itemRequest.setUnitPrice(fulfillmentGroupFee.getAmount());
                taxRequest.getItemRequests().add(itemRequest);
                requestLibrary.put(itemRequest.getId(), itemRequest);
            }
            if (!fulfillmentGroup.isShippingPriceTaxable().booleanValue() || !fulfillmentGroup.getShippingPrice().greaterThan(Money.zero((String)taxRequest.getCurrency()))) continue;
            CyberSourceTaxItemRequest itemRequest = new CyberSourceTaxItemRequest();
            itemRequest.setNonCyberSourceFulfillmentGroupId(fulfillmentGroup.getId());
            itemRequest.setProductName("Shipping Cost");
            itemRequest.setDescription("Taxable Shipping Cost");
            itemRequest.setQuantity(1L);
            itemRequest.setNonCyberSourceQuantity(1L);
            itemRequest.setUnitPrice(fulfillmentGroup.getShippingPrice());
            taxRequest.getItemRequests().add(itemRequest);
            requestLibrary.put(itemRequest.getId(), itemRequest);
        }
        return taxRequest;
    }

    private CyberSourceTaxResponse callService(CyberSourceTaxRequest taxRequest) throws TaxException {
        CyberSourceTaxService service = (CyberSourceTaxService)this.serviceManager.getValidService(taxRequest);
        CyberSourceTaxResponse response = service.process(taxRequest);
        return response;
    }

    private void setCurrency(Order order, CyberSourceTaxRequest taxRequest) {
        Currency currency = order.getTotal().getCurrency();
        if (currency == null) {
            currency = Money.defaultCurrency();
        }
        taxRequest.setCurrency(currency.getCurrencyCode());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CyberSourceServiceManager getServiceManager() {
        return this.serviceManager;
    }

    public void setServiceManager(CyberSourceServiceManager serviceManager) {
        this.serviceManager = serviceManager;
    }

    public List<String> getNexus() {
        return this.nexus;
    }

    public void setNexus(List<String> nexus) {
        this.nexus = nexus;
    }

    public List<String> getNonexus() {
        return this.nonexus;
    }

    public void setNonexus(List<String> nonexus) {
        this.nonexus = nonexus;
    }

    public String getOrderAcceptanceCounty() {
        return this.orderAcceptanceCounty;
    }

    public void setOrderAcceptanceCounty(String orderAcceptanceCounty) {
        this.orderAcceptanceCounty = orderAcceptanceCounty;
    }

    public String getOrderAcceptanceCountry() {
        return this.orderAcceptanceCountry;
    }

    public void setOrderAcceptanceCountry(String orderAcceptanceCountry) {
        this.orderAcceptanceCountry = orderAcceptanceCountry;
    }

    public String getOrderAcceptanceState() {
        return this.orderAcceptanceState;
    }

    public void setOrderAcceptanceState(String orderAcceptanceState) {
        this.orderAcceptanceState = orderAcceptanceState;
    }

    public String getOrderAcceptancePostalCode() {
        return this.orderAcceptancePostalCode;
    }

    public void setOrderAcceptancePostalCode(String orderAcceptancePostalCode) {
        this.orderAcceptancePostalCode = orderAcceptancePostalCode;
    }

    public String getOrderAcceptanceCity() {
        return this.orderAcceptanceCity;
    }

    public void setOrderAcceptanceCity(String orderAcceptanceCity) {
        this.orderAcceptanceCity = orderAcceptanceCity;
    }
}

