/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.vendor.cybersource.service.payment.type;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.broadleafcommerce.common.BroadleafEnumerationType;

public class CyberSourceTransactionType
implements Serializable,
BroadleafEnumerationType {
    private static final long serialVersionUID = 1L;
    private static final Map<String, CyberSourceTransactionType> TYPES = new HashMap<String, CyberSourceTransactionType>();
    public static final CyberSourceTransactionType AUTHORIZE = new CyberSourceTransactionType("AUTHORIZE", "Authorize");
    public static final CyberSourceTransactionType CAPTURE = new CyberSourceTransactionType("CAPTURE", "Capture");
    public static final CyberSourceTransactionType AUTHORIZEANDCAPTURE = new CyberSourceTransactionType("AUTHORIZEANDCAPTURE", "Authorize and Capture");
    public static final CyberSourceTransactionType CREDIT = new CyberSourceTransactionType("CREDIT", "Credit");
    public static final CyberSourceTransactionType VOIDTRANSACTION = new CyberSourceTransactionType("VOIDTRANSACTION", "Void Transaction");
    public static final CyberSourceTransactionType REVERSEAUTHORIZE = new CyberSourceTransactionType("REVERSEAUTHORIZE", "Reverse Authorize");
    private String type;
    private String friendlyType;

    public static CyberSourceTransactionType getInstance(String type) {
        return TYPES.get(type);
    }

    public CyberSourceTransactionType() {
    }

    public CyberSourceTransactionType(String type, String friendlyType) {
        this.friendlyType = friendlyType;
        this.setType(type);
    }

    public String getType() {
        return this.type;
    }

    public String getFriendlyType() {
        return this.friendlyType;
    }

    private void setType(String type) {
        this.type = type;
        if (!TYPES.containsKey(type)) {
            TYPES.put(type, this);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CyberSourceTransactionType other = (CyberSourceTransactionType)obj;
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

